/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.document;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.document.JspDocumentConverter;
import com.ibm.ws.jsp.translator.document.JspDocumentParser;
import com.ibm.ws.jsp.translator.document.JspEncodingScanner;
import com.ibm.ws.jsp.translator.document.JspPageParser;
import com.ibm.ws.jsp.translator.document.XMLEncodingDetector;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class Jsp2Dom {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.document.Jsp2Dom";
    static final String DEFAULT_ENCODING = "ISO-8859-1";
    static final String CONVERTED_DEFAULT_ENCODING = EncodingUtils.getJvmConverter("ISO-8859-1");
    private Stack directoryStack = null;
    private Stack dependencyStack = null;
    private List dependencyList = null;
    private Map cdataJspIdMap = null;
    private Map implicitTagLibMap = null;
    private JspInputSource jspInputSource = null;
    private String resolvedRelativeURL = null;
    private JspCoreContext context = null;
    private JspConfiguration jspConfiguration = null;
    private JspOptions jspOptions = null;
    private Boolean parentIsXml = null;
    private boolean isXml = false;
    String sourceEnc = null;
    boolean isEncodingSpecifiedInProlog = false;
    boolean isBomPresent = false;
    private boolean isDefaultPageEncoding = false;
    private boolean isServlet25 = false;

    public Jsp2Dom(JspInputSource jspInputSource, JspCoreContext context, JspConfiguration jspConfiguration, JspOptions jspOptions, Map implicitTagLibMap) {
        this.jspInputSource = jspInputSource;
        this.context = context;
        this.jspConfiguration = jspConfiguration;
        this.directoryStack = new Stack();
        this.directoryStack.push("/");
        this.dependencyStack = new Stack();
        this.dependencyList = new ArrayList();
        this.jspOptions = jspOptions;
        this.cdataJspIdMap = new HashMap();
        this.resolveBaseDir();
        this.implicitTagLibMap = implicitTagLibMap;
        this.isServlet25 = jspConfiguration.getServletVersion().equals("2.5");
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "Jsp2Dom", "Jsp2Dom 1 this.jspInputSource: [" + this.jspInputSource.getRelativeURL() + "]");
        }
    }

    public Jsp2Dom(JspInputSource jspInputSource, JspCoreContext context, Stack directoryStack, JspConfiguration jspConfiguration, JspOptions jspOptions, Stack dependencyStack, List dependencyList, Map cdataJspIdMap, Map implicitTagLibMap, boolean parentIsXml) {
        this.jspInputSource = jspInputSource;
        this.context = context;
        this.jspConfiguration = jspConfiguration;
        this.jspOptions = jspOptions;
        this.directoryStack = directoryStack;
        this.dependencyStack = dependencyStack;
        this.dependencyList = dependencyList;
        this.cdataJspIdMap = cdataJspIdMap;
        this.implicitTagLibMap = implicitTagLibMap;
        this.parentIsXml = parentIsXml;
        this.resolveBaseDir();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "Jsp2Dom", "Jsp2Dom 2 this.jspInputSource: [" + this.jspInputSource.getRelativeURL() + "]");
        }
    }

    public Document getJspDocument() throws JspCoreException {
        Document document = null;
        if (this.jspInputSource.isXmlDocument()) {
            document = new JspDocumentConverter(this.jspInputSource, this.resolvedRelativeURL, this.context, this.directoryStack, this.jspConfiguration, this.jspOptions, this.dependencyStack, this.dependencyList, this.cdataJspIdMap, this.implicitTagLibMap).convert();
            this.jspConfiguration.setIsXml(true);
        } else {
            this.getSyntaxAndEncoding();
            if (!(!this.isXml || !this.isEncodingSpecifiedInProlog || this.jspConfiguration.getPageEncoding() == null || this.jspConfiguration.getPageEncoding().equals(this.sourceEnc) || this.jspConfiguration.getPageEncoding().startsWith("UTF-16") && this.sourceEnc.startsWith("UTF-16"))) {
                throw new JspCoreException("jsp.error.prolog_config_encoding_mismatch", new Object[]{this.sourceEnc, this.jspConfiguration.getPageEncoding()});
            }
            if (!this.isDefaultPageEncoding && !this.isXml) {
                this.jspConfiguration.setResponseEncoding(this.sourceEnc);
            }
            document = this.isXml ? this.parseToDom() : this.getJspDocumentAsJspPage();
        }
        this.directoryStack.pop();
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getSyntaxAndEncoding() throws JspCoreException {
        InputStream is = null;
        BufferedReader br = null;
        try {
            this.isXml = false;
            boolean isExternal = false;
            boolean revert = false;
            if (this.jspConfiguration.isXmlSpecified()) {
                this.isXml = this.jspConfiguration.isXml();
                isExternal = true;
            } else if (this.jspInputSource.getRelativeURL().endsWith(".jspx") || this.jspInputSource.getRelativeURL().endsWith(".tagx")) {
                this.isXml = true;
                isExternal = true;
                this.jspConfiguration.setIsXml(true);
            }
            if (isExternal && !this.isXml) {
                this.sourceEnc = this.jspConfiguration.getPageEncoding();
                if (this.sourceEnc != null) {
                    return;
                }
                this.sourceEnc = DEFAULT_ENCODING;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "about to call detectXMLEncoding(), sourceEnc = {0}", new Object[]{this.sourceEnc});
                    logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "about to call detectXMLEncoding(), isXml = {0}", new Object[]{this.isXml});
                }
                this.detectXMLEncoding();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "back from detectXMLEncoding(), sourceEnc = {0}", new Object[]{this.sourceEnc});
                    logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "back from detectXMLEncoding(), isXml = {0}", new Object[]{this.isXml});
                }
                if (!this.isXml && this.sourceEnc.equals("UTF-8")) {
                    this.sourceEnc = DEFAULT_ENCODING;
                    revert = true;
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "Just reverted sourceEnc, sourceEnc = {0}", new Object[]{this.sourceEnc});
                    }
                }
            }
            if (this.isXml) {
                return;
            }
            String savedEncoding = this.sourceEnc;
            is = this.getInputStream();
            try {
                br = new BufferedReader(new InputStreamReader(is, this.sourceEnc), 8192);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "created BufferedReader with sourceEnc = {0}", new Object[]{this.sourceEnc});
                }
            }
            catch (IOException e) {
                throw new JspCoreException(e);
            }
            if (!isExternal) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "!isExternal about to call hasJspRoot()");
                }
                if (this.hasJspRoot(br)) {
                    if (revert) {
                        this.sourceEnc = "UTF-8";
                    }
                    this.isXml = true;
                    this.jspConfiguration.setIsXml(true);
                    return;
                }
                if (revert && this.isBomPresent) {
                    this.sourceEnc = "UTF-8";
                }
                this.isXml = false;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "after hasJspRoot(), sourceEnc = {0}", new Object[]{this.sourceEnc});
                    logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "after hasJspRoot(), isXml = {0}", new Object[]{this.isXml});
                }
            }
            String sourceEncFromConfig = null;
            String sourceEncFromDir = null;
            sourceEncFromConfig = this.jspConfiguration.getPageEncoding();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "from jspConfiguration, sourceEnc = {0}", new Object[]{sourceEncFromConfig});
            }
            try {
                br.reset();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "called br.reset()");
                }
            }
            catch (IOException e) {
                try {
                    is.close();
                    br.close();
                    is = this.getInputStream();
                    br = new BufferedReader(new InputStreamReader(is, savedEncoding), 8192);
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "created new BufferedReader with savedEncoding = {0}", new Object[]{savedEncoding});
                    }
                }
                catch (IOException ioe) {
                    throw new JspCoreException(ioe);
                }
            }
            sourceEncFromDir = savedEncoding;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "calling getPageEncodingForJspSyntax(br) with sourceEnc = {0}", new Object[]{sourceEncFromDir});
            }
            sourceEncFromDir = this.getPageEncodingForJspSyntax(br);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "back from getPageEncodingForJspSyntax(br), sourceEnc = {0}", new Object[]{sourceEncFromDir});
            }
            if (this.isBomPresent) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "BOM is present, attempt to use page encoding from BOM, sourceEnc = {0}", new Object[]{this.sourceEnc});
                }
                if (!(sourceEncFromConfig == null || sourceEncFromConfig.equals(this.sourceEnc) || sourceEncFromConfig.startsWith("UTF-16") && this.sourceEnc.startsWith("UTF-16"))) {
                    throw new JspCoreException("jsp.error.prolog_config_encoding_mismatch", new Object[]{this.sourceEnc, sourceEncFromConfig});
                }
                if (sourceEncFromDir == null) return;
                if (sourceEncFromDir.equals(this.sourceEnc)) return;
                if (sourceEncFromDir.startsWith("UTF-16")) {
                    if (this.sourceEnc.startsWith("UTF-16")) return;
                }
                throw new JspCoreException("jsp.error.prolog_config_encoding_mismatch", new Object[]{this.sourceEnc, sourceEncFromDir});
            }
            if (sourceEncFromConfig != null) {
                this.sourceEnc = sourceEncFromConfig;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "Attempt to use page encoding from config, sourceEnc = {0}", new Object[]{this.sourceEnc});
                }
                if (sourceEncFromDir == null) return;
                if (sourceEncFromConfig.equals(sourceEncFromDir)) return;
                if (!this.isServlet25) return;
                throw new JspCoreException("jsp.error.encoding.mismatch.config.pageencoding", new Object[]{sourceEncFromConfig, sourceEncFromDir});
            }
            if (sourceEncFromDir != null) {
                this.sourceEnc = sourceEncFromDir;
                if (!TraceComponent.isAnyTracingEnabled()) return;
                if (!logger.isLoggable(Level.FINER)) return;
                logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "Attempt to use page encoding from page directives, sourceEnc = {0}", new Object[]{this.sourceEnc});
                return;
            }
            this.sourceEnc = DEFAULT_ENCODING;
            this.isDefaultPageEncoding = true;
            if (!TraceComponent.isAnyTracingEnabled()) return;
            if (!logger.isLoggable(Level.FINER)) return;
            logger.logp(Level.FINER, CLASS_NAME, "getSyntaxAndEncoding", "sourceEnc was null, setting to default, sourceEnc = {0}", new Object[]{this.sourceEnc});
            return;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private boolean hasJspRoot(BufferedReader br) throws JspCoreException {
        boolean hasRoot = false;
        JspEncodingScanner scanner = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "hasJspRoot", "Using Encoding = {0}", new Object[]{this.sourceEnc});
        }
        scanner = new JspEncodingScanner(br);
        scanner.scan();
        hasRoot = scanner.jspRootFound();
        return hasRoot;
    }

    private String getPageEncodingForJspSyntax(BufferedReader br) throws JspCoreException {
        JspEncodingScanner scanner = null;
        String retEncoding = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "getPageEncodingForJspSyntax", " using Encoding = {0}", new Object[]{this.sourceEnc});
        }
        scanner = new JspEncodingScanner(br);
        scanner.scan();
        if (scanner.getEncoding() != null && !scanner.getEncoding().equals(DEFAULT_ENCODING)) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "getPageEncodingForJspSyntax", "Scanned Encoding = {0}", new Object[]{scanner.getEncoding()});
            }
            retEncoding = EncodingUtils.getJvmConverter(scanner.getEncoding());
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "getPageEncodingForJspSyntax", "Converted Scanned Encoding = {0}", new Object[]{retEncoding});
            }
        } else if (!CONVERTED_DEFAULT_ENCODING.equals(DEFAULT_ENCODING)) {
            retEncoding = CONVERTED_DEFAULT_ENCODING;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "getPageEncodingForJspSyntax", "Converted Default Encoding = {0}", new Object[]{retEncoding});
            }
        }
        return retEncoding;
    }

    private Document getJspDocumentAsJspPage() throws JspCoreException {
        Document document = null;
        InputStream is = null;
        BufferedReader br = null;
        try {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "getJspDocumentAsJspPage", " creating BufferedReader with encoding = {0}", new Object[]{this.sourceEnc});
            }
            is = this.getInputStream();
            String brEnc = !this.sourceEnc.startsWith("UTF-16") ? this.sourceEnc : "UTF-16";
            br = new BufferedReader(new InputStreamReader(is, brEnc), 8192);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "getJspDocumentAsJspPage", " CREATED BufferedReader with encoding = {0}", new Object[]{this.sourceEnc});
            }
            JspPageParser jspPageParser = new JspPageParser(br, this.jspInputSource, this.resolvedRelativeURL, this.context, this.directoryStack, this.jspConfiguration, this.jspOptions, this.dependencyStack, this.dependencyList, this.cdataJspIdMap, this.implicitTagLibMap);
            try {
                document = jspPageParser.parse();
            }
            catch (JspCoreException jce) {
                throw new JspCoreException(jspPageParser.buildLineNumberMessage(jce.getLocalizedMessage()));
            }
        }
        catch (IOException e) {
            throw new JspCoreException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document parseToDom() throws JspCoreException {
        Document document = null;
        InputStream is = this.getInputStream();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "Jsp2Dom", "parseToDom 1 this.jspInputSource: [" + this.jspInputSource.getRelativeURL() + "]");
        }
        try {
            InputSource inputSource = new InputSource(is);
            JspDocumentParser jspDocumentParser = new JspDocumentParser(this.jspInputSource, this.resolvedRelativeURL, this.context, this.jspConfiguration, this.jspOptions, this.directoryStack, this.dependencyStack, this.dependencyList, this.cdataJspIdMap, this.implicitTagLibMap, this.isBomPresent, this.isEncodingSpecifiedInProlog, this.sourceEnc);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "Jsp2Dom", "parseToDom 1 jspDocumentParser: [" + jspDocumentParser + "]");
            }
            try {
                document = jspDocumentParser.parse(inputSource);
            }
            catch (JspCoreException jce) {
                throw new JspCoreException(jspDocumentParser.buildLineNumberMessage(jce.getLocalizedMessage()));
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return document;
    }

    private void detectXMLEncoding() throws JspCoreException {
        Object[] ret;
        try {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "Jsp2Dom", "detectXMLEncoding about to call XMLEncodingDetector: [" + this.jspInputSource.getRelativeURL() + "]");
            }
            ret = XMLEncodingDetector.getEncoding(this.jspInputSource);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "Jsp2Dom", "detectXMLEncoding back from XMLEncodingDetector: [" + ret + "]");
            }
        }
        catch (IOException e1) {
            throw new JspCoreException(e1);
        }
        this.sourceEnc = (String)ret[0];
        if (((Boolean)ret[1]).booleanValue()) {
            this.isEncodingSpecifiedInProlog = true;
        }
        if (((Boolean)ret[2]).booleanValue()) {
            this.isBomPresent = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "Jsp2Dom", "detectXMLEncoding back from XMLEncodingDetector  sourceEnc: [" + this.sourceEnc + "]");
            logger.logp(Level.FINER, CLASS_NAME, "Jsp2Dom", "detectXMLEncoding back from XMLEncodingDetector  isEncodingSpecifiedInProlog: [" + this.isEncodingSpecifiedInProlog + "]");
            logger.logp(Level.FINER, CLASS_NAME, "Jsp2Dom", "detectXMLEncoding back from XMLEncodingDetector  isBomPresent: [" + this.isBomPresent + "]");
        }
    }

    protected InputStream getInputStream() throws JspCoreException {
        InputStream is = null;
        try {
            is = this.jspInputSource.getInputStream();
        }
        catch (IOException e) {
            String msg = JspCoreException.getMsg("jsp.error.failed.to.find.resource", new Object[]{this.jspInputSource.getRelativeURL()});
            throw new JspCoreException(msg, new FileNotFoundException(msg));
        }
        return is;
    }

    private void resolveBaseDir() {
        String relativeURL = this.jspInputSource.getRelativeURL();
        if (relativeURL.charAt(0) != '/') {
            this.resolvedRelativeURL = (String)this.directoryStack.peek() + relativeURL;
            this.jspInputSource = this.context.getJspInputSourceFactory().copyJspInputSource(this.jspInputSource, this.resolvedRelativeURL);
        } else {
            this.resolvedRelativeURL = relativeURL;
        }
        String baseDir = this.resolvedRelativeURL.substring(0, this.resolvedRelativeURL.lastIndexOf("/") + 1);
        this.directoryStack.push(baseDir);
    }

    public List getDependencyList() {
        return this.dependencyList;
    }

    public Map getCdataJspIdMap() {
        return this.cdataJspIdMap;
    }
}

