/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.document;

import com.ibm.ws.jsp.JspCoreException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ASCIIReader
extends Reader {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    protected InputStream fInputStream;
    protected byte[] fBuffer;

    public ASCIIReader(InputStream inputStream, int size) {
        this.fInputStream = inputStream;
        this.fBuffer = new byte[size];
    }

    public int read() throws IOException {
        int b0 = this.fInputStream.read();
        if (b0 > 128) {
            String msg = JspCoreException.getMsg("jsp.error.xml.invalidASCII", new Object[]{Integer.toString(b0)});
            throw new IOException(msg);
        }
        return b0;
    }

    public int read(char[] ch, int offset, int length) throws IOException {
        if (length > this.fBuffer.length) {
            length = this.fBuffer.length;
        }
        int count = this.fInputStream.read(this.fBuffer, 0, length);
        for (int i = 0; i < count; ++i) {
            byte b0 = this.fBuffer[i];
            if (b0 > 128) {
                String msg = JspCoreException.getMsg("jsp.error.xml.invalidASCII", new Object[]{Integer.toString(b0)});
                throw new IOException(msg);
            }
            ch[offset + i] = (char)b0;
        }
        return count;
    }

    public long skip(long n) throws IOException {
        return this.fInputStream.skip(n);
    }

    public boolean ready() throws IOException {
        return false;
    }

    public boolean markSupported() {
        return this.fInputStream.markSupported();
    }

    public void mark(int readAheadLimit) throws IOException {
        this.fInputStream.mark(readAheadLimit);
    }

    public void reset() throws IOException {
        this.fInputStream.reset();
    }

    public void close() throws IOException {
        this.fInputStream.close();
    }
}

