/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.compiler;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.translator.compiler.JspCompilerResultImpl;
import com.ibm.wsspi.jsp.compiler.JspCompiler;
import com.ibm.wsspi.jsp.compiler.JspCompilerResult;
import com.ibm.wsspi.jsp.compiler.JspLineId;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import com.sun.tools.javac.Main;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StandardJspCompiler
implements JspCompiler {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.compiler.StandardJspCompiler";
    private static Pattern warningPattern = Pattern.compile("[0-9]+ warning");
    private static String separatorString = System.getProperty("line.separator");
    protected CharArrayWriter out = null;
    protected String fullClasspath = null;
    protected String optimizedClasspath = null;
    protected String sourcepath = null;
    protected boolean isClassDebugInfo = false;
    protected boolean isDebugEnabled = false;
    protected boolean isVerbose = false;
    protected boolean isDeprecation = false;
    protected String jdkSourceLevel = null;
    protected String javaEncoding = null;
    protected boolean useOptimizedClasspath = false;

    public StandardJspCompiler(JspClassloaderContext context, JspOptions options, String optimizedClasspath, boolean useOptimizedClasspath) {
        this.fullClasspath = context.getClassPath() + File.pathSeparatorChar + options.getOutputDir().getPath();
        this.optimizedClasspath = optimizedClasspath;
        this.useOptimizedClasspath = useOptimizedClasspath;
        this.sourcepath = options.getOutputDir().getPath();
        this.isClassDebugInfo = options.isClassDebugInfo();
        this.isDebugEnabled = options.isDebugEnabled();
        this.isVerbose = options.isVerbose();
        this.isDeprecation = options.isDeprecation();
        this.javaEncoding = options.getJavaEncoding();
        this.jdkSourceLevel = options.getJdkSourceLevel();
        this.out = new CharArrayWriter();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "StandardJspCompiler", "Entering StandardJspCompiler.");
        }
    }

    public JspCompilerResult compile(JspResources[] jspResources, JspResources[] dependencyResources, Collection jspLineIds, List compilerOptions) {
        return this.compile(jspResources[0].getGeneratedSourceFile().getPath(), jspLineIds, compilerOptions);
    }

    public JspCompilerResult compile(String source, Collection jspLineIds, List compilerOptions) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "compile", "Entering StandardJspCompiler.compile");
        }
        this.out.reset();
        int rc = 0;
        String cp = null;
        boolean directoryCompile = source.charAt(0) == '@';
        cp = directoryCompile && !this.useOptimizedClasspath ? this.fullClasspath : this.optimizedClasspath;
        rc = this.runCompile(source, compilerOptions, cp);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "compile", "rc = " + rc + " directoryCompile = " + directoryCompile + " useOptimizedClasspath = " + this.useOptimizedClasspath);
        }
        String output = null;
        if (rc != 0 || rc == 0 && (this.isVerbose || this.isDeprecation)) {
            output = this.out.toString();
            if (rc != 0) {
                output = this.getJspLineErrors(output, jspLineIds);
            }
        }
        JspCompilerResultImpl result = new JspCompilerResultImpl(rc, output);
        return result;
    }

    private int runCompile(String source, List compilerOptions, String cp) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "compile", "Entering StandardJspCompiler.runCompile");
        }
        int rc = 0;
        List argList = this.buildArgList(source, compilerOptions, cp);
        String[] args = new String[argList.size()];
        args = argList.toArray(args);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "runCompile", "compiling " + source);
            logger.logp(Level.FINE, CLASS_NAME, "runCompile", "classpath [" + cp + "]");
        }
        long start = System.currentTimeMillis();
        rc = Main.compile(args, new PrintWriter(this.out));
        long end = System.currentTimeMillis();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "runCompile", "compile complete for " + source + " time = " + (end - start) + " Milliseconds rc = " + rc);
        }
        return rc;
    }

    private List buildArgList(String source, List compilerOptions, String classpath) {
        ArrayList<String> argList = new ArrayList<String>();
        if (this.isClassDebugInfo || this.isDebugEnabled) {
            argList.add("-g");
        }
        if (this.isVerbose) {
            argList.add("-verbose");
        }
        if (this.isDeprecation) {
            argList.add("-deprecation");
        }
        argList.add("-source");
        if (this.jdkSourceLevel.equals("14")) {
            argList.add("1.4");
        } else if (this.jdkSourceLevel.equals("15")) {
            argList.add("1.5");
        } else {
            argList.add("1.3");
        }
        argList.add("-encoding");
        argList.add(this.javaEncoding);
        argList.add("-XDjsrlimit=1000");
        argList.add("-sourcepath");
        argList.add(this.sourcepath);
        argList.add("-classpath");
        argList.add(classpath);
        if (compilerOptions != null) {
            for (int i = 0; i < compilerOptions.size(); ++i) {
                String compilerOption = (String)compilerOptions.get(i);
                if (compilerOption.equals("-verbose")) {
                    this.isVerbose = true;
                }
                if (compilerOption.equals("-deprecation")) {
                    this.isDeprecation = true;
                }
                argList.add(compilerOption);
            }
        }
        argList.add(source);
        return argList;
    }

    public String getJspLineErrors(String compilerOutput, Collection jspLineIds) {
        StringBuffer errorMsg = new StringBuffer();
        BufferedReader br = new BufferedReader(new StringReader(compilerOutput));
        try {
            String line = br.readLine();
            int warningIndex = -1;
            while (line != null) {
                int javaNameEnd = line.indexOf(".java:");
                String javaName = null;
                if (javaNameEnd > 0) {
                    javaName = line.substring(0, javaNameEnd + 5);
                    javaName = javaName.replace('\\', '/');
                    javaName = javaName.replace('/', File.separatorChar);
                }
                int beginColon = line.indexOf(58, 2);
                int endColon = line.indexOf(58, beginColon + 1);
                Matcher warningMatcher = warningPattern.matcher(line);
                String warningMatched = null;
                if (warningMatcher.find()) {
                    warningMatched = warningMatcher.group();
                }
                warningIndex = line.indexOf("warning:");
                if (!(javaName == null || beginColon < 0 || warningIndex >= 0 || warningMatched != null || endColon < 0 || line.startsWith("Note: ") || line.startsWith("[loaded ") || line.startsWith("] ") || line.startsWith("[parsed ") || line.startsWith("[[parsing started ") || line.startsWith("[parsing completed ") || line.startsWith("[loading ") || line.startsWith("[checking ") || line.startsWith("[wrote ") || line.startsWith("[total "))) {
                    try {
                        String nr = line.substring(beginColon + 1, endColon);
                        int lineNr = Integer.parseInt(nr);
                        String mapping = this.findMapping(jspLineIds, lineNr, javaName);
                        if (mapping == null) {
                            errorMsg.append(separatorString);
                        } else {
                            errorMsg.append(mapping);
                        }
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                errorMsg.append(line);
                errorMsg.append(separatorString);
                if (warningIndex >= 0) {
                    line = br.readLine();
                    errorMsg.append(line);
                    errorMsg.append(separatorString);
                    line = br.readLine();
                    errorMsg.append(line);
                    errorMsg.append(separatorString);
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (IOException e) {
            logger.logp(Level.WARNING, CLASS_NAME, "getJspLineErrors", "Failed to find line number mappings for compiler errors", e);
        }
        return errorMsg.toString();
    }

    private String findMapping(Collection jspLineIds, int lineNr, String javaName) {
        String errorMsg = null;
        for (JspLineId lineId : jspLineIds) {
            if (!lineId.getGeneratedFilePath().equals(javaName)) continue;
            if (lineId.getStartGeneratedLineCount() <= 1 && lineId.getStartGeneratedLineNum() == lineNr) {
                errorMsg = this.createErrorMsg(lineId, lineNr);
                break;
            }
            if (lineId.getStartGeneratedLineNum() > lineNr || lineId.getStartGeneratedLineNum() + lineId.getStartGeneratedLineCount() - 1 < lineNr) continue;
            errorMsg = this.createErrorMsg(lineId, lineNr);
            break;
        }
        return errorMsg;
    }

    private String createErrorMsg(JspLineId jspLineId, int errorLineNr) {
        StringBuffer compilerOutput = new StringBuffer();
        if (jspLineId.getSourceLineCount() <= 1) {
            Object[] objArray = new Object[]{new Integer(jspLineId.getStartSourceLineNum()), jspLineId.getFilePath()};
            if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number", objArray));
            } else {
                compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number.included.file", objArray));
            }
        } else {
            int actualLineNum = jspLineId.getStartSourceLineNum() + (errorLineNr - jspLineId.getStartGeneratedLineNum());
            if (actualLineNum >= jspLineId.getStartSourceLineNum() && actualLineNum <= jspLineId.getStartSourceLineNum() + jspLineId.getSourceLineCount() - 1) {
                Object[] objArray = new Object[]{new Integer(actualLineNum), jspLineId.getFilePath()};
                if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                    compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number", objArray));
                } else {
                    compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number.included.file", objArray));
                }
            } else {
                Object[] objArray = new Object[]{new Integer(jspLineId.getStartSourceLineNum()), new Integer(jspLineId.getStartSourceLineNum() + jspLineId.getSourceLineCount() - 1), jspLineId.getFilePath()};
                if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                    compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.multiple.line.number", objArray));
                } else {
                    compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.multiple.line.number.included.file", objArray));
                }
            }
        }
        compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.corresponding.servlet", new Object[]{jspLineId.getParentFile()}) + separatorString);
        return compilerOutput.toString();
    }
}

