/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.compiler;

import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.translator.compiler.JikesJspCompiler;
import com.ibm.ws.jsp.translator.compiler.StandardJspCompiler;
import com.ibm.wsspi.jsp.compiler.JspCompiler;
import com.ibm.wsspi.jsp.compiler.JspCompilerFactory;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JspCompilerFactoryImpl
implements JspCompilerFactory {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.compiler.JspCompilerFactoryImpl";
    private static final String WAS_ROOT_BASE = System.getProperty("was.install.root");
    private String absouluteContextRoot;
    private JspClassloaderContext classloaderContext;
    private JspOptions options;
    private String classpath = null;
    boolean useOptimizedClasspath = false;

    public JspCompilerFactoryImpl(String absouluteContextRoot, JspClassloaderContext classloaderContext, JspOptions options) {
        this.absouluteContextRoot = absouluteContextRoot;
        this.classloaderContext = classloaderContext;
        this.options = options;
        logger.logp(Level.FINE, CLASS_NAME, "JspCompilerFactoryImpl", "jspCompileClasspath: " + options.getJspCompileClasspath());
        if (WAS_ROOT_BASE != null) {
            this.classpath = classloaderContext.getOptimizedClassPath();
            if (options.getJspCompileClasspath() != null) {
                this.useOptimizedClasspath = true;
            }
        } else {
            this.classpath = classloaderContext.getClassPath() + File.pathSeparatorChar + options.getOutputDir().getPath();
            this.useOptimizedClasspath = true;
        }
    }

    public JspCompiler createJspCompiler() {
        if (this.options.isUseJikes()) {
            return new JikesJspCompiler(this.absouluteContextRoot, this.classloaderContext, this.options, this.classpath, this.useOptimizedClasspath);
        }
        return new StandardJspCompiler(this.classloaderContext, this.options, this.classpath, this.useOptimizedClasspath);
    }
}

