/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.tools;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.tools.AbstractJspModC;
import com.ibm.ws.jsp.translator.utils.NameMangler;
import com.ibm.wsspi.jsp.context.translation.JspTranslationContext;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class JspFileUtils {
    private static final String CLASS_NAME = "com.ibm.ws.jsp.tools.JspFileUtils";
    private static Pattern v4FilenamePattern = Pattern.compile("_jsp_[0-9]+\\.(dat|java)");
    private static Pattern classFilenamePattern = Pattern.compile("_[a-zA-Z0-9_$]*+\\.class");
    private Logger logger = null;

    public JspFileUtils() {
        this(null);
    }

    public JspFileUtils(Logger logger) {
        this.logger = logger;
    }

    public void removeVersion4Files(File directory, String outputDir) {
        int startPoint = outputDir.length();
        String pkgName = directory.toString().substring(startPoint);
        if (pkgName.length() == 0) {
            pkgName = "/";
        }
        String mangledDirName = pkgName = pkgName.replace('\\', '/');
        if (!pkgName.equals("/")) {
            mangledDirName = NameMangler.handlePackageName(pkgName);
            mangledDirName = mangledDirName.replace('.', '/');
        }
        if ((mangledDirName = mangledDirName.replace('\\', '/')).charAt(0) != '/') {
            mangledDirName = "/" + mangledDirName;
        }
        File v4Dir = null;
        v4Dir = outputDir.endsWith("/") ? new File(outputDir + mangledDirName.substring(1)) : new File(outputDir + mangledDirName.substring(0));
        if (mangledDirName.equals(pkgName)) {
            String classfileName = null;
            File[] v4List = v4Dir.listFiles(new WsFilenameFilter(v4FilenamePattern));
            if (v4List != null) {
                for (int i = 0; i < v4List.length; ++i) {
                    if (!v4List[i].isFile()) continue;
                    if (this.logger != null) {
                        this.logger.logp(Level.CONFIG, "JspFileUtils", "removeVersion4Files", "Deleting: " + v4List[i]);
                    }
                    v4List[i].delete();
                    classfileName = v4List[i].toString();
                    int end = classfileName.lastIndexOf("_jsp_");
                    classfileName = classfileName.substring(0, end);
                    classfileName = classfileName + ".class";
                    File clFile = new File(classfileName);
                    if (!clFile.exists() || !clFile.isFile()) continue;
                    if (this.logger != null) {
                        this.logger.logp(Level.CONFIG, "JspFileUtils", "removeVersion4Files", "Deleting: " + clFile.toString());
                    }
                    clFile.delete();
                }
            }
        } else if (v4Dir.exists()) {
            if (this.logger != null) {
                this.logger.logp(Level.CONFIG, "JspFileUtils", "removeVersion4Files", "Removing: " + v4Dir.toString());
                this.logger.logp(Level.CONFIG, "JspFileUtils", "removeVersion4Files", " ");
            }
            JspFileUtils.deleteDirs(v4Dir, this.logger);
        }
    }

    public void removeFixedPackageFiles(String outputDir, JspTranslationContext context, String resourcePath) {
        int endPoint = resourcePath.lastIndexOf(47);
        String pkgName = resourcePath.substring(0, endPoint);
        if (pkgName.length() == 0) {
            pkgName = "/";
        }
        if ((pkgName = pkgName.replace('\\', '/')).charAt(0) != '/') {
            pkgName = "/" + pkgName;
        }
        File dir = null;
        dir = outputDir.endsWith("/") ? new File(outputDir + pkgName.substring(1)) : new File(outputDir + pkgName.substring(0));
        String fileName = null;
        String classname = null;
        int index = 0;
        File[] fileList = dir.listFiles(new WsFilenameFilter(classFilenamePattern));
        if (fileList != null) {
            for (int i = 0; i < fileList.length; ++i) {
                if (!fileList[i].isFile() || (classname = fileList[i].toString()).indexOf(36) >= 0) continue;
                if (this.logger != null) {
                    this.logger.logp(Level.CONFIG, "JspFileUtils", "removeFixedPackageFiles", "checking to see if we can delete: " + fileList[i]);
                }
                classname = fileList[i].toString();
                classname = classname.replace('\\', '/');
                index = classname.lastIndexOf(47);
                classname = classname.substring(index);
                index = classname.lastIndexOf(46);
                ClassLoader targetLoader = AbstractJspModC.createClassLoader(classname = classname.substring(1, index), context, fileList[i].toString(), this.logger, false, dir, fileList[i]);
                if (targetLoader == null) continue;
                boolean canDelete = true;
                String fname = "com.ibm._jsp." + classname;
                if (!this.loadClass(fname, targetLoader) && !this.loadClass(fname = "org.apache.jsp." + classname, targetLoader)) {
                    canDelete = false;
                }
                if (!canDelete) continue;
                if (this.logger != null) {
                    this.logger.logp(Level.CONFIG, "JspFileUtils", "removeFixedPackageFiles", "Deleting: " + fileList[i]);
                }
                fileList[i].delete();
                fileName = fileList[i].toString();
                int end = fileName.lastIndexOf(".");
                fileName = fileName.substring(0, end);
                String javaFileName = fileName + ".java";
                String datFileName = fileName + ".dat";
                File clFile = new File(javaFileName);
                if (clFile.exists() && clFile.isFile()) {
                    if (this.logger != null) {
                        this.logger.logp(Level.CONFIG, "JspFileUtils", "removeFixedPackageFiles", "Deleting: " + clFile.toString());
                    }
                    clFile.delete();
                }
                if ((clFile = new File(datFileName)).exists() && clFile.isFile()) {
                    if (this.logger != null) {
                        this.logger.logp(Level.CONFIG, "JspFileUtils", "removeFixedPackageFiles", "Deleting: " + clFile.toString());
                    }
                    clFile.delete();
                }
                File[] icList = dir.listFiles(new InnerclassFilenameFilter(classname));
                for (int j = 0; j < icList.length; ++j) {
                    if (!icList[j].isFile()) continue;
                    if (this.logger != null) {
                        this.logger.logp(Level.CONFIG, "JspFileUtils", "removeFixedPackageFiles", "Deleting: " + icList[j].toString());
                    }
                    icList[j].delete();
                }
            }
        }
        if (dir.isDirectory()) {
            dir.delete();
        }
    }

    public static void deleteDirs(File file, Logger logger) {
        File[] files = file.listFiles();
        boolean didDelete = false;
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File aFile = files[i];
                if (aFile.isDirectory()) {
                    JspFileUtils.deleteDirs(aFile, logger);
                    continue;
                }
                didDelete = aFile.delete();
                if (logger == null) continue;
                logger.logp(Level.FINEST, "JspFileUtils", "deleteDirs", "Attempted to remove file " + aFile + ". Removal succeeded?: " + didDelete);
            }
        }
        didDelete = file.delete();
        if (logger != null) {
            logger.logp(Level.FINE, "JspFileUtils", "deleteDirs", "Attempted to remove directory " + file + ". Removal succeeded?: " + didDelete);
        }
    }

    private boolean loadClass(String className, ClassLoader targetLoader) {
        boolean retval = true;
        Object dependents = null;
        try {
            Class.forName(className, true, targetLoader).newInstance();
        }
        catch (Throwable e) {
            if (this.logger != null) {
                this.logger.logp(Level.FINE, "JspFileUtils", "loadClass", "Exception caught during loading classfile", e);
            }
            retval = false;
        }
        return retval;
    }

    public void createJspFileExtensionList(String list, List jspFileExtensions) {
        StringTokenizer st = new StringTokenizer(list, ": ;");
        while (st.hasMoreTokens()) {
            String ext = st.nextToken();
            if (jspFileExtensions.contains(ext)) {
                if (!TraceComponent.isAnyTracingEnabled() || !this.logger.isLoggable(Level.WARNING)) continue;
                this.logger.logp(Level.WARNING, CLASS_NAME, "createJspFileExtensionList", "duplicate value for jsp file extensions ", ext);
                continue;
            }
            jspFileExtensions.add(ext);
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: JspFileUtils <packagename> <classname>");
            return;
        }
        String pkgName = args[0];
        String className = args[1];
        String mangledPkgName = null;
        mangledPkgName = NameMangler.handlePackageName(pkgName);
        mangledPkgName = mangledPkgName.replace('.', '/');
        className = NameMangler.mangleClassName(className);
    }

    private static class WsFilenameFilter
    implements FilenameFilter {
        Pattern filePattern;

        public WsFilenameFilter(Pattern pattern) {
            this.filePattern = pattern;
        }

        public boolean accept(File dir, String name) {
            return this.filePattern.matcher(name).find();
        }
    }

    public static class InnerclassFilenameFilter
    implements FilenameFilter {
        String filename = null;

        public InnerclassFilenameFilter(String filename) {
            this.filename = filename;
        }

        public boolean accept(File dir, String name) {
            String nameStart;
            int dollarIndex = name.indexOf("$");
            return dollarIndex > -1 && this.filename.equals(nameStart = name.substring(0, dollarIndex));
        }
    }
}

