/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.tools;

import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.inputsource.JspInputSourceFactoryImpl;
import com.ibm.ws.jsp.translator.compiler.JDTCompilerFactory;
import com.ibm.ws.jsp.translator.compiler.JspCompilerFactoryImpl;
import com.ibm.ws.jsp.translator.resource.JspResourcesFactoryImpl;
import com.ibm.ws.webcontainer.util.ExtendedDocumentRootUtils;
import com.ibm.wsspi.jsp.compiler.JspCompilerFactory;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import com.ibm.wsspi.jsp.context.translation.JspTranslationContext;
import com.ibm.wsspi.jsp.context.translation.JspTranslationEnvironment;
import com.ibm.wsspi.jsp.resource.JspInputSourceFactory;
import com.ibm.wsspi.jsp.resource.translation.JspResourcesFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileBasedJspContext
implements JspTranslationContext {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.tools.FileBasedJspContext";
    private String docRoot = "";
    private boolean searchClasspathForResources = false;
    private ExtendedDocumentRootUtils edru;
    private URL contextURL = null;
    private JspResourcesFactory jspResourcesFactory = null;
    private JspInputSourceFactory jspInputSourceFactory = null;
    private JspClassloaderContext jspClassloaderContext = null;
    private JspCompilerFactory jspCompilerFactory = null;

    public FileBasedJspContext(String docRoot, JspOptions jspOptions, String extDocRoot, ClassLoader loader, JspClassloaderContext jspClassloaderContext, boolean searchClasspathForResources) {
        this.docRoot = docRoot;
        this.searchClasspathForResources = searchClasspathForResources;
        if (extDocRoot != null) {
            File baseDir = new File(docRoot);
            baseDir = baseDir.getParentFile();
            this.edru = new ExtendedDocumentRootUtils(baseDir.toString(), extDocRoot);
        }
        try {
            this.contextURL = new URL("file", null, this.getRealPath("/"));
        }
        catch (MalformedURLException e) {
            logger.logp(Level.WARNING, CLASS_NAME, "FileBasedJspContext", "Failed to create context URL for docRoot: " + docRoot, e);
        }
        this.jspResourcesFactory = new JspResourcesFactoryImpl(jspOptions, this);
        this.jspInputSourceFactory = new JspInputSourceFactoryImpl(this.contextURL, this.edru, this.searchClasspathForResources, loader);
        this.jspClassloaderContext = jspClassloaderContext;
        this.jspCompilerFactory = jspOptions.isUseJDKCompiler() ? new JspCompilerFactoryImpl(this.getRealPath("/"), jspClassloaderContext, jspOptions) : new JDTCompilerFactory(jspClassloaderContext.getClassLoader(), jspOptions);
    }

    public String getRealPath(String path) {
        return this.getRealPath(path, true);
    }

    public String getRealPath(String path, boolean checkExtDocRoot) {
        String realPath = "";
        realPath = path.startsWith("/") ? this.docRoot + path : this.docRoot + "/" + path;
        if (checkExtDocRoot && !new File(realPath).exists() && this.edru != null && this.edru.searchPathExists()) {
            try {
                this.edru.handleExtendedDocumentRoots(path);
                File extDocPath = this.edru.getMatchedFile();
                if (extDocPath != null) {
                    realPath = extDocPath.toString();
                }
            }
            catch (Exception fne_io) {
                // empty catch block
            }
        }
        return realPath;
    }

    public Set getResourcePaths(String path) {
        File[] fileList;
        HashSet<String> set = new HashSet<String>();
        File root = new File(this.docRoot + path);
        if (root.exists() && (fileList = root.listFiles()) != null) {
            for (int i = 0; i < fileList.length; ++i) {
                String resourcePath = fileList[i].getPath();
                resourcePath = resourcePath.substring(this.docRoot.length());
                resourcePath = resourcePath.replace('\\', '/');
                if (fileList[i].isDirectory() && !resourcePath.endsWith("/")) {
                    resourcePath = resourcePath + "/";
                }
                set.add(resourcePath);
            }
        }
        return set;
    }

    public JspResourcesFactory getJspResourcesFactory() {
        return this.jspResourcesFactory;
    }

    public JspInputSourceFactory getJspInputSourceFactory() {
        return this.jspInputSourceFactory;
    }

    public JspClassloaderContext getJspClassloaderContext() {
        return this.jspClassloaderContext;
    }

    public JspCompilerFactory getJspCompilerFactory() {
        return this.jspCompilerFactory;
    }

    public void setJspTranslationEnviroment(JspTranslationEnvironment jspEnvironment) {
    }
}

