/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.taglib.config;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.taglib.config.AvailabilityCondition;
import com.ibm.ws.jsp.taglib.config.AvailabilityConditionType;
import com.ibm.ws.jsp.taglib.config.GlobalTagLibConfig;
import com.ibm.ws.jsp.taglib.config.ImplicitTagLibConfig;
import com.ibm.ws.jsp.taglib.config.TldPathConfig;
import com.ibm.ws.jsp.translator.visitor.xml.ParserFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TagLibCacheConfigParser
extends DefaultHandler {
    public static final String DTD_PUBLIC_ID = "http://www.ibm.com/xml/ns/TagLibCacheConfig.xsd";
    public static final String DTD_RESOURCE_PATH = "/com/ibm/ws/jsp/tablib/config/TagLibCacheConfig.xsd";
    protected SAXParser saxParser = null;
    protected StringBuffer chars = null;
    protected String uri = null;
    protected String prefix = null;
    protected String location = null;
    protected String jarName = null;
    protected String type = null;
    protected String webinfFileName = null;
    protected String servletClassName = null;
    protected List implicitTagLibList = new ArrayList();
    protected List globalTagLibList = new ArrayList();
    protected ImplicitTagLibConfig implicitTagLibConfig = null;
    protected GlobalTagLibConfig globalTagLibConfig = null;
    protected TldPathConfig tldPathConfig = null;
    protected AvailabilityCondition availabilityCondition = null;

    public TagLibCacheConfigParser() throws JspCoreException {
        try {
            this.saxParser = ParserFactory.newSAXParser(false, true);
        }
        catch (ParserConfigurationException e) {
            throw new JspCoreException(e);
        }
        catch (SAXException e) {
            throw new JspCoreException(e);
        }
    }

    public void parse(InputStream is) throws JspCoreException {
        this.reset();
        try {
            ParserFactory.parseDocument(this.saxParser, is, (DefaultHandler)this);
        }
        catch (SAXException e) {
            if (e.getCause() != null) {
                throw new JspCoreException(e.getCause());
            }
            throw new JspCoreException(e);
        }
        catch (IOException e) {
            throw new JspCoreException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }

    public void startElement(String namespaceURI, String localName, String elementName, Attributes attrs) throws SAXException {
        this.chars = new StringBuffer();
        if (elementName.equals("global-taglib")) {
            this.globalTagLibConfig = new GlobalTagLibConfig();
        } else if (elementName.equals("tld-path")) {
            this.tldPathConfig = new TldPathConfig(attrs.getValue("path"), attrs.getValue("uri"), attrs.getValue("contains-listener-defs"));
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        for (int i = 0; i < length; ++i) {
            if (this.chars == null) continue;
            this.chars.append(ch[start + i]);
        }
    }

    public void endElement(String namespaceURI, String localName, String elementName) throws SAXException {
        if (elementName.equals("uri")) {
            this.uri = this.chars.toString().trim();
        } else if (elementName.equals("prefix")) {
            this.prefix = this.chars.toString().trim();
        } else if (elementName.equals("location")) {
            this.location = this.chars.toString().trim();
        } else if (elementName.equals("jar-name")) {
            this.jarName = this.chars.toString().trim();
        } else if (elementName.equals("type")) {
            this.type = this.chars.toString().trim();
        } else if (elementName.equals("webinf-filename")) {
            this.webinfFileName = this.chars.toString().trim();
        } else if (elementName.equals("servlet-classname")) {
            this.servletClassName = this.chars.toString().trim();
        } else if (elementName.equals("implict-taglib")) {
            this.implicitTagLibConfig = new ImplicitTagLibConfig(this.uri, this.prefix, this.location);
            this.implicitTagLibList.add(this.implicitTagLibConfig);
            this.implicitTagLibConfig = null;
        } else if (elementName.equals("global-taglib")) {
            this.globalTagLibConfig.setJarName(this.jarName);
            this.globalTagLibList.add(this.globalTagLibConfig);
            this.globalTagLibConfig = null;
        } else if (elementName.equals("tld-path")) {
            this.globalTagLibConfig.getTldPathList().add(this.tldPathConfig);
            this.tldPathConfig = null;
        } else if (elementName.equals("availability-condition")) {
            AvailabilityConditionType conditionType = null;
            String conditionValue = null;
            if (this.type.equalsIgnoreCase("WEBINF-FILE")) {
                conditionType = AvailabilityConditionType.webinfFileType;
                conditionValue = this.webinfFileName;
            } else if (this.type.equalsIgnoreCase("SERVLET-CLASSNAME")) {
                conditionType = AvailabilityConditionType.servletClassNameType;
                conditionValue = this.servletClassName;
            }
            this.availabilityCondition = new AvailabilityCondition(conditionType, conditionValue);
            this.tldPathConfig.getAvailabilityConditionList().add(this.availabilityCondition);
            this.availabilityCondition = null;
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource isrc = null;
        String resourcePath = null;
        if (publicId.equals(DTD_PUBLIC_ID)) {
            resourcePath = DTD_RESOURCE_PATH;
        }
        if (resourcePath != null) {
            InputStream input = this.getClass().getResourceAsStream(resourcePath);
            if (input == null) {
                throw new SAXException("jsp.error.internal.dtd.not.found");
            }
            isrc = new InputSource(input);
        }
        return isrc;
    }

    public List getGlobalTagLibList() {
        return this.globalTagLibList;
    }

    public List getImplicitTagLibList() {
        return this.implicitTagLibList;
    }

    private void reset() {
        this.uri = null;
        this.prefix = null;
        this.location = null;
        this.jarName = null;
        this.type = null;
        this.webinfFileName = null;
        this.servletClassName = null;
        this.implicitTagLibList = new ArrayList();
        this.globalTagLibList = new ArrayList();
        this.implicitTagLibConfig = null;
        this.globalTagLibConfig = null;
        this.tldPathConfig = null;
        this.availabilityCondition = null;
    }
}

