/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.taglib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfigurationManager;
import com.ibm.ws.jsp.taglib.GlobalTagLibraryCache;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.taglib.TldParser;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TagLibraryInfoProxy {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.taglib.TagLibraryInfoProxy";
    private String jarName = null;
    private String tldPath = null;
    private TagLibraryInfoImpl tli = null;
    private GlobalTagLibraryCache globalTagLibraryCache = null;
    private boolean containsListenerDefs = false;
    private List eventListenerList = null;

    public TagLibraryInfoProxy(String jarName, String tldPath, boolean containsListenerDefs, GlobalTagLibraryCache globalTagLibraryCache) {
        this.jarName = jarName;
        this.tldPath = tldPath;
        this.globalTagLibraryCache = globalTagLibraryCache;
        this.containsListenerDefs = containsListenerDefs;
    }

    public synchronized TagLibraryInfoImpl getTagLibraryInfoImpl(String prefix) {
        if (this.tli == null) {
            this.loadTld();
        }
        if (this.tli == null) {
            return this.tli;
        }
        return this.tli.copy(prefix);
    }

    public boolean containsListenerDefs() {
        return this.containsListenerDefs;
    }

    public synchronized List getEventListenerList() {
        if (this.eventListenerList == null) {
            this.loadTld();
        }
        return this.eventListenerList;
    }

    private void loadTld() {
        block11: {
            URL jarUrl = this.globalTagLibraryCache.getClassLoader().getResource(this.jarName);
            if (jarUrl != null) {
                JspInputSource tldInputSource = null;
                try {
                    JspConfigurationManager configManager = new JspConfigurationManager(Collections.EMPTY_LIST, false, true, Collections.EMPTY_LIST);
                    TldParser tldParser = new TldParser(this.globalTagLibraryCache, configManager, false);
                    URL url = new URL("jar:" + jarUrl.toString() + "!/");
                    tldInputSource = this.globalTagLibraryCache.getJspInputSourceFactory().createJspInputSource(url, this.tldPath);
                    this.tli = tldParser.parseTLD(tldInputSource, this.jarName);
                    if (this.tli.getReliableURN() != null) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "loadTld", "Global jar tld in proxy loaded for {0}", this.tli.getReliableURN());
                        }
                        this.tli.setURI(this.tli.getReliableURN());
                        if (this.containsListenerDefs) {
                            this.eventListenerList = new ArrayList();
                            this.eventListenerList.addAll(tldParser.getEventListenerList());
                        }
                    } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.WARNING)) {
                        logger.logp(Level.WARNING, CLASS_NAME, "loadTld", "jsp warning failed to find a uri tag in [" + tldInputSource.getAbsoluteURL() + "]");
                    }
                }
                catch (JspCoreException e) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.WARNING)) {
                        logger.logp(Level.WARNING, CLASS_NAME, "loadTld", "jsp warning failed to load tld in jar. uri = [" + tldInputSource.getAbsoluteURL() + "]", e);
                    }
                }
                catch (IOException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) break block11;
                    logger.logp(Level.WARNING, CLASS_NAME, "loadTld", "jsp warning failed to load tld in jar. uri = [" + tldInputSource.getAbsoluteURL() + "]", e);
                }
            }
        }
        if (this.eventListenerList == null) {
            this.eventListenerList = Collections.EMPTY_LIST;
        }
    }
}

