/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.taglib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfigurationManager;
import com.ibm.ws.jsp.configuration.JspXmlExtConfig;
import com.ibm.ws.jsp.taglib.ImplicitTagLibraryInfoImpl;
import com.ibm.ws.jsp.taglib.ImplicitTldParser;
import com.ibm.ws.jsp.taglib.TagClassInfo;
import com.ibm.ws.jsp.taglib.TagFileClassInfo;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.taglib.TagLibraryInfoProxy;
import com.ibm.ws.jsp.taglib.TldParser;
import com.ibm.ws.jsp.translator.JspTranslator;
import com.ibm.ws.jsp.translator.JspTranslatorFactory;
import com.ibm.ws.jsp.translator.optimizedtag.OptimizedTag;
import com.ibm.ws.jsp.translator.optimizedtag.OptimizedTagConfig;
import com.ibm.ws.jsp.translator.optimizedtag.OptimizedTagConfigParser;
import com.ibm.ws.jsp.translator.utils.NameMangler;
import com.ibm.ws.jsp.translator.utils.TagFileId;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.tagfilescan.TagFileScanResult;
import com.ibm.wsspi.jsp.context.translation.JspTranslationContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.jsp.resource.translation.TagFileResources;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;

public class TagLibraryCache
extends Hashtable {
    private static final long serialVersionUID = 3256719585204975926L;
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.taglib.TagLibraryCache";
    static final String TAGFILE_SCAN_ID = "TagFileScan";
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private JspTranslationContext ctxt = null;
    private TldParser tldParser = null;
    private Map tagClassMap = new HashMap();
    private Map tagFileResourcesMap = new HashMap();
    private Map implicitTagLibPrefixMap = new HashMap();
    private Map optimizedTagConfigMap = null;
    private Map looseLibMap = null;
    private List eventListenerList = new ArrayList();
    private JspConfigurationManager configManager = null;
    private String outputDir = null;
    private Map tagFileLockMap = null;
    private JspOptions jspOptions = null;

    public TagLibraryCache(JspTranslationContext ctxt, Map webxmlTagLibMap, JspOptions jspOptions, JspConfigurationManager configManager, Map globalMap, Map implicitMap, Map optimizedTagMap) throws JspCoreException {
        this.ctxt = ctxt;
        this.configManager = configManager;
        this.jspOptions = jspOptions;
        this.outputDir = jspOptions.getOutputDir().getPath();
        if (jspOptions.getLooseLibMap() != null) {
            this.looseLibMap = jspOptions.getLooseLibMap();
        }
        this.tldParser = new TldParser(ctxt, configManager, false);
        List loadedLocations = this.loadWebXmlMap(webxmlTagLibMap);
        this.loadLibJarMap(loadedLocations);
        this.loadWebInfMap("/WEB-INF", loadedLocations);
        this.loadWebInfTagFiles("/WEB-INF/tags");
        if (jspOptions.isUseImplicitTagLibs() && (jspOptions.getTranslationContextClass() == null || jspOptions.getTranslationContextClass() != null && jspOptions.getTranslationContextClass().equals("com.ibm.ws.jsp.inmemory.context.InMemoryJspTranslationContext"))) {
            for (String uri : globalMap.keySet()) {
                if (this.containsKey(uri)) continue;
                Object o = globalMap.get(uri);
                if (o instanceof TagLibraryInfoImpl) {
                    TagLibraryInfoImpl impl = (TagLibraryInfoImpl)o;
                    TagLibraryInfoImpl tli = impl.copy("");
                    this.put(uri, tli);
                    continue;
                }
                if (!(o instanceof TagLibraryInfoProxy)) continue;
                this.put(uri, o);
            }
            this.implicitTagLibPrefixMap.putAll(implicitMap);
        }
        if (jspOptions.isUseOptimizedTags()) {
            JspInputSource inputSource = ctxt.getJspInputSourceFactory().createJspInputSource("/WEB-INF/optimizedtags.xml");
            try {
                InputStream is = inputSource.getInputStream();
                if (is != null) {
                    OptimizedTagConfigParser optimizedTagConfigParser = new OptimizedTagConfigParser(ctxt);
                    this.optimizedTagConfigMap = optimizedTagConfigParser.parse(is);
                } else {
                    this.optimizedTagConfigMap = new HashMap();
                }
            }
            catch (IOException e) {
                this.optimizedTagConfigMap = new HashMap();
            }
            this.optimizedTagConfigMap.putAll(optimizedTagMap);
        }
    }

    private List loadWebXmlMap(Map webxmlTagLibMap) throws JspCoreException {
        ArrayList<String> loadedLocations = new ArrayList<String>();
        for (String taglibUri : webxmlTagLibMap.keySet()) {
            String loadedLocation;
            TagLibraryInfoImpl tli;
            String taglibLocation;
            block7: {
                if (this.containsKey(taglibUri)) continue;
                taglibLocation = (String)webxmlTagLibMap.get(taglibUri);
                tli = null;
                loadedLocation = taglibLocation;
                if (taglibLocation.endsWith(".jar")) {
                    tli = this.loadTaglibTldFromJar(taglibLocation);
                    loadedLocation = loadedLocation + "/META-INF/taglib.tld";
                } else {
                    JspInputSource inputSource = this.ctxt.getJspInputSourceFactory().createJspInputSource(taglibLocation);
                    try {
                        tli = this.tldParser.parseTLD(inputSource, "webinf");
                    }
                    catch (JspCoreException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) break block7;
                        logger.logp(Level.WARNING, CLASS_NAME, "loadWebXmlMap", "jsp warning failed to load tld at [" + taglibLocation + "]");
                    }
                }
            }
            if (tli == null) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                logger.logp(Level.WARNING, CLASS_NAME, "loadWebXmlMap", "jsp warning failed to load tld at [" + taglibLocation + "]");
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "loadWebXmlMap", "webxml tld loaded for {0}", taglibUri);
            }
            this.put(taglibUri, tli);
            tli.setURI(taglibUri);
            loadedLocations.add(loadedLocation);
            this.eventListenerList.addAll(this.tldParser.getEventListenerList());
        }
        return loadedLocations;
    }

    private void loadLibJarMap(List loadedLocations) {
        Set libSet = this.ctxt.getResourcePaths("/WEB-INF/lib");
        if (libSet != null) {
            for (String resourcePath : libSet) {
                if (!resourcePath.endsWith(".jar")) continue;
                this.loadTldsFromJar(resourcePath, loadedLocations);
            }
        }
    }

    protected void loadTldsFromJar(String resourcePath, List loadedLocations) {
        block2: {
            try {
                JspInputSource inputSource = this.ctxt.getJspInputSourceFactory().createJspInputSource(resourcePath);
                URL url = new URL("jar:" + inputSource.getAbsoluteURL().toExternalForm() + "!/");
                this.loadTldsFromJar(url, resourcePath, loadedLocations, null);
            }
            catch (MalformedURLException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) break block2;
                logger.logp(Level.WARNING, CLASS_NAME, "loadTldsFromJar", "jsp error failed to load tld in jar. uri = [" + resourcePath + "]", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTldsFromJar(URL url, String resourcePath, List loadedLocations, JspXmlExtConfig webAppConfig) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "loadTldsFromJar", "url [" + url + "]" + "resourcePath [" + resourcePath + "] loadedLocations [" + loadedLocations + "] webAppConfig [" + webAppConfig + "]");
        }
        ZipFile jarFile = null;
        InputStream stream = null;
        String name = null;
        try {
            JarURLConnection conn = (JarURLConnection)url.openConnection();
            conn.setUseCaches(false);
            jarFile = conn.getJarFile();
            String originatorId = jarFile.getName();
            originatorId = originatorId.substring(0, originatorId.indexOf(".jar"));
            if (originatorId.indexOf(File.separatorChar) != -1) {
                originatorId = originatorId.substring(originatorId.lastIndexOf(File.separatorChar) + 1);
            }
            originatorId = NameMangler.mangleString(originatorId);
            Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
            while (entries.hasMoreElements()) {
                block30: {
                    JarEntry entry = entries.nextElement();
                    name = entry.getName();
                    if (!name.startsWith("META-INF/") || !name.endsWith(".tld") || loadedLocations.contains(resourcePath + "/" + name)) continue;
                    stream = ((JarFile)jarFile).getInputStream(entry);
                    JspInputSource tldInputSource = this.ctxt.getJspInputSourceFactory().createJspInputSource(url, name);
                    try {
                        TagLibraryInfoImpl tli = this.tldParser.parseTLD(tldInputSource, stream, originatorId);
                        String uri = null;
                        uri = tli.getReliableURN() != null && !tli.getReliableURN().trim().equals("") ? tli.getReliableURN() : resourcePath + "/" + name;
                        tli.setURI(uri);
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "loadTldsFromJar", "webAppConfig is " + webAppConfig);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE) && webAppConfig != null) {
                            logger.logp(Level.FINE, CLASS_NAME, "loadTldsFromJar", "tli URN is " + uri + " :webAppConfig.getTagLibMap() is " + webAppConfig.getTagLibMap() + " :webAppConfig.getTagLibMap().containsKey(uri) is " + webAppConfig.getTagLibMap().containsKey(uri) + " :containsKey(uri) is " + this.containsKey(uri));
                        }
                        if (webAppConfig != null && !webAppConfig.getTagLibMap().containsKey(uri) || webAppConfig == null && !this.containsKey(uri)) {
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "loadTldsFromJar", "jar tld loaded for {0}", uri);
                            }
                            this.put(uri, tli);
                            this.eventListenerList.addAll(this.tldParser.getEventListenerList());
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "loadTldsFromJar", "tldParser.getEventListenerList() [" + this.tldParser.getEventListenerList() + "]");
                            }
                        }
                    }
                    catch (JspCoreException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) break block30;
                        logger.logp(Level.WARNING, CLASS_NAME, "loadTldsFromJar", "jsp error failed to load tld in jar. uri = [" + resourcePath + "]", e);
                    }
                }
                stream.close();
                stream = null;
            }
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.WARNING)) {
                logger.logp(Level.WARNING, CLASS_NAME, "loadTldsFromJar", "jsp error failed to load tld in jar. uri = [" + resourcePath + "]", e);
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable t) {}
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    private void loadWebInfMap(String webInfPath, List loadedLocations) {
        Set libSet = this.ctxt.getResourcePaths(webInfPath);
        if (libSet != null) {
            for (String resourcePath : libSet) {
                if (resourcePath.endsWith(".tld") && !loadedLocations.contains(resourcePath)) {
                    try {
                        JspInputSource inputSource = this.ctxt.getJspInputSourceFactory().createJspInputSource(resourcePath);
                        TagLibraryInfoImpl tli = this.tldParser.parseTLD(inputSource, "webinf");
                        String uri = null;
                        uri = tli.getReliableURN() != null && !tli.getReliableURN().trim().equals("") ? tli.getReliableURN() : resourcePath;
                        tli.setURI(uri);
                        if (this.containsKey(uri)) continue;
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "loadWebInfMap", "webinf tld loaded for {0}", uri);
                        }
                        this.put(uri, tli);
                        this.eventListenerList.addAll(this.tldParser.getEventListenerList());
                    }
                    catch (JspCoreException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                        logger.logp(Level.WARNING, CLASS_NAME, "loadWebInfMap", "webinf tld failed to load for resourcePath =[" + resourcePath + "]", e);
                    }
                    continue;
                }
                if (!resourcePath.endsWith("/")) continue;
                this.loadWebInfMap(resourcePath.substring(0, resourcePath.lastIndexOf(47)), loadedLocations);
            }
        }
    }

    private void loadWebInfTagFiles(String tagsDir) throws JspCoreException {
        Set libSet = this.ctxt.getResourcePaths(tagsDir);
        ArrayList<TagFileInfo> list = new ArrayList<TagFileInfo>();
        TagLibraryInfo tli = null;
        boolean succeeded = true;
        if (libSet != null) {
            ImplicitTldParser ImplicitTldParser2 = new ImplicitTldParser(this.ctxt, this.configManager, false);
            for (String resourcePath : libSet) {
                if (resourcePath.endsWith("/")) {
                    this.loadWebInfTagFiles(resourcePath.substring(0, resourcePath.lastIndexOf(47)));
                    continue;
                }
                if (!resourcePath.endsWith("/implicit.tld")) continue;
                try {
                    JspInputSource inputSource = this.ctxt.getJspInputSourceFactory().createJspInputSource(resourcePath);
                    tli = ImplicitTldParser2.parseTLD(inputSource, "webinf");
                    if (tli == null || !TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                    logger.logp(Level.FINE, CLASS_NAME, "loadWebInfTagFiles", "Got TagLibraryInfoImpl for [{0}], TLD file [{1}]", new Object[]{tagsDir, resourcePath});
                }
                catch (JspCoreException e) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.WARNING)) {
                        logger.logp(Level.WARNING, CLASS_NAME, "loadWebInfTagFiles", "webinf tagfile directory tld failed to load for resourcePath =[" + resourcePath + "]", e);
                    }
                    succeeded = false;
                }
            }
            if (succeeded) {
                JspInputSource inputSource = this.ctxt.getJspInputSourceFactory().createJspInputSource(tagsDir);
                ImplicitTagLibraryInfoImpl implicitTli = new ImplicitTagLibraryInfoImpl(tagsDir, inputSource);
                if (tli != null) {
                    if (tli.getRequiredVersion() != null) {
                        implicitTli.setRequiredVersion(tli.getRequiredVersion());
                    }
                    if (((TagLibraryInfoImpl)tli).getTlibversion() != null) {
                        implicitTli.setTlibversion(((TagLibraryInfoImpl)tli).getTlibversion());
                    }
                }
                for (String resourcePath : libSet) {
                    if (!resourcePath.endsWith(".tag") && !resourcePath.endsWith(".tagx")) continue;
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            logger.logp(Level.FINEST, CLASS_NAME, "loadWebInfTagFiles", "about to do tagfilescan for = [" + resourcePath + "]");
                        }
                        JspInputSource tagFileInputSource = this.ctxt.getJspInputSourceFactory().copyJspInputSource(implicitTli.getInputSource(), resourcePath);
                        JspTranslator jspTranslator = JspTranslatorFactory.getFactory().createTranslator(TAGFILE_SCAN_ID, tagFileInputSource, this.ctxt, this.configManager.createJspConfiguration(), this.jspOptions, this.implicitTagLibPrefixMap);
                        JspVisitorInputMap inputMap = new JspVisitorInputMap();
                        inputMap.put("TagLibraryInfo", implicitTli);
                        String name = resourcePath.substring(resourcePath.lastIndexOf(47) + 1);
                        name = name.substring(0, name.indexOf(".tag"));
                        inputMap.put("TagFileName", name);
                        inputMap.put("TagFilePath", resourcePath);
                        HashMap results = jspTranslator.processVisitors(inputMap);
                        TagFileScanResult result = (TagFileScanResult)results.get(TAGFILE_SCAN_ID);
                        TagFileInfo tfi = new TagFileInfo(name, resourcePath, result.getTagInfo());
                        list.add(tfi);
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINEST)) continue;
                        logger.logp(Level.FINEST, CLASS_NAME, "loadWebInfTagFiles", "TagLibraryCache TagFileInfo tfi= [" + tfi + "]");
                    }
                    catch (JspCoreException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                        logger.logp(Level.WARNING, CLASS_NAME, "loadWebInfTagFiles", "webinf tagfile failed to scan =[" + resourcePath + "]", e);
                    }
                }
                if (list.size() > 0) {
                    implicitTli.setTagFiles(list);
                    list.clear();
                    implicitTli.setFunctions(list);
                    implicitTli.setTags(list);
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "loadWebInfTagFiles", "Adding ImplicitTagLibraryInfoImpl for [{0}]", tagsDir);
                        logger.logp(Level.FINE, CLASS_NAME, "loadWebInfTagFiles", "  ImplicitTagLibraryInfoImpl=[{0}]", implicitTli);
                    }
                    this.put(tagsDir, implicitTli);
                } else if (tli != null) {
                    this.put(tagsDir, tli);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TagLibraryInfoImpl loadTaglibTldFromJar(String uri) {
        TagLibraryInfoImpl tli;
        block39: {
            tli = null;
            if (this.looseLibMap != null && this.looseLibMap.containsKey(uri)) {
                String tldLocation = (String)this.looseLibMap.get(uri);
                try {
                    URL looseLibURL = new File(tldLocation).toURL();
                    JspInputSource inputSource = this.ctxt.getJspInputSourceFactory().createJspInputSource(looseLibURL, "META-INF/taglib.tld");
                    tli = this.tldParser.parseTLD(inputSource, "webinf");
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "loadTaglibTldFromJar", "tld loaded for [{0}]", uri);
                    }
                    break block39;
                }
                catch (JspCoreException e) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.WARNING)) {
                        logger.logp(Level.WARNING, CLASS_NAME, "loadTaglibTldFromJar", "jsp error failed to parse loose library tld . location = [" + tldLocation + "]", e);
                    }
                    break block39;
                }
                catch (MalformedURLException e) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.WARNING)) {
                        logger.logp(Level.WARNING, CLASS_NAME, "loadTaglibTldFromJar", "jsp error failed to parse loose library tld . location = [" + tldLocation + "]", e);
                    }
                    break block39;
                }
            }
            InputStream stream = null;
            ZipFile jarFile = null;
            try {
                JspInputSource inputSource = this.ctxt.getJspInputSourceFactory().createJspInputSource(uri);
                URL url = new URL("jar:" + inputSource.getAbsoluteURL().toExternalForm() + "!/");
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                conn.setUseCaches(false);
                try {
                    jarFile = conn.getJarFile();
                }
                catch (IOException e) {
                    URL jarurl = this.ctxt.getJspClassloaderContext().getClassLoader().getResource(uri);
                    if (jarurl != null) {
                        jarurl = new URL("jar:" + jarurl.toExternalForm() + "!/");
                        conn = (JarURLConnection)jarurl.openConnection();
                        conn.setUseCaches(false);
                        jarFile = conn.getJarFile();
                    }
                    throw new JspCoreException("jsp.error.unable.to.locate.tld.jar.file", new Object[]{uri});
                }
                Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.equals("META-INF/taglib.tld")) continue;
                    stream = ((JarFile)jarFile).getInputStream(entry);
                    String originatorId = jarFile.getName();
                    if ((originatorId = originatorId.substring(0, originatorId.indexOf(".jar"))).indexOf(File.separatorChar) != -1) {
                        originatorId = originatorId.substring(originatorId.lastIndexOf(File.separatorChar) + 1);
                    }
                    originatorId = NameMangler.mangleString(originatorId);
                    JspInputSource tldInputSource = this.ctxt.getJspInputSourceFactory().createJspInputSource(url, "META-INF/taglib.tld");
                    tli = this.tldParser.parseTLD(tldInputSource, stream, originatorId);
                    if (tli == null || !TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                    logger.logp(Level.FINE, CLASS_NAME, "loadTaglibTldFromJar", "tld loaded for [{0}]", uri);
                }
            }
            catch (JspCoreException e) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.WARNING)) {
                    logger.logp(Level.WARNING, CLASS_NAME, "loadTaglibTldFromJar", "jsp error failed to parse tld in jar. uri = [" + uri + "]", e);
                }
            }
            catch (IOException e) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.WARNING)) {
                    logger.logp(Level.WARNING, CLASS_NAME, "loadTaglibTldFromJar", "jsp error failed to parse tld in jar. uri = [" + uri + "]", e);
                }
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {}
                }
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
        return tli;
    }

    public synchronized TagLibraryInfoImpl getTagLibraryInfo(String uri, String prefix, String jspUri) {
        TagLibraryInfoImpl tli;
        block13: {
            int type = TagLibraryCache.uriType(uri);
            tli = null;
            if (this.containsKey(uri)) {
                TagLibraryInfoProxy proxy;
                Object o = this.get(uri);
                if (o instanceof TagLibraryInfoImpl) {
                    TagLibraryInfoImpl impl = (TagLibraryInfoImpl)o;
                    tli = impl.copy(prefix);
                } else if (o instanceof TagLibraryInfoProxy && (tli = (proxy = (TagLibraryInfoProxy)o).getTagLibraryInfoImpl(prefix)) != null) {
                    this.put(uri, tli);
                }
            } else if (type == 1 || type == 2) {
                if (uri.endsWith(".jar")) {
                    TagLibraryInfoImpl impl = this.loadTaglibTldFromJar(uri);
                    if (impl != null) {
                        impl.setURI(uri);
                        this.put(uri, impl);
                        tli = impl.copy(prefix);
                    }
                } else {
                    try {
                        JspInputSource tldInputSource;
                        TagLibraryInfoImpl impl = null;
                        String path = uri;
                        if (type == 2) {
                            path = jspUri.substring(0, jspUri.lastIndexOf("/") + 1);
                            path = path + uri;
                        }
                        if ((impl = this.tldParser.parseTLD(tldInputSource = this.ctxt.getJspInputSourceFactory().createJspInputSource(path), "webinf")) != null) {
                            impl.setURI(uri);
                            this.put(uri, impl);
                            tli = impl.copy(prefix);
                        }
                    }
                    catch (JspCoreException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) break block13;
                        logger.logp(Level.WARNING, CLASS_NAME, "getTagLibraryInfo", "jsp error failed to parse tld in WEB-INF. uri = [" + uri + "]", e);
                    }
                }
            }
        }
        return tli;
    }

    public synchronized TagFileResources getTagFileResources(TagFileResources tagFileResources) {
        if (!this.tagFileResourcesMap.containsKey(tagFileResources.getInputSource().getAbsoluteURL().toExternalForm())) {
            this.tagFileResourcesMap.put(tagFileResources.getInputSource().getAbsoluteURL().toExternalForm(), tagFileResources);
            return tagFileResources;
        }
        return (TagFileResources)this.tagFileResourcesMap.get(tagFileResources.getInputSource().getAbsoluteURL().toExternalForm());
    }

    public synchronized TagClassInfo getTagClassInfo(TagInfo tag) {
        return (TagClassInfo)this.tagClassMap.get(tag.getTagClassName());
    }

    public synchronized void addTagClassInfo(TagInfo ti, Class tagClass) {
        this.tagClassMap.put(ti.getTagClassName(), new TagClassInfo(tagClass));
    }

    public synchronized void addTagFileClassInfo(TagFileInfo tfi) {
        this.tagClassMap.put(tfi.getTagInfo().getTagClassName(), new TagFileClassInfo(tfi.getTagInfo()));
    }

    public synchronized void reloadTld(String tldFilePath, long timestamp) throws JspCoreException {
        TagLibraryInfoImpl oldTli;
        String tliKey = null;
        for (String key : this.keySet()) {
            TagLibraryInfoImpl tli;
            Object o = this.get(key);
            if (!(o instanceof TagLibraryInfoImpl) || (tli = (TagLibraryInfoImpl)o).getTldFilePath() == null || !tli.getTldFilePath().equals(tldFilePath)) continue;
            tliKey = key;
            break;
        }
        if (tliKey != null && (oldTli = (TagLibraryInfoImpl)this.get(tliKey)).getLoadedTimestamp() < timestamp) {
            TagLibraryInfoImpl tli = this.tldParser.parseTLD(oldTli.getInputSource(), "webinf");
            tli.setURI(oldTli.getURI());
            this.put(tliKey, tli);
            oldTli = null;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "reloadTld", "tld [{0}] reloaded", tldFilePath);
            }
        }
    }

    public synchronized TagLibraryInfoImpl reloadImplicitTld(String tagDir) throws JspCoreException {
        TagLibraryInfoImpl tli = null;
        if (this.containsKey(tagDir)) {
            this.remove(tagDir);
            this.loadWebInfTagFiles(tagDir);
            tli = (TagLibraryInfoImpl)this.get(tagDir);
        }
        return tli;
    }

    public Map getImplicitTagLibPrefixMap() {
        return this.implicitTagLibPrefixMap;
    }

    public List getEventListenerList() {
        return this.eventListenerList;
    }

    public synchronized OptimizedTag getOptimizedTag(String tlibUri, String tlibVersion, String shortName) {
        OptimizedTag optTag = null;
        String key = tlibUri + tlibVersion + shortName;
        if (this.optimizedTagConfigMap.containsKey(key)) {
            OptimizedTagConfig optTagConfig = (OptimizedTagConfig)this.optimizedTagConfigMap.get(key);
            try {
                optTag = (OptimizedTag)optTagConfig.getOptClass().newInstance();
            }
            catch (InstantiationException e) {
                logger.logp(Level.WARNING, CLASS_NAME, "getOptimizedTag", "failed to instantiate optimized tag [" + optTagConfig.getOptClass() + "]", e);
            }
            catch (IllegalAccessException e) {
                logger.logp(Level.WARNING, CLASS_NAME, "getOptimizedTag", "Illegal access of optimized tag [" + optTagConfig.getOptClass() + "]", e);
            }
        }
        return optTag;
    }

    public synchronized Object getTagFileLock(List tagFileIdList) {
        Object lock = null;
        if (this.tagFileLockMap == null) {
            this.tagFileLockMap = new HashMap();
        }
        for (TagFileId tagFileId : tagFileIdList) {
            Object o = this.tagFileLockMap.get(tagFileId.toString());
            if (o == null) continue;
            lock = o;
            break;
        }
        if (lock == null) {
            lock = new Object();
            for (TagFileId tagFileId : tagFileIdList) {
                this.tagFileLockMap.put(tagFileId.toString(), lock);
            }
        }
        return lock;
    }

    public synchronized void releaseTagFileLock(List tagFileIdList) {
        for (TagFileId tagFileId : tagFileIdList) {
            this.tagFileLockMap.remove(tagFileId.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TagLibraryInfoImpl loadSerializedTld(JspInputSource source, JspInputSource comparisonSource) {
        TagLibraryInfoImpl tli = null;
        String sourceFile = source.getAbsoluteURL().toExternalForm().replace('\\', '_');
        sourceFile = sourceFile.replace('/', '_');
        File serialixedTliFile = new File(this.outputDir + File.separator + NameMangler.mangleString(sourceFile) + ".ser");
        if (serialixedTliFile.exists() && serialixedTliFile.lastModified() >= comparisonSource.getLastModified()) {
            ObjectInputStream ois = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(serialixedTliFile);
                ois = new ObjectInputStream(fis);
                tli = (TagLibraryInfoImpl)ois.readObject();
                if (tli != null) {
                    System.out.println("tld loaded from " + serialixedTliFile.getPath());
                }
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return tli;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeTld(JspInputSource source, TagLibraryInfoImpl tli) {
        String sourceFile = source.getAbsoluteURL().toExternalForm().replace('\\', '_');
        sourceFile = sourceFile.replace('/', '_');
        File serialixedTliFile = new File(this.outputDir + File.separator + NameMangler.mangleString(sourceFile) + ".ser");
        System.out.println("serialixedTliFile = " + serialixedTliFile.getPath());
        ObjectOutputStream oos = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(serialixedTliFile);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(tli);
            System.out.println("tld serialized to " + serialixedTliFile.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static int uriType(String uri) {
        if (uri.indexOf(58) != -1) {
            return 0;
        }
        if (uri.startsWith("/")) {
            return 1;
        }
        return 2;
    }
}

