/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.taglib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfigurationManager;
import com.ibm.ws.jsp.taglib.TldParser;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ImplicitTldParser
extends TldParser {
    protected static Logger logger;
    protected static Level logLevel;
    private static final String CLASS_NAME = "com.ibm.ws.jsp.taglib.ImplicitTldParser";
    private static final String TLIB_VERSION = "1.0";
    private static final String JSP_VERSION = "2.0";
    String tlibversion = "1.0";
    String jspversion = "2.0";

    public ImplicitTldParser(JspCoreContext ctxt, JspConfigurationManager configManager, boolean validateTLDs) throws JspCoreException {
        super(ctxt, configManager, validateTLDs);
    }

    public void startElement(String namespaceURI, String localName, String elementName, Attributes attrs) throws SAXException {
        this.chars = new StringBuffer();
        if (elementName.equals("taglib")) {
            this.currentElement = 1;
            this.tli.setTlibversion(this.tlibversion);
            this.tli.setRequiredVersion(this.jspversion);
            String ver = attrs.getValue("version");
            if (ver != null) {
                try {
                    double version = Double.parseDouble(ver);
                    if (version < 2.0) {
                        String message = JspCoreException.getMsg("jsp.error.invalid.implicit.version", new Object[]{this.tldLocation, ver.trim()});
                        logger.logp(Level.FINE, CLASS_NAME, "startElement", message);
                        throw new SAXException(message);
                    }
                }
                catch (NumberFormatException e) {
                    String message = JspCoreException.getMsg("jsp.error.invalid.implicit.version", new Object[]{this.tldLocation, ver.trim()});
                    logger.logp(Level.FINE, CLASS_NAME, "startElement", message);
                    throw new SAXException(message);
                }
                this.tli.setRequiredVersion(ver.trim());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
            logger.logp(logLevel, CLASS_NAME, "startElement", "currentElement= [" + elementTypes[this.currentElement - 1] + "]");
        }
    }

    public void endElement(String namespaceURI, String localName, String elementName) throws SAXException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
            logger.logp(logLevel, CLASS_NAME, "endElement", "namespaceURI= [" + namespaceURI + "] localName= [" + localName + "] elementName=[" + elementName + "]");
        }
        if (elementName.equals("tlibversion") || elementName.equals("tlib-version")) {
            this.tlibversion = this.chars.toString().trim();
            this.tli.setTlibversion(this.tlibversion);
        } else if (elementName.equals("jspversion") || elementName.equals("jsp-version")) {
            this.jspversion = this.chars.toString().trim();
            try {
                double version = Double.parseDouble(this.jspversion);
                if (version < 2.0) {
                    String message = JspCoreException.getMsg("jsp.error.invalid.implicit.version", new Object[]{this.tldLocation, this.jspversion});
                    logger.logp(Level.FINE, CLASS_NAME, "startElement", message);
                    throw new SAXException(message);
                }
            }
            catch (NumberFormatException e) {
                String message = JspCoreException.getMsg("jsp.error.invalid.implicit.version", new Object[]{this.tldLocation, this.jspversion});
                logger.logp(Level.FINE, CLASS_NAME, "startElement", message);
                throw new SAXException(message);
            }
            this.tli.setRequiredVersion(this.jspversion);
        } else if (!(elementName.equals("shortname") || elementName.equals("short-name") || elementName.equals("taglib"))) {
            String message = JspCoreException.getMsg("jsp.error.invalid.implicit", new Object[]{this.tldLocation, elementName});
            logger.logp(Level.FINE, CLASS_NAME, "startElement", message);
            throw new SAXException(message);
        }
        this.chars = null;
    }

    static {
        logLevel = Level.FINEST;
        logger = Logger.getLogger("com.ibm.ws.jsp");
    }
}

