/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.taglib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfigurationManager;
import com.ibm.ws.jsp.configuration.JspXmlExtConfig;
import com.ibm.ws.jsp.inputsource.JspInputSourceFactoryImpl;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.taglib.TagLibraryInfoProxy;
import com.ibm.ws.jsp.taglib.TldParser;
import com.ibm.ws.jsp.taglib.config.AvailabilityCondition;
import com.ibm.ws.jsp.taglib.config.AvailabilityConditionType;
import com.ibm.ws.jsp.taglib.config.GlobalTagLibConfig;
import com.ibm.ws.jsp.taglib.config.ImplicitTagLibConfig;
import com.ibm.ws.jsp.taglib.config.TagLibCacheConfigParser;
import com.ibm.ws.jsp.taglib.config.TldPathConfig;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.jsp.resource.JspInputSourceFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.TagLibraryInfo;

public class GlobalTagLibraryCache
extends Hashtable
implements JspCoreContext,
JspClassloaderContext {
    private static final long serialVersionUID = 3257286933104505909L;
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.taglib.GlobalTagLibraryCache";
    private URL contextURL;
    private String root;
    private JspInputSourceFactory inputSourceFactory;
    private Map implicitTagLibPrefixMap;
    private Map optimizedTagConfigMap;
    private List eventListenerList;
    private List globalTagLibConfigList;
    private ClassLoader loader;
    private JspConfigurationManager configManager;

    public GlobalTagLibraryCache() {
        this((ClassLoader)null);
    }

    public GlobalTagLibraryCache(ClassLoader loader) {
        block30: {
            this.contextURL = null;
            this.root = "";
            this.inputSourceFactory = null;
            this.implicitTagLibPrefixMap = new HashMap();
            this.optimizedTagConfigMap = new HashMap();
            this.eventListenerList = new ArrayList();
            this.globalTagLibConfigList = null;
            this.loader = null;
            this.configManager = null;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "entry");
                logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "loader: [" + loader + "]");
            }
            this.loader = loader;
            String installRoot = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("was.install.root");
                }
            });
            this.root = new File(installRoot + File.separator + "lib").getPath();
            try {
                this.contextURL = new URL("file", null, this.getRealPath("/"));
            }
            catch (MalformedURLException e) {
                logger.logp(Level.WARNING, CLASS_NAME, "GlobalTagLibraryCache", "Failed to create context URL for docRoot: " + this.root, e);
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "contextURL: [" + this.contextURL + "]");
            }
            this.inputSourceFactory = new JspInputSourceFactoryImpl(this.contextURL, null, false, this.getClassLoader());
            TldParser tldParser = null;
            try {
                this.configManager = new JspConfigurationManager(Collections.EMPTY_LIST, false, true, Collections.EMPTY_LIST);
                tldParser = new TldParser(this, this.configManager, false);
                TagLibCacheConfigParser tagLibCacheConfigParser = new TagLibCacheConfigParser();
                tagLibCacheConfigParser.parse(this.getClass().getResourceAsStream("/com/ibm/ws/jsp/resources/taglibcacheconfig.xml"));
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "tagLibCacheConfigParser.getImplicitTagLibList(): [" + tagLibCacheConfigParser.getImplicitTagLibList() + "]");
                }
                for (ImplicitTagLibConfig implicitTagLibConfig : tagLibCacheConfigParser.getImplicitTagLibList()) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "implicitTagLibConfig: [" + implicitTagLibConfig + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "implicitTagLibConfig.getUri(): [" + implicitTagLibConfig.getUri() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "contains(implicitTagLibConfig.getUri(): [" + this.contains(implicitTagLibConfig.getUri()) + "]");
                    }
                    if (this.contains(implicitTagLibConfig.getUri())) continue;
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "implicitTagLibConfig.getLocation(): [" + implicitTagLibConfig.getLocation() + "]");
                    }
                    JspInputSource inputSource = this.inputSourceFactory.createJspInputSource(implicitTagLibConfig.getLocation());
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "inputSource.getRelativeURL(): [" + inputSource.getRelativeURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "inputSource.getAbsoluteURL(): [" + inputSource.getAbsoluteURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "inputSource.getContextURL(): [" + inputSource.getContextURL() + "]");
                    }
                    try {
                        TagLibraryInfoImpl tli = tldParser.parseTLD(inputSource, "webinf");
                        this.put(implicitTagLibConfig.getUri(), tli);
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "putting into implicitTagLibPrefixMap, prefix: [" + implicitTagLibConfig.getPrefix() + "]  uri: [" + implicitTagLibConfig.getUri() + "]");
                        }
                        this.implicitTagLibPrefixMap.put(implicitTagLibConfig.getPrefix(), implicitTagLibConfig.getUri());
                    }
                    catch (JspCoreException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                        logger.logp(Level.WARNING, CLASS_NAME, "GlobalTagLibraryCache", "jsp warning failed to load tld in jar. uri = [" + inputSource.getAbsoluteURL() + "]", e);
                    }
                }
                this.globalTagLibConfigList = tagLibCacheConfigParser.getGlobalTagLibList();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "globalTagLibConfigList: [" + this.globalTagLibConfigList + "]");
                }
                Iterator itr = this.globalTagLibConfigList.listIterator();
                while (itr.hasNext()) {
                    GlobalTagLibConfig globalTagLibConfig = (GlobalTagLibConfig)itr.next();
                    if (this.loadImplicitTldFromJar(globalTagLibConfig, tldParser)) continue;
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.WARNING)) {
                        logger.logp(Level.WARNING, CLASS_NAME, "GlobalTagLibraryCache", "jsp warning failed to find jar [" + globalTagLibConfig.getJarName() + "]. Removing from list of available global tag libraries");
                    }
                    itr.remove();
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", " about to search for META-INF/taglibcacheconfig.xml");
                }
                Enumeration<URL> e = this.getClassLoader().getResources("META-INF/taglibcacheconfig.xml");
                while (e.hasMoreElements()) {
                    URL url = e.nextElement();
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "META-INF/taglibcacheconfig.xml found in {0} ", url.toExternalForm());
                    }
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "about to open:[" + url.toExternalForm() + "]");
                        }
                        InputStream is = url.openStream();
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "about to parse inputstream:[" + is + "]");
                        }
                        tagLibCacheConfigParser.parse(is);
                        List configList = tagLibCacheConfigParser.getGlobalTagLibList();
                        ListIterator itr2 = configList.listIterator();
                        while (itr2.hasNext()) {
                            GlobalTagLibConfig globalTagLibConfig = (GlobalTagLibConfig)itr2.next();
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "globalTagLibConfig: [" + globalTagLibConfig + "]");
                                logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "globalTagLibConfig.getTldPathList() [" + globalTagLibConfig.getTldPathList() + "]");
                                for (TldPathConfig tldPathConfig : globalTagLibConfig.getTldPathList()) {
                                    logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "tldPathConfig.getTldPath() [" + tldPathConfig.getTldPath() + "]");
                                    logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "tldPathConfig.getUri() [" + tldPathConfig.getUri() + "]");
                                }
                            }
                            if (this.loadImplicitTldFromJar(globalTagLibConfig, tldParser)) continue;
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.WARNING)) {
                                logger.logp(Level.WARNING, CLASS_NAME, "GlobalTagLibraryCache", "jsp warning failed to find jar [" + globalTagLibConfig.getJarName() + "]. Removing from list of available global tag libraries");
                            }
                            itr2.remove();
                        }
                        this.globalTagLibConfigList.addAll(configList);
                    }
                    catch (IOException exc) {
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                        logger.logp(Level.WARNING, CLASS_NAME, "GlobalTagLibraryCache", "jsp warning failed to load META-INF/taglibcacheconfig.xml in jar. url = [" + url + "]", e);
                    }
                }
            }
            catch (JspCoreException e) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.SEVERE)) {
                    logger.logp(Level.SEVERE, CLASS_NAME, "GlobalTagLibraryCache", "implicittaglibs failed to load ", e);
                }
            }
            catch (IOException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.SEVERE)) break block30;
                logger.logp(Level.SEVERE, CLASS_NAME, "GlobalTagLibraryCache", "implicittaglibs failed to load ", e);
            }
        }
    }

    private boolean loadImplicitTldFromJar(GlobalTagLibConfig globalTagLibConfig, TldParser tldParser) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "loadImplicitTldFromJar: entry");
        }
        boolean jarFound = false;
        URL jarUrl = this.getClassLoader().getResource(globalTagLibConfig.getJarName());
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "globalTagLibConfig.getJarName(): [" + globalTagLibConfig.getJarName() + "]");
            if (jarUrl != null) {
                logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "jarUrl: [" + jarUrl.toExternalForm() + "]");
            }
        }
        if (jarUrl != null) {
            jarFound = true;
            for (TldPathConfig tldPathConfig : globalTagLibConfig.getTldPathList()) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "tldPathConfig.getUri(): [" + tldPathConfig.getUri() + "]");
                }
                if (tldPathConfig.getUri() != null) {
                    TagLibraryInfoProxy proxy = new TagLibraryInfoProxy(globalTagLibConfig.getJarName(), tldPathConfig.getTldPath(), tldPathConfig.containsListenerDefs(), this);
                    this.put(tldPathConfig.getUri(), proxy);
                    continue;
                }
                JspInputSource tldInputSource = null;
                try {
                    TagLibraryInfoImpl tli;
                    URL url = new URL("jar:" + jarUrl.toString() + "!/");
                    tldInputSource = this.inputSourceFactory.createJspInputSource(url, tldPathConfig.getTldPath());
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "tldInputSource.getRelativeURL(): [" + tldInputSource.getRelativeURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "tldInputSource.getAbsoluteURL(): [" + tldInputSource.getAbsoluteURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "tldInputSource.getContextURL(): [" + tldInputSource.getContextURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "url: [" + url + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "tldPathConfig.getTldPath(): [" + tldPathConfig.getTldPath() + "]");
                    }
                    if ((tli = tldParser.parseTLD(tldInputSource, globalTagLibConfig.getJarName())).getReliableURN() != null) {
                        if (this.containsKey(tli.getReliableURN())) continue;
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "Global jar tld loaded for {0}", tli.getReliableURN());
                        }
                        tli.setURI(tli.getReliableURN());
                        this.put(tli.getReliableURN(), tli);
                        tldPathConfig.setUri(tli.getReliableURN());
                        this.eventListenerList.addAll(tldParser.getEventListenerList());
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                    logger.logp(Level.WARNING, CLASS_NAME, "loadImplicitTldFromJar", "jsp warning failed to find a uri tag in [" + tldInputSource.getAbsoluteURL() + "]");
                }
                catch (JspCoreException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                    logger.logp(Level.WARNING, CLASS_NAME, "loadImplicitTldFromJar", "jsp warning failed to load tld in jar. uri = [" + tldInputSource.getAbsoluteURL() + "]", e);
                }
                catch (IOException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                    logger.logp(Level.WARNING, CLASS_NAME, "loadImplicitTldFromJar", "jsp warning failed to load tld in jar. uri = [" + tldInputSource.getAbsoluteURL() + "]", e);
                }
            }
        }
        return jarFound;
    }

    public JspClassloaderContext getJspClassloaderContext() {
        return this;
    }

    public JspInputSourceFactory getJspInputSourceFactory() {
        return this.inputSourceFactory;
    }

    public String getRealPath(String path) {
        String realPath = "";
        realPath = path.startsWith("/") ? this.root + path : this.root + "/" + path;
        return realPath;
    }

    public Set getResourcePaths(String paths) {
        File[] fileList;
        HashSet<String> set = new HashSet<String>();
        File rootPath = new File(this.root + paths);
        if (rootPath.exists() && (fileList = rootPath.listFiles()) != null) {
            for (int i = 0; i < fileList.length; ++i) {
                String resourcePath = fileList[i].getPath();
                resourcePath = resourcePath.substring(this.root.length());
                resourcePath = resourcePath.replace('\\', '/');
                if (fileList[i].isDirectory() && !resourcePath.endsWith("/")) {
                    resourcePath = resourcePath + "/";
                }
                set.add(resourcePath);
            }
        }
        return set;
    }

    public ClassLoader getClassLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        return this.getClass().getClassLoader();
    }

    public String getClassPath() {
        return "";
    }

    public Map getImplicitTagLibPrefixMap() {
        return this.implicitTagLibPrefixMap;
    }

    public Map getOptimizedTagConfigMap() {
        return this.optimizedTagConfigMap;
    }

    public List getEventListenerList() {
        return this.eventListenerList;
    }

    public Map getGlobalTagLibMapForWebApp(JspCoreContext context, JspXmlExtConfig jspConfig) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getGlobalTagLibMapForWebApp", "entry");
            logger.logp(Level.FINE, CLASS_NAME, "getGlobalTagLibMapForWebApp", "context: [" + context + "]  jspConfig: [" + jspConfig + "]");
        }
        HashMap<String, TagLibraryInfo> globalTabLibMap = new HashMap<String, TagLibraryInfo>();
        for (String uri : this.implicitTagLibPrefixMap.values()) {
            TagLibraryInfo tli = (TagLibraryInfo)this.get(uri);
            globalTabLibMap.put(uri, tli);
        }
        for (GlobalTagLibConfig globalTagLibConfig : this.globalTagLibConfigList) {
            Iterator itr2 = globalTagLibConfig.getTldPathList().iterator();
            while (itr2.hasNext()) {
                boolean tldAvailable = false;
                TldPathConfig tldPathConfig = (TldPathConfig)itr2.next();
                if (tldPathConfig.getAvailabilityConditionList().size() > 0) {
                    for (AvailabilityCondition availabilityCondition : tldPathConfig.getAvailabilityConditionList()) {
                        if (availabilityCondition.getType().equals(AvailabilityConditionType.webinfFileType)) {
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "getGlobalTagLibMapForWebApp", "WEB-INF File Availability Condition found for {0}", availabilityCondition.getValue());
                            }
                            if (!new File(context.getRealPath(availabilityCondition.getValue())).exists()) continue;
                            tldAvailable = true;
                        } else {
                            if (!availabilityCondition.getType().equals(AvailabilityConditionType.servletClassNameType)) continue;
                            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "getGlobalTagLibMapForWebApp", "Servlet Class Name Availability Condition found for {0}", availabilityCondition.getValue());
                            }
                            if (!jspConfig.containsServletClassName(availabilityCondition.getValue())) continue;
                            tldAvailable = true;
                        }
                        break;
                    }
                } else {
                    tldAvailable = true;
                }
                if (!tldAvailable) continue;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getGlobalTagLibMapForWebApp", "global tld {0} is available", tldPathConfig.getUri());
                }
                globalTabLibMap.put(tldPathConfig.getUri(), (TagLibraryInfo)this.get(tldPathConfig.getUri()));
            }
        }
        return globalTabLibMap;
    }

    public String getOptimizedClassPath() {
        return this.getClassPath();
    }

    public boolean isPredefineClassEnabled() {
        return false;
    }

    public byte[] predefineClass(String className, byte[] classData) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTldFromJarInputStream(GlobalTagLibConfig globalTagLibConfig, TldParser tldParser) {
        HashMap<String, TldPathConfig> entryMap = new HashMap<String, TldPathConfig>();
        for (TldPathConfig tldPathConfig : globalTagLibConfig.getTldPathList()) {
            entryMap.put(tldPathConfig.getTldPath(), tldPathConfig);
        }
        JarInputStream jis = null;
        try {
            jis = new JarInputStream(globalTagLibConfig.getJarURL().openStream());
            JarEntry je = null;
            byte[] buf = new byte[1024];
            while ((je = jis.getNextJarEntry()) != null) {
                TldPathConfig tldPathConfig = (TldPathConfig)entryMap.get(je.getName());
                if (tldPathConfig == null) continue;
                JspInputSource tldInputSource = null;
                try {
                    TagLibraryInfoImpl tli;
                    int read;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    while ((read = jis.read(buf)) != -1) {
                        baos.write(buf, 0, read);
                    }
                    tldInputSource = this.inputSourceFactory.createJspInputSource(globalTagLibConfig.getJarURL(), tldPathConfig.getTldPath());
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "loadTldFromJarInputStream", "tldInputSource.getRelativeURL(): [" + tldInputSource.getRelativeURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "loadTldFromJarInputStream", "tldInputSource.getAbsoluteURL(): [" + tldInputSource.getAbsoluteURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "loadTldFromJarInputStream", "tldInputSource.getContextURL(): [" + tldInputSource.getContextURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "loadTldFromJarInputStream", "globalTagLibConfig.getJarURL(): [" + globalTagLibConfig.getJarURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "loadTldFromJarInputStream", "tldPathConfig.getTldPath(): [" + tldPathConfig.getTldPath() + "]");
                    }
                    if ((tli = tldParser.parseTLD(tldInputSource, new ByteArrayInputStream(baos.toByteArray()), globalTagLibConfig.getJarURL().toExternalForm())).getReliableURN() != null) {
                        if (this.containsKey(tli.getReliableURN())) continue;
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "loadTldFromJarInputStream", "Global jar tld loaded for {0}", tli.getReliableURN());
                        }
                        tli.setURI(tli.getReliableURN());
                        this.put(tli.getReliableURN(), tli);
                        tldPathConfig.setUri(tli.getReliableURN());
                        this.eventListenerList.addAll(tldParser.getEventListenerList());
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                    logger.logp(Level.WARNING, CLASS_NAME, "loadTldFromJarInputStream", "jsp warning failed to find a uri tag in [" + tldInputSource.getAbsoluteURL() + "]");
                }
                catch (JspCoreException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) continue;
                    logger.logp(Level.WARNING, CLASS_NAME, "loadTldFromJarInputStream", "jsp warning failed to load tld in jar. uri = [" + tldInputSource.getAbsoluteURL() + "]", e);
                }
            }
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.WARNING)) {
                logger.logp(Level.WARNING, CLASS_NAME, "loadTldFromJarInputStream", "jsp warning failed to load jar. url = [" + globalTagLibConfig.getJarURL() + "]", ioe);
            }
        }
        finally {
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public void addGlobalTagLibConfig(GlobalTagLibConfig globalTagLibConfig) {
        block2: {
            try {
                TldParser tldParser = new TldParser(this, this.configManager, false, globalTagLibConfig.getClassloader());
                this.loadTldFromJarInputStream(globalTagLibConfig, tldParser);
                this.globalTagLibConfigList.add(globalTagLibConfig);
            }
            catch (JspCoreException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.SEVERE)) break block2;
                logger.logp(Level.SEVERE, CLASS_NAME, "addGlobalTagLibConfig", "failed to create TldParser ", e);
            }
        }
    }
}

