/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.runtime.metadata;

import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.jsp.configuration.JspConfigProperty;
import com.ibm.ws.jsp.configuration.JspConfigPropertyGroup;
import com.ibm.ws.jsp.runtime.metadata.JspComponentMetaData;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataEvent;
import com.ibm.ws.runtime.metadata.MetaDataListener;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseLibrary;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseWARFile;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.jsp.JSPConfig;
import org.eclipse.jst.j2ee.jsp.JSPPropertyGroup;
import org.eclipse.jst.j2ee.jsp.TagLibRefType;
import org.eclipse.jst.j2ee.webapplication.TagLibRef;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class JspMetaDataListener
implements MetaDataListener {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.runtime.metadata.JspMetaDataListener";

    public void metaDataCreated(MetaDataEvent mde) throws RuntimeWarning, RuntimeError {
        MetaData metaData;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, "JspMetaDataListener", "metaDataCreated", "metaDataCreated: " + mde);
        }
        if ((metaData = mde.getMetaData()) instanceof WebModuleMetaData) {
            DeployedObject dobj;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, "JspMetaDataListener", "metaDataCreated", "WebModuleMetaData " + metaData);
            }
            if ((dobj = mde.getDeployedObject()).getModuleFile().isWARFile()) {
                WebApp webModuleDD = (WebApp)dobj.getDeploymentDescriptor();
                WebAppExtension webAppExt = (WebAppExtension)dobj.getExtension();
                WebAppConfig config = ((WebModuleMetaData)((Object)metaData)).getConfiguration();
                LooseWARFile loose = (LooseWARFile)dobj.getModuleFile().getLoadStrategy().getLooseArchive();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, "JspMetaDataListener", "metaDataCreated", "webModuleDD " + webModuleDD);
                    logger.logp(Level.FINEST, "JspMetaDataListener", "metaDataCreated", "config " + config);
                }
                this.populateJspMetaData(webModuleDD, config, loose, webAppExt.isReloadingEnabled(), webAppExt.getReloadInterval(), webModuleDD.getDisplayName());
            }
        }
    }

    private void populateJspMetaData(WebApp webModuleDD, WebAppConfig config, LooseWARFile loose, boolean servletEngineReloadEnabled, long servletEngineReloadInterval, String displayName) {
        EList looseLibs;
        boolean isServlet24 = false;
        boolean isServlet24_or_higher = false;
        boolean isServlet22 = false;
        HashMap<String, String> tagLibMap = new HashMap<String, String>();
        ArrayList<JspConfigPropertyGroup> jspPropertyGroups = new ArrayList<JspConfigPropertyGroup>();
        JspComponentMetaData jspMetadata = new JspComponentMetaData();
        XMLResource res = (XMLResource)webModuleDD.eResource();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, "JspMetaDataListener", "populateJspMetaData", "res " + res);
            logger.logp(Level.FINEST, "JspMetaDataListener", "populateJspMetaData", "res.getVersionID() " + res.getVersionID());
        }
        if (res != null) {
            isServlet24 = res.getVersionID() == 14;
            isServlet22 = res.getVersionID() == 12;
            boolean bl = isServlet24_or_higher = res.getVersionID() >= 14;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, "JspMetaDataListener", "populateJspMetaData", "isServlet24OrHigher " + isServlet24);
            logger.logp(Level.FINEST, "JspMetaDataListener", "populateJspMetaData", "isServlet22 " + isServlet22);
            logger.logp(Level.FINEST, "JspMetaDataListener", "populateJspMetaData", "isServlet24_or_higher " + isServlet24_or_higher);
        }
        if (isServlet24_or_higher) {
            JSPConfig jspConfig = webModuleDD.getJspConfig();
            if (jspConfig != null) {
                EList propertyGroups;
                EList tagLibList = jspConfig.getTagLibs();
                if (tagLibList != null) {
                    for (TagLibRefType tlrt : tagLibList) {
                        tagLibMap.put(tlrt.getTaglibURI(), tlrt.getTaglibLocation());
                    }
                }
                if ((propertyGroups = jspConfig.getPropertyGroups()) != null) {
                    for (JSPPropertyGroup propertyGroup : propertyGroups) {
                        EList codaList;
                        EList preludeList;
                        JspConfigProperty jspConfigProperty;
                        JspConfigPropertyGroup jspConfigPropertyGroup = new JspConfigPropertyGroup();
                        EList urlPatterns = propertyGroup.getUrlPattern();
                        for (String urlPattern : urlPatterns) {
                            jspConfigPropertyGroup.addUrlPattern(urlPattern);
                        }
                        if (propertyGroup.isSetIsXML()) {
                            jspConfigProperty = new JspConfigProperty(1, new Boolean(propertyGroup.isIsXML()));
                            jspConfigPropertyGroup.add(jspConfigProperty);
                        }
                        if (propertyGroup.isSetScriptingInvalid()) {
                            jspConfigProperty = new JspConfigProperty(3, new Boolean(propertyGroup.isScriptingInvalid()));
                            jspConfigPropertyGroup.add(jspConfigProperty);
                        }
                        if (propertyGroup.isSetElIgnored()) {
                            JspConfigProperty elJspConfigProperty = new JspConfigProperty(2, new Boolean(propertyGroup.isElIgnored()));
                            jspConfigPropertyGroup.add(elJspConfigProperty);
                            if (propertyGroup.isElIgnored()) {
                                JspConfigProperty elSetJspConfigProperty = new JspConfigProperty(9, new Boolean(propertyGroup.isSetElIgnored()));
                                jspConfigPropertyGroup.add(elSetJspConfigProperty);
                            }
                        }
                        if (propertyGroup.getPageEncoding() != null) {
                            jspConfigProperty = new JspConfigProperty(4, propertyGroup.getPageEncoding());
                            jspConfigPropertyGroup.add(jspConfigProperty);
                        }
                        if (propertyGroup.isSetTrimDirectiveWhitespaces()) {
                            jspConfigProperty = new JspConfigProperty(8, new Boolean(propertyGroup.isTrimDirectiveWhitespaces()));
                            jspConfigPropertyGroup.add(jspConfigProperty);
                        }
                        if (propertyGroup.isSetDeferredSyntaxAllowedAsLiteral()) {
                            jspConfigProperty = new JspConfigProperty(7, new Boolean(propertyGroup.isDeferredSyntaxAllowedAsLiteral()));
                            jspConfigPropertyGroup.add(jspConfigProperty);
                        }
                        if ((preludeList = propertyGroup.getIncludePreludes()) != null) {
                            for (String includePrelude : preludeList) {
                                JspConfigProperty jspConfigProperty2 = new JspConfigProperty(5, includePrelude);
                                jspConfigPropertyGroup.add(jspConfigProperty2);
                            }
                        }
                        if ((codaList = propertyGroup.getIncludeCodas()) != null) {
                            for (String includeCoda : codaList) {
                                JspConfigProperty jspConfigProperty3 = new JspConfigProperty(6, includeCoda);
                                jspConfigPropertyGroup.add(jspConfigProperty3);
                            }
                        }
                        jspPropertyGroups.add(jspConfigPropertyGroup);
                    }
                }
            }
        } else {
            EList tagLibList = webModuleDD.getTagLibs();
            if (tagLibList != null) {
                for (TagLibRef tlr : tagLibList) {
                    tagLibMap.put(tlr.getTaglibURI(), tlr.getTaglibLocation());
                }
            }
        }
        HashMap<String, String> looseMap = new HashMap<String, String>();
        if (loose != null && (looseLibs = loose.getLooseLibs()) != null) {
            for (int i = 0; i < looseLibs.size(); ++i) {
                LooseLibrary lib = (LooseLibrary)looseLibs.get(i);
                looseMap.put(lib.getUri(), lib.getBinariesPath());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, "JspMetaDataListener", "populateJspMetaData", "tagLibMap = " + tagLibMap);
            logger.logp(Level.FINER, "JspMetaDataListener", "populateJspMetaData", "jspPropertyGroups = " + jspPropertyGroups);
            logger.logp(Level.FINER, "JspMetaDataListener", "populateJspMetaData", "looseMap = " + looseMap);
        }
        jspMetadata.setJspPropertyGroups(jspPropertyGroups);
        jspMetadata.setJspTaglibs(tagLibMap);
        jspMetadata.setServlet2_2(isServlet22);
        jspMetadata.setServletEngineReloadEnabled(servletEngineReloadEnabled);
        jspMetadata.setServletEngineReloadInterval(servletEngineReloadInterval * 1000L);
        jspMetadata.setApplicationDisplayName(displayName);
        if (looseMap.size() > 0) {
            jspMetadata.setLooseLibs(looseMap);
        }
        config.getMetaData().setJspComponentMetadata(jspMetadata);
    }

    public void metaDataDestroyed(MetaDataEvent mde) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, "JspMetaDataListener", "metaDataDestroyed", "metaDataDestroyed: " + mde);
        }
    }
}

