/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.runtime;

import com.ibm.ws.jsp.taglib.annotation.AnnotationHandler;
import javax.servlet.ServletContext;
import javax.servlet.jsp.tagext.Tag;

public class TagArray {
    private Tag[] tags;
    private int next = -1;
    private AnnotationHandler tagAnnotationHandler;

    public TagArray(int size, ServletContext context) {
        this.tags = new Tag[size];
        this.tagAnnotationHandler = AnnotationHandler.getInstance(context);
    }

    public Tag get() {
        Tag tag = null;
        if (this.next >= 0) {
            tag = this.tags[this.next--];
        }
        return tag;
    }

    public void put(Tag tag) {
        if (this.next < this.tags.length - 1) {
            this.tags[++this.next] = tag;
            return;
        }
        this.tagAnnotationHandler.doPreDestroyAction(tag);
        tag.release();
    }

    public void releaseTags() {
        for (int i = 0; i < this.tags.length; ++i) {
            if (this.tags[i] == null) continue;
            this.tagAnnotationHandler.doPreDestroyAction(this.tags[i]);
            this.tags[i].release();
            this.tags[i] = null;
        }
    }

    public int numberInUse() {
        return this.next + 1;
    }
}

