/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.inputsource;

import com.ibm.wsspi.jsp.resource.JspInputSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class JspInputSourceImpl
implements JspInputSource {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.inputsource.JspInputSourceImpl";
    protected URL contextURL = null;
    protected URL absoluteURL = null;
    protected String relativeURL = null;
    protected URLStreamHandler urlStreamHandler = null;
    protected long lastModified = 0L;
    protected Document document = null;

    public JspInputSourceImpl(URL contextURL, String relativeURL, URLStreamHandler urlStreamHandler) {
        this.contextURL = contextURL;
        this.relativeURL = relativeURL;
        this.urlStreamHandler = urlStreamHandler;
        String resolvedRelativeURL = relativeURL;
        if (resolvedRelativeURL.charAt(0) == '/') {
            resolvedRelativeURL = resolvedRelativeURL.substring(1);
        }
        try {
            this.absoluteURL = urlStreamHandler != null ? new URL(contextURL, resolvedRelativeURL, urlStreamHandler) : new URL(contextURL, resolvedRelativeURL);
        }
        catch (MalformedURLException e) {
            logger.logp(Level.WARNING, CLASS_NAME, "JspInputSourceImpl", "Failed to create inputsource contextURL =[" + contextURL + " relativeURL =[" + relativeURL + "]", e);
        }
    }

    public JspInputSourceImpl(JspInputSourceImpl baseImpl, String relativeURL, URLStreamHandler urlStreamHandler) {
        this(baseImpl.contextURL, relativeURL, urlStreamHandler);
    }

    public URL getAbsoluteURL() {
        return this.absoluteURL;
    }

    public URL getContextURL() {
        return this.contextURL;
    }

    public Document getDocument() {
        return this.document;
    }

    public InputStream getInputStream() throws IOException {
        InputStream is = null;
        URLConnection conn = this.absoluteURL.openConnection();
        conn.setUseCaches(false);
        is = conn.getInputStream();
        this.lastModified = conn.getLastModified();
        return is;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getRelativeURL() {
        return this.relativeURL;
    }

    public boolean isXmlDocument() {
        return this.document != null;
    }
}

