/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.inmemory.webcontainerext;

import com.ibm.ws.jsp.inmemory.resource.InMemoryResources;
import com.ibm.ws.jsp.webcontainerext.JSPExtensionClassLoader;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Iterator;
import java.util.List;

public class InMemoryJspClassLoader
extends JSPExtensionClassLoader {
    private List resourcesList = null;
    private JspClassloaderContext jspClassloaderContext = null;
    private CodeSource codeSource = null;
    private PermissionCollection permissionCollection = null;
    private String className = null;

    public InMemoryJspClassLoader(URL[] urls, JspClassloaderContext jspClassloaderContext, String className, CodeSource codeSource, PermissionCollection permissionCollection, List resourcesList) {
        super(urls, jspClassloaderContext, className, codeSource, permissionCollection);
        this.resourcesList = resourcesList;
        this.className = className;
        this.codeSource = codeSource;
        this.permissionCollection = permissionCollection;
        this.jspClassloaderContext = jspClassloaderContext;
    }

    protected byte[] loadClassDataFromFile(String fileName) {
        InMemoryResources inMemoryResources;
        byte[] classBytes = null;
        Iterator itr = this.resourcesList.iterator();
        while (itr.hasNext() && (classBytes = (inMemoryResources = (InMemoryResources)itr.next()).getClassBytes(fileName)) == null) {
        }
        return classBytes;
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (System.getSecurityManager() != null) {
            final String tmpName = name;
            final boolean tmpResolve = resolve;
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return InMemoryJspClassLoader.this._loadClass(tmpName, tmpResolve);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (ClassNotFoundException)pae.getException();
            }
        }
        return this._loadClass(name, resolve);
    }

    private Class _loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clazz = null;
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        int dot = name.lastIndexOf(46);
        if (System.getSecurityManager() != null && dot >= 0) {
            try {
                System.getSecurityManager().checkPackageAccess(name.substring(0, dot));
            }
            catch (SecurityException se) {
                String error = "Security Violation, attempt to use Restricted Class: " + name;
                throw new ClassNotFoundException(error);
            }
        }
        if (!(name.startsWith("_ibmjsp") || name.startsWith("com.ibm._jsp") || name.startsWith("org.apache.jsp") || name.startsWith("com.ibm.ws.jsp.tagfile"))) {
            clazz = this.jspClassloaderContext.getClassLoader().loadClass(name);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        String classFile = null;
        classFile = name.startsWith("com.ibm._jsp." + this.className) ? name.substring("com.ibm._jsp".length() + 1) + ".class" : (name.startsWith("org.apache.jsp." + this.className) ? name.substring("org.apache.jsp".length() + 1) + ".class" : name.replace('.', File.separatorChar) + ".class");
        byte[] cdata = this.loadClassDataFromFile(name);
        if (cdata != null) {
            if (System.getSecurityManager() != null) {
                ProtectionDomain pd = new ProtectionDomain(this.codeSource, this.permissionCollection);
                clazz = this.defClass(name, cdata, cdata.length, pd);
            } else {
                clazz = this.defClass(name, cdata, cdata.length, null);
            }
        } else if (this.jspClassloaderContext.getClassLoader() != null) {
            clazz = this.jspClassloaderContext.getClassLoader().loadClass(classFile);
        }
        if (clazz != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    private final Class defClass(String className, byte[] classData, int length, ProtectionDomain pd) {
        if (this.jspClassloaderContext.isPredefineClassEnabled()) {
            classData = this.jspClassloaderContext.predefineClass(className, classData);
        }
        if (pd != null) {
            return this.defineClass(className, classData, 0, classData.length, pd);
        }
        return this.defineClass(className, classData, 0, classData.length);
    }
}

