/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.configuration;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.Constants;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfigProperty;
import com.ibm.ws.jsp.configuration.JspConfigPropertyGroup;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.configuration.StaticIncludeJspConfiguration;
import com.ibm.ws.util.URIMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JspConfigurationManager {
    protected boolean isServlet24OrHigher = false;
    protected boolean isServlet25OrHigher = false;
    protected URIMatcher uriMatcher = null;
    protected List jspExtensionList = new ArrayList();
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.configuration.JspConfigurationManager";

    public JspConfigurationManager(List jspPropertyGroups, boolean isServlet24, boolean isServlet24_or_higher, List addtlJspFileExtensions) throws JspCoreException {
        this.isServlet24OrHigher = isServlet24_or_higher;
        this.isServlet25OrHigher = this.isServlet24OrHigher && !isServlet24;
        this.uriMatcher = new URIMatcher();
        ArrayList<String> urlPatterns = new ArrayList<String>();
        for (JspConfigPropertyGroup jspPropertyGroup : jspPropertyGroups) {
            for (String urlPattern : jspPropertyGroup.getUrlPatterns()) {
                if (!urlPatterns.contains(urlPattern)) {
                    urlPatterns.add(urlPattern);
                    try {
                        this.uriMatcher.put(urlPattern, (Object)jspPropertyGroup);
                    }
                    catch (Exception e) {
                        logger.logp(Level.WARNING, CLASS_NAME, "JspConfigurationManager", "Failed to add url pattern [" + urlPattern + "] to match list.", e);
                    }
                } else {
                    throw new JspCoreException("jsp.error.dup.url.pattern", new Object[]{urlPattern});
                }
                if (this.jspExtensionList.contains(urlPattern)) continue;
                boolean newExtFound = true;
                for (int i = 0; i < Constants.STANDARD_JSP_EXTENSIONS.length; ++i) {
                    if (!urlPattern.equals(Constants.STANDARD_JSP_EXTENSIONS[i])) continue;
                    newExtFound = false;
                    break;
                }
                if (!newExtFound) continue;
                this.jspExtensionList.add(urlPattern);
            }
        }
        for (String urlPattern : addtlJspFileExtensions) {
            if (!urlPattern.startsWith("*.") || this.jspExtensionList.contains(urlPattern)) continue;
            boolean newExtFound = true;
            for (int i = 0; i < Constants.STANDARD_JSP_EXTENSIONS.length; ++i) {
                if (!urlPattern.equals(Constants.STANDARD_JSP_EXTENSIONS[i])) continue;
                newExtFound = false;
                break;
            }
            if (!newExtFound) continue;
            this.jspExtensionList.add(urlPattern);
        }
    }

    public synchronized JspConfiguration getConfigurationForUrl(String url) {
        List matches = this.uriMatcher.matchAll(url);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getConfigurationForUrl", "begin creation of new JspConfiguration for url = [{0}] uris matched = [{1}]", new Object[]{url, new Integer(matches.size())});
        }
        JspConfiguration configuration = new JspConfiguration(this);
        if (matches.size() > 0) {
            if (this.isServlet24OrHigher) {
                configuration.setElIgnored(false);
            }
            if (!this.isServlet25OrHigher) {
                configuration.setDeferredSyntaxAllowedAsLiteral(true);
            }
            configuration.setServletVersion(this.getServletVersion());
            for (JspConfigPropertyGroup propertyGroup : matches) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "getConfigurationForUrl", "handling config url pattern(s) " + propertyGroup.getUrlPatterns());
                }
                for (JspConfigProperty property : propertyGroup) {
                    switch (property.getType()) {
                        case 6: {
                            configuration.addIncludeCoda((String)property.getValue());
                            break;
                        }
                        case 2: {
                            configuration.setElIgnored((Boolean)property.getValue());
                            break;
                        }
                        case 9: {
                            configuration.setElIgnoredSetTrueInPropGrp((Boolean)property.getValue());
                            break;
                        }
                        case 1: {
                            configuration.setIsXml((Boolean)property.getValue());
                            break;
                        }
                        case 4: {
                            configuration.setPageEncoding((String)property.getValue());
                            break;
                        }
                        case 5: {
                            configuration.addIncludePrelude((String)property.getValue());
                            break;
                        }
                        case 3: {
                            configuration.setScriptingInvalid((Boolean)property.getValue());
                            break;
                        }
                        case 8: {
                            configuration.setTrimDirectiveWhitespaces((Boolean)property.getValue());
                            configuration.setTrimDirectiveWhitespaces(((Boolean)property.getValue()).toString());
                            break;
                        }
                        case 7: {
                            configuration.setDeferredSyntaxAllowedAsLiteral((Boolean)property.getValue());
                            configuration.setDeferredSyntaxAllowedAsLiteral(((Boolean)property.getValue()).toString());
                        }
                    }
                }
            }
        } else {
            if (this.isServlet24OrHigher) {
                configuration.setElIgnored(false);
            }
            if (!this.isServlet25OrHigher) {
                configuration.setDeferredSyntaxAllowedAsLiteral(true);
            }
            configuration.setServletVersion(this.getServletVersion());
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getConfigurationForUrl", "complete creation of new JspConfiguration for url = [{0}] {1}", new Object[]{url, configuration.toString()});
        }
        return configuration;
    }

    public synchronized JspConfiguration getConfigurationForStaticInclude(String url, JspConfiguration parentConfig) {
        List matches = this.uriMatcher.matchAll(url);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getConfigurationForStaticInclude", "begin creation of new StaticIncludeJspConfiguration for url = [{0}] uris matched = [{1}] (config inherited from parent)", new Object[]{url, new Integer(matches.size())});
        }
        StaticIncludeJspConfiguration configuration = new StaticIncludeJspConfiguration(parentConfig);
        if (matches.size() > 0) {
            for (JspConfigPropertyGroup propertyGroup : matches) {
                for (JspConfigProperty property : propertyGroup) {
                    if (property.getType() != 4) continue;
                    configuration.setPageEncoding((String)property.getValue());
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getConfigurationForStaticInclude", "complete creation of new StaticIncludeJspConfiguration for url = [{0}] {1}", new Object[]{url, configuration.toString()});
        }
        return configuration;
    }

    public List getJspExtensionList() {
        return this.jspExtensionList;
    }

    public JspConfiguration createJspConfiguration() {
        JspConfiguration newConfiguration = new JspConfiguration(this);
        newConfiguration.setServletVersion(this.getServletVersion());
        return newConfiguration;
    }

    private String getServletVersion() {
        String s = !this.isServlet24OrHigher ? "2.3" : (!this.isServlet25OrHigher ? "2.4" : "2.5");
        return s;
    }
}

