/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfigurationManager;
import com.ibm.ws.jsp.inputsource.JspInputSourceFactoryImpl;
import com.ibm.ws.jsp.webxml.WebXmlParser;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSourceFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DocRootBasedJspContext
implements JspCoreContext,
JspClassloaderContext {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.DocRootBasedJspContext";
    private URLClassLoader loader = null;
    private String docRoot = "";
    private JspConfigurationManager jspConfigurationManager = null;
    private URL contextURL = null;
    private JspInputSourceFactory jspInputSourceFactory = null;

    public DocRootBasedJspContext(String docRoot) throws JspCoreException {
        this.docRoot = docRoot;
        ArrayList urlList = new ArrayList();
        DocRootBasedJspContext.getWebAppURLs(docRoot, urlList);
        DocRootBasedJspContext.getManifestURLs(docRoot, urlList);
        String[] paths = urlList.toArray(new String[0]);
        URL[] urls = new URL[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            try {
                urls[i] = new File(paths[i]).toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new JspCoreException(e);
            }
        }
        this.loader = new URLClassLoader(urls, this.getClass().getClassLoader());
        WebXmlParser webXmlParser = new WebXmlParser(null);
        InputStream is = null;
        try {
            is = new FileInputStream(docRoot + File.separator + "WEB-INF" + File.separator + "web.xml");
            webXmlParser.parseWebXml(is);
        }
        catch (IOException e) {
            throw new JspCoreException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        try {
            this.contextURL = new URL("file", null, this.getRealPath("/"));
        }
        catch (MalformedURLException e) {
            logger.logp(Level.WARNING, CLASS_NAME, "DocRootBasedJspContext", "Failed to create context URL for docRoot: " + docRoot, e);
        }
        this.jspConfigurationManager = new JspConfigurationManager(webXmlParser.getJspPropertyGroups(), webXmlParser.isServlet24(), webXmlParser.isServlet24_or_higher(), Collections.EMPTY_LIST);
        this.jspInputSourceFactory = new JspInputSourceFactoryImpl(this.contextURL, null, true, this.loader);
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public String getClassPath() {
        String classpath = "";
        if (this.loader instanceof URLClassLoader) {
            int i;
            URL[] urls = null;
            if (this.getClass().getClassLoader() instanceof URLClassLoader && (urls = ((URLClassLoader)this.getClass().getClassLoader()).getURLs()) != null) {
                for (i = 0; i < urls.length; ++i) {
                    classpath = classpath + new File(urls[i].getFile()).getPath();
                    classpath = classpath + File.pathSeparator;
                }
            }
            if ((urls = this.loader.getURLs()) != null) {
                for (i = 0; i < urls.length; ++i) {
                    classpath = classpath + new File(urls[i].getFile()).getPath();
                    if (i == urls.length - 1) continue;
                    classpath = classpath + File.pathSeparator;
                }
            }
        }
        return classpath;
    }

    public String getRealPath(String path) {
        String realPath = "";
        realPath = path.startsWith("/") ? this.docRoot + path : this.docRoot + "/" + path;
        return realPath;
    }

    public Set getResourcePaths(String path) {
        File[] fileList;
        HashSet<String> set = new HashSet<String>();
        File root = new File(this.docRoot + path);
        if (root.exists() && (fileList = root.listFiles()) != null) {
            for (int i = 0; i < fileList.length; ++i) {
                String resourcePath = fileList[i].getPath();
                resourcePath = resourcePath.substring(this.docRoot.length());
                resourcePath = resourcePath.replace('\\', '/');
                if (fileList[i].isDirectory() && !resourcePath.endsWith("/")) {
                    resourcePath = resourcePath + "/";
                }
                set.add(resourcePath);
            }
        }
        return set;
    }

    private static void getWebAppURLs(String dir, List urlList) {
        urlList.add(new File(dir + File.separator + "WEB-INF" + File.separator + "classes").toString());
        File webappDir = new File(dir + File.separator + "WEB-INF" + File.separator + "lib");
        if (webappDir.exists() && webappDir.isDirectory()) {
            File[] dirList = webappDir.listFiles();
            for (int i = 0; i < dirList.length; ++i) {
                if (!dirList[i].isFile() || !dirList[i].getName().endsWith(".jar") && !dirList[i].getName().endsWith(".zip")) continue;
                urlList.add(dirList[i].toString());
            }
        }
    }

    private static void getLibURLs(String dir, List urlList) {
        StringTokenizer st = new StringTokenizer(dir, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            File file = new File(s);
            if (file.exists() && file.isDirectory()) {
                File[] dirList = file.listFiles();
                for (int i = 0; i < dirList.length; ++i) {
                    if (!dirList[i].isFile() || !dirList[i].getName().endsWith(".jar") && !dirList[i].getName().endsWith(".zip")) continue;
                    urlList.add(dirList[i].toString());
                }
                continue;
            }
            if (!s.endsWith(".jar") && !s.endsWith(".zip")) continue;
            urlList.add(file.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getManifestURLs(String path, List manifestPaths) {
        File f = new File(path);
        if (f.exists()) {
            if (f.isDirectory()) {
                File manifestFile = new File(path + File.separator + "META-INF" + File.separator + "MANIFEST.MF");
                if (manifestFile.exists()) {
                    FileInputStream fin = null;
                    try {
                        fin = new FileInputStream(manifestFile);
                        Manifest manifest = new Manifest(fin);
                        DocRootBasedJspContext.getManifestClassPaths(manifest, f.getParent(), manifestPaths);
                    }
                    catch (IOException e) {
                    }
                    finally {
                        if (fin != null) {
                            try {
                                fin.close();
                            }
                            catch (IOException io) {}
                            fin = null;
                        }
                    }
                }
            } else {
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(f);
                    Manifest manifest = jarFile.getManifest();
                    if (manifest != null) {
                        DocRootBasedJspContext.getManifestClassPaths(manifest, f.getParent(), manifestPaths);
                    }
                }
                catch (IOException e) {
                }
                finally {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException io) {}
                        jarFile = null;
                    }
                }
            }
        }
    }

    private static void getManifestClassPaths(Manifest manifest, String archivePath, List manifestPaths) {
        Attributes main = manifest.getMainAttributes();
        String classPath = main.getValue(Attributes.Name.CLASS_PATH);
        if (classPath != null) {
            StringTokenizer st = new StringTokenizer(classPath, " ");
            while (st.hasMoreTokens()) {
                String path = archivePath + File.separator + st.nextToken();
                File file = new File(path);
                if (!file.exists()) continue;
                manifestPaths.add(file.toString());
            }
        }
    }

    public JspInputSourceFactory getJspInputSourceFactory() {
        return this.jspInputSourceFactory;
    }

    public JspConfigurationManager getJspConfigurationManager() {
        return this.jspConfigurationManager;
    }

    public JspClassloaderContext getJspClassloaderContext() {
        return this;
    }

    public String getOptimizedClassPath() {
        return this.getClassPath();
    }

    public boolean isPredefineClassEnabled() {
        return false;
    }

    public byte[] predefineClass(String className, byte[] classData) {
        return null;
    }
}

