/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.util;

import com.ibm.ws.jsp.Constants;
import com.ibm.ws.jsp.configuration.JspConfigPropertyGroup;
import com.ibm.ws.jsp.runtime.metadata.JspComponentMetaData;
import com.ibm.ws.util.URIMatcher;
import com.ibm.ws.webcontainer.servlet.ServletConfig;
import com.ibm.ws.webcontainer.servlet.ServletMapping;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JspURIMatcher
extends URIMatcher {
    private static final Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.ibm.ws.jsf.util.JspURIMatcher";
    private Map sortedMap = new TreeMap();

    public JspURIMatcher(IServletContext webapp) {
        this.addImplicitJspMappings();
        this.addJspFileExtensions(webapp);
        this.addPropertyGroupExtensions(webapp);
        this.addJspMappedServlets(webapp);
    }

    private void addImplicitJspMappings() {
        for (int i = 0; i < Constants.STANDARD_JSP_EXTENSIONS.length; ++i) {
            String uri = Constants.STANDARD_JSP_EXTENSIONS[i];
            this.put(uri, "implicitJspExtensions");
        }
    }

    private void addJspFileExtensions(IServletContext webapp) {
        WebAppConfig webGroupCfg = webapp.getWebAppConfig();
        Map jspPropsMap = webGroupCfg.getJspAttributes();
        String list = (String)jspPropsMap.get("jsp.file.extensions");
        if (list != null) {
            StringTokenizer st = new StringTokenizer(list, ": ;");
            while (st.hasMoreTokens()) {
                String ext = st.nextToken();
                this.put(ext, "jsp.file.extension");
            }
        }
    }

    private void addPropertyGroupExtensions(IServletContext webapp) {
        WebAppConfig webGroupCfg = webapp.getWebAppConfig();
        JspComponentMetaData jspMetadata = (JspComponentMetaData)webGroupCfg.getMetaData().getJspComponentMetadata();
        List jspPropertyGroups = jspMetadata.getJspPropertyGroups();
        for (JspConfigPropertyGroup jspPropertyGroup : jspPropertyGroups) {
            for (String urlPattern : jspPropertyGroup.getUrlPatterns()) {
                this.put(urlPattern, "jspPropertyGroupURI");
            }
        }
    }

    private void addJspMappedServlets(IServletContext webapp) {
        WebAppConfig config = webapp.getWebAppConfig();
        Iterator itr = config.getServletInfos();
        while (itr.hasNext()) {
            List mappings;
            ServletConfig sconfig = (ServletConfig)itr.next();
            if (!sconfig.isJsp() || (mappings = sconfig.getMappings()) == null || mappings.isEmpty()) continue;
            for (ServletMapping servletMapping : mappings) {
                String urlPattern = servletMapping.getUrlPattern();
                this.put(urlPattern, "jspMappedServlets");
            }
        }
    }

    public void put(String uri, Object target) {
        try {
            super.put(uri, target);
            log.logp(Level.FINE, CLASS_NAME, "put", "adding [" + uri + "] target =[" + target + "]");
            this.sortedMap.put(uri, target);
        }
        catch (Exception e) {
            log.logp(Level.FINEST, CLASS_NAME, "put", "problem occured when adding new target [" + uri + "] target =[" + target + "]", e);
        }
    }

    public String toString() {
        return this.sortedMap.toString();
    }
}

