/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.extprocessor;

import com.ibm.ws.jsf.JSFConstants;
import com.ibm.ws.jsf.extprocessor.JSFExtensionProcessor;
import com.ibm.ws.jsf.util.JspURIMatcher;
import com.ibm.ws.webcontainer.webapp.WebAppImpl;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.sun.faces.config.ConfigureListener;
import com.sun.faces.util.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class JSFExtensionFactory
implements ExtensionFactory {
    protected static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.ibm.ws.jsf.extprocessor.JSFExtensionFactory";
    private static String FACES_SERVLET_RESOURCE = "javax/faces/webapp/FacesServlet.class";
    private URL defaultFacesServlet = Util.getCurrentLoader(this).getResource(FACES_SERVLET_RESOURCE);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExtensionProcessor createExtensionProcessor(IServletContext webapp) throws Exception {
        String s;
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "createExtensionProcessor", "Enter createExtensionProcessor(): webapp =[" + webapp.getServletContextName() + "]");
        }
        WebApp descriptor = ((WebAppImpl)webapp).getDeployedModule().getDeploymentDescriptor();
        EList servlets = descriptor.getServlets();
        boolean isFacesApp = false;
        for (Object obj : servlets) {
            Servlet servlet = (Servlet)obj;
            if (servlet.getWebType() == null || !servlet.getWebType().isServletType() || servlet.getServletClass() == null || !"javax.faces.webapp.FacesServlet".equals(servlet.getServletClass().getJavaName())) continue;
            isFacesApp = true;
            break;
        }
        if (!isFacesApp) {
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "createExtensionProcessor", "JSF is enabled for webapp: [" + webapp.getServletContextName() + "]");
        }
        URL facesResourceURL = null;
        if (System.getSecurityManager() != null) {
            final IServletContext _webapp = webapp;
            facesResourceURL = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MalformedURLException {
                    return _webapp.getClassLoader().getResource(FACES_SERVLET_RESOURCE);
                }
            });
        } else {
            facesResourceURL = webapp.getClassLoader().getResource(FACES_SERVLET_RESOURCE);
        }
        if (facesResourceURL != null && (s = webapp.getInitParameter(JSFConstants.JSF_IMPL_CHECK)) != null && s.equalsIgnoreCase("TRUE")) {
            webapp.setAttribute(JSFConstants.JSF_IMPL_CHECK, "TRUE");
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "createExtensionProcessor", JSFConstants.JSF_IMPL_CHECK + " was set to 'TRUE' in the web.xml.  JSPs will be recompiled for this application upon first access.");
            }
        }
        if (!this.defaultFacesServlet.equals(facesResourceURL)) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "createExtensionProcessor", "Application overrode default Faces Servlet. WebSphere SUN RI JSF config will be ignored.");
            }
            ServletRequestListener servletRequestListener = null;
            HttpSessionListener httpSessionListener = null;
            ServletRequestAttributeListener servletRequestAttributeListener = null;
            HttpSessionAttributeListener httpSessionAttributeListener = null;
            ServletContextAttributeListener servletContextAttributeListener = null;
            ServletContextListener startupServletContextListener = null;
            try {
                ClassLoader classLoader;
                if (System.getSecurityManager() != null) {
                    final IServletContext _webapp = webapp;
                    classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public ClassLoader run() throws InstantiationException, IllegalAccessException {
                            return _webapp.getClassLoader();
                        }
                    });
                } else {
                    classLoader = webapp.getClassLoader();
                }
                startupServletContextListener = (ServletContextListener)Class.forName("org.apache.myfaces.webapp.StartupServletContextListener", true, classLoader).newInstance();
                startupServletContextListener.getClass().getMethod("WASConfig", null);
                servletRequestListener = (ServletRequestListener)Class.forName("org.apache.myfaces.webapp.MyFacesServletRequestListener", true, classLoader).newInstance();
                httpSessionListener = (HttpSessionListener)Class.forName("org.apache.myfaces.webapp.MyFacesHttpSessionListener", true, classLoader).newInstance();
                servletRequestAttributeListener = (ServletRequestAttributeListener)Class.forName("org.apache.myfaces.webapp.MyfacesServletRequestAttributeListener", true, classLoader).newInstance();
                httpSessionAttributeListener = (HttpSessionAttributeListener)Class.forName("org.apache.myfaces.webapp.MyFacesHttpSessionAttributeListener", true, classLoader).newInstance();
                servletContextAttributeListener = (ServletContextAttributeListener)Class.forName("org.apache.myfaces.webapp.MyFacesServletContextListener", true, classLoader).newInstance();
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "initFaces", "MyFaces JSF Implementation found and will be used to configure the application.");
                }
                webapp.addLifecycleListener(servletRequestListener);
                webapp.addLifecycleListener(httpSessionListener);
                webapp.addLifecycleListener(servletRequestAttributeListener);
                webapp.addLifecycleListener(httpSessionAttributeListener);
                webapp.addLifecycleListener(servletContextAttributeListener);
                webapp.addLifecycleListener(startupServletContextListener);
                return new JSFExtensionProcessor(webapp);
            }
            catch (ClassNotFoundException e) {
                if (!log.isLoggable(Level.FINE)) return new JSFExtensionProcessor(webapp);
                log.logp(Level.FINE, CLASS_NAME, "initFaces", "No JSF Implementation configured from the runtime.  JSF will be used from the Application if configured.");
                return new JSFExtensionProcessor(webapp);
            }
            catch (NoSuchMethodException e) {
                if (!log.isLoggable(Level.FINE)) return new JSFExtensionProcessor(webapp);
                log.logp(Level.FINE, CLASS_NAME, "initFaces", "No JSF Implementation configured from the runtime.  JSF will be used from the Application if configured.");
                return new JSFExtensionProcessor(webapp);
            }
            catch (Exception e) {
                throw e;
            }
        } else {
            s = webapp.getInitParameter(JSFConstants.JSP_UPDATE_CHECK);
            if (s != null && s.equalsIgnoreCase("TRUE")) {
                JspURIMatcher matcher = new JspURIMatcher(webapp);
                webapp.setAttribute(JSFConstants.JSP_URI_MATCHER, (Object)matcher);
            }
            webapp.addLifecycleListener(new ConfigureListener());
        }
        return new JSFExtensionProcessor(webapp);
    }

    public List getPatternList() {
        return Collections.EMPTY_LIST;
    }
}

