/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.configuration;

import com.ibm.ws.jsf.JSFConstants;
import com.ibm.ws.jsf.util.FacesConfigUtil;
import com.sun.faces.RIConstants;
import com.sun.faces.util.Util;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

public final class FacesConfig {
    private static Set<ClassLoader> loaders = new HashSet<ClassLoader>();
    private static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.ibm.ws.jsf.config.FacesConfig";

    public void initialize(ServletContext context, boolean foundFacesServletMapping) {
        String initConfigStr;
        boolean initConfig;
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "initialize", "Servlet context name(" + context.getServletContextName() + ")");
        }
        if (this.initialized()) {
            return;
        }
        String enableHtmlTLValidator = null;
        enableHtmlTLValidator = context.getInitParameter("com.sun.faces.enableHtmlTagLibValidator");
        if (null != enableHtmlTLValidator) {
            if (enableHtmlTLValidator.toString().equals("true")) {
                RIConstants.setHtmlTagLibValidatorActive(true);
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "initialize", "Webmodule enabled Html tag library validation");
                }
            } else if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initialize", "Webmodule disabled Html Tag Library validation [" + enableHtmlTLValidator.toString() + "]");
            }
        }
        if ((initConfig = new Boolean(initConfigStr = context.getInitParameter(JSFConstants.LOAD_FACES_CONFIG_STARTUP)).booleanValue()) || foundFacesServletMapping) {
            if (null == context.getAttribute("com.sun.faces.OneTimeInitialization")) {
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "initialize", "Webmodule requested config to be loaded at startup or defined FacesServlet mapping in web.xml.");
                }
            } else if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initialize", "Configuration already loaded for this webmodule");
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initialize", "Create default factories. Delay loading of JSF config to first request.");
            }
            FacesConfigUtil.createDefaultJSFFactories();
        }
        context.setAttribute("com.sun.faces.ConfigBase", Boolean.TRUE);
    }

    public void destroy(ServletContext context) {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "destroy", "Servlet context name(" + context.getServletContextName() + ")");
        }
        context.removeAttribute("com.sun.faces.ConfigBase");
        this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initialized() {
        ClassLoader cl = Util.getCurrentLoader(this);
        Set<ClassLoader> set = loaders;
        synchronized (set) {
            if (!loaders.contains(cl)) {
                loaders.add(cl);
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "initialized", "Initializing this webapp");
                }
                return false;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initialized", "Listener already completed for this webapp");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        ClassLoader cl = Util.getCurrentLoader(this);
        Set<ClassLoader> set = loaders;
        synchronized (set) {
            loaders.remove(cl);
        }
    }
}

