/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.admin;

import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.ws.jsf.admin.ListJSFImplementationCommand;
import com.ibm.ws.jsf.admin.ModifyJSFImplementationCommand;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JSFCommandProvider
extends CommandProvider {
    private static final String MODIFY_JSF_IMPL_COMMAND_NAME = "modifyJSFImplementation";
    private static final String LIST_JSF_IMPL_COMMAND_NAME = "listJSFImplementation";
    private static transient Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final transient String CLASS_NAME = "com.ibm.ws.jsf.admin.JSFCommandProvider";

    public AbstractAdminCommand createCommand(CommandMetadata metadata2) throws CommandNotFoundException {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "createCommand", "CommandMetadata(" + metadata2 + ")");
        }
        String taskName = metadata2.getName();
        AbstractAdminCommand command = null;
        if (taskName.equals(MODIFY_JSF_IMPL_COMMAND_NAME)) {
            command = new ModifyJSFImplementationCommand(metadata2);
        } else if (taskName.equals(LIST_JSF_IMPL_COMMAND_NAME)) {
            command = new ListJSFImplementationCommand(metadata2);
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "createCommand", "Cannot find task command " + taskName + " to create.");
            }
            throw new CommandNotFoundException(taskName);
        }
        return command;
    }

    public AbstractAdminCommand loadCommand(CommandData cmdData) throws CommandNotFoundException, CommandLoadException {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "loadCommand", "CommandData(" + cmdData + ")");
        }
        String taskName = cmdData.getName();
        AbstractAdminCommand command = null;
        if (taskName.equals(MODIFY_JSF_IMPL_COMMAND_NAME)) {
            command = new ModifyJSFImplementationCommand(cmdData);
        } else if (taskName.equals(LIST_JSF_IMPL_COMMAND_NAME)) {
            command = new ListJSFImplementationCommand(cmdData);
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "loadCommand", "Cannot find task command " + taskName + " to create.");
            }
            throw new CommandNotFoundException(taskName);
        }
        return command;
    }
}

