/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.utils;

import com.ibm.ws.install.configmanager.ConfigManager;
import com.ibm.ws.install.configmanager.actionengine.ValidatorConfigAction;
import com.ibm.ws.install.configmanager.launcher.ArgumentValueFetcher;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.SystemPropertiesUtils;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ValidationManager {
    private Map<String, List<ValidatorConfigAction>> m_mapValidators = null;
    private Map m_mapOmittedValidators = null;
    private Hashtable<String, Vector<String>> m_hashtableValidationErrorMessages = null;
    private String m_sTemplatePath = "";
    private String m_sActionRegistry = "";
    private static final Logger LOGGER = LoggerFactory.createLogger(ValidationManager.class);
    private static final String S_CLASS_NAME = ValidationManager.class.getName();
    public static final String S_VALIDATION_ERROR_MSG_KEY = "validationErrorMessage";
    private static final boolean F_DEFAULT_VALIDATION_VALUE = true;
    public static final String S_VALIDATOR_ARG_KEY = "validatorArgKey";
    private static final String S_TEMPLATE_PATH = "templatePath";
    private static final String S_COLON = ":";
    private static final String S_DELIM = ",";
    private static final String S_ALL_ARG = "all";

    public ValidationManager(String sTemplatePath, String sActionRegistry) {
        LOGGER.entering(ValidationManager.class.getName(), "ValidationManager");
        this.initialize(sTemplatePath, sActionRegistry);
        LOGGER.exiting(ValidationManager.class.getName(), "ValidationManager");
    }

    public ValidationManager() {
        LOGGER.entering(ValidationManager.class.getName(), "ValidationManager");
        String sTemplatePath = ValidationManager.determineTemplatePath();
        String sActionRegistry = ValidationManager.determineActionRegistry();
        this.initialize(sTemplatePath, sActionRegistry);
        LOGGER.exiting(ValidationManager.class.getName(), "ValidationManager");
    }

    private void initialize(String sTemplatePath, String sActionRegistry) {
        LOGGER.entering(ValidationManager.class.getName(), "initialize");
        this.m_sTemplatePath = sTemplatePath;
        this.m_sActionRegistry = sActionRegistry;
        Properties propertiesStored = SystemPropertiesUtils.getCurrentSystemProperties();
        System.setProperty("WS_CMT_ACTION_REGISTRY", sActionRegistry);
        this.m_mapValidators = ConfigManager.getValidatorHashtable(sTemplatePath);
        this.m_hashtableValidationErrorMessages = new Hashtable();
        SystemPropertiesUtils.resetSystemProperties(propertiesStored);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "initialize", "Created ValidationManager with templatePath=" + sTemplatePath + ", actionRegistry=" + sActionRegistry);
        LOGGER.exiting(ValidationManager.class.getName(), "initialize");
    }

    private Map getOmittedValidators() {
        String[] saOptionalValidation = ArgumentValueFetcher.getArgumentValues("omitValidation");
        if (saOptionalValidation == null || saOptionalValidation.length <= 0) {
            return null;
        }
        Hashtable<String, Vector> htOmittedValidators = new Hashtable<String, Vector>();
        for (int i = 0; i < saOptionalValidation.length; ++i) {
            int rIndex = saOptionalValidation[i].indexOf(S_COLON);
            if (rIndex <= 0) continue;
            String sParm = saOptionalValidation[i].substring(0, rIndex);
            StringTokenizer tokenizer = new StringTokenizer(saOptionalValidation[i].substring(rIndex + 1), S_DELIM);
            Vector<String> vValidators = new Vector<String>();
            while (tokenizer.hasMoreTokens()) {
                String sToken = tokenizer.nextToken();
                if (vValidators.contains(sToken)) continue;
                vValidators.add(sToken);
            }
            if (htOmittedValidators.get(sParm) == null) {
                htOmittedValidators.put(sParm, vValidators);
                continue;
            }
            Vector vTemp = (Vector)htOmittedValidators.get(sParm);
            for (int j = 0; j < vValidators.size(); ++j) {
                if (vTemp.contains(vValidators.get(j))) continue;
                vTemp.add(vValidators.get(j));
            }
            htOmittedValidators.put(sParm, vTemp);
        }
        return htOmittedValidators;
    }

    public boolean areAllArgumentsValid(Map mapAllArguments) {
        LOGGER.entering(ValidationManager.class.getName(), "areAllArgumentsValid");
        Map mapUpdatedArguments = this.addTemplateSpecificArguments(mapAllArguments);
        Properties propertiesStoredSystemProperties = SystemPropertiesUtils.setArgumentsIntoSystemProperties(mapUpdatedArguments);
        this.clearErrorMessages();
        boolean fIsValid = this.areAllArgumentsValid();
        SystemPropertiesUtils.resetSystemProperties(propertiesStoredSystemProperties);
        LOGGER.exiting(ValidationManager.class.getName(), "areAllArgumentsValid");
        return fIsValid;
    }

    public Hashtable getAllErrorMessages() {
        LOGGER.entering(ValidationManager.class.getName(), "getAllErrorMessages");
        LOGGER.exiting(ValidationManager.class.getName(), "getAllErrorMessages");
        return this.m_hashtableValidationErrorMessages;
    }

    public List getErrorMessagesForArgument(String sArgumentKey) {
        LOGGER.entering(ValidationManager.class.getName(), "initialize");
        LOGGER.exiting(ValidationManager.class.getName(), "parseOutputForErrorMessage");
        return this.m_hashtableValidationErrorMessages.get(sArgumentKey);
    }

    public boolean isArgumentValueValid(String sArgumentKey, Map mapAllActionArguments) {
        LOGGER.entering(ValidationManager.class.getName(), "isArgumentValueValid");
        Map mapUpdatedArguments = this.addTemplateSpecificArguments(mapAllActionArguments);
        Properties propertiesSystemProps = SystemPropertiesUtils.setArgumentsIntoSystemProperties(mapUpdatedArguments);
        this.clearErrorMessages();
        boolean fIsValid = this.validateAllValidatorsForArgument(sArgumentKey);
        SystemPropertiesUtils.resetSystemProperties(propertiesSystemProps);
        LOGGER.exiting(ValidationManager.class.getName(), "isArgumentValueValid");
        return fIsValid;
    }

    public boolean isArgumentValueValid(String sArgumentKey, String sArgumentValue) {
        LOGGER.entering(ValidationManager.class.getName(), "isArgumentValueValid");
        Hashtable<String, String> mapAllArgs = new Hashtable<String, String>();
        mapAllArgs.put(sArgumentKey, sArgumentValue);
        Map mapUpdatedArguments = this.addTemplateSpecificArguments(mapAllArgs);
        Properties propertiesStoredSystemProperties = SystemPropertiesUtils.setArgumentsIntoSystemProperties(mapUpdatedArguments);
        this.clearErrorMessages();
        boolean fIsValidationSuccessful = this.isArgumentValueValid(sArgumentKey);
        SystemPropertiesUtils.resetSystemProperties(propertiesStoredSystemProperties);
        LOGGER.exiting(ValidationManager.class.getName(), "isArgumentValueValid");
        return fIsValidationSuccessful;
    }

    public boolean isArgumentValueValid(String sArgumentKey, String sArgumentValue, Map mapAllActionArguments) {
        LOGGER.entering(ValidationManager.class.getName(), "isArgumentValueValid");
        Hashtable<String, String> mapAllArgs = new Hashtable<String, String>(mapAllActionArguments);
        mapAllArgs.put(sArgumentKey, sArgumentValue);
        Map mapUpdatedArguments = this.addTemplateSpecificArguments(mapAllArgs);
        Properties propertiesStoredSystemProperties = SystemPropertiesUtils.setArgumentsIntoSystemProperties(mapUpdatedArguments);
        this.clearErrorMessages();
        boolean fIsValidationSuccessful = this.isArgumentValueValid(sArgumentKey);
        SystemPropertiesUtils.resetSystemProperties(propertiesStoredSystemProperties);
        LOGGER.exiting(ValidationManager.class.getName(), "isArgumentValueValid");
        return fIsValidationSuccessful;
    }

    public boolean areAllArgumentsValid(List listArgKeys, Map mapAllActionArguments) {
        LOGGER.entering(ValidationManager.class.getName(), "areAllArgumentsValid");
        boolean fOverallValidationValue = true;
        Map mapUpdatedArguments = this.addTemplateSpecificArguments(mapAllActionArguments);
        Properties propertiesSystemProps = SystemPropertiesUtils.setArgumentsIntoSystemProperties(mapUpdatedArguments);
        this.clearErrorMessages();
        for (int i = 0; i < listArgKeys.size(); ++i) {
            if (this.validateAllValidatorsForArgument((String)listArgKeys.get(i))) continue;
            fOverallValidationValue = false;
        }
        SystemPropertiesUtils.resetSystemProperties(propertiesSystemProps);
        LOGGER.exiting(ValidationManager.class.getName(), "isArgumentValueValid");
        return fOverallValidationValue;
    }

    public boolean isArgumentAvailableForValidating(String sArgumentKey) {
        LOGGER.entering(ValidationManager.class.getName(), "isArgumentAvailableForValidating");
        Vector vValidators = (Vector)this.m_mapValidators.get(sArgumentKey);
        LOGGER.exiting(ValidationManager.class.getName(), "isArgumentAvailableForValidating");
        return vValidators != null;
    }

    public void reinitialize() {
        LOGGER.entering(ValidationManager.class.getName(), "reinitialize");
        this.m_mapValidators = null;
        this.m_hashtableValidationErrorMessages = null;
        this.initialize(this.m_sTemplatePath, this.m_sActionRegistry);
        LOGGER.exiting(ValidationManager.class.getName(), "reinitialize");
    }

    public String toString() {
        return this.getActionRegistry();
    }

    public String getActionRegistry() {
        return this.m_sActionRegistry;
    }

    public String getTemplatePath() {
        return this.m_sTemplatePath;
    }

    private boolean areAllArgumentsValid() {
        LOGGER.entering(ValidationManager.class.getName(), "areAllArgumentsValid");
        boolean fOverallValidationValue = true;
        Iterator<String> iteratorArgumentKeys = this.m_mapValidators.keySet().iterator();
        while (iteratorArgumentKeys.hasNext()) {
            if (this.validateAllValidatorsForArgument(iteratorArgumentKeys.next())) continue;
            fOverallValidationValue = false;
        }
        LOGGER.exiting(ValidationManager.class.getName(), "areAllArgumentsValid");
        return fOverallValidationValue;
    }

    private boolean isArgumentValueValid(String sArgumentKey) {
        LOGGER.entering(ValidationManager.class.getName(), "isArgumentValueValid");
        boolean fIsValid = this.validateAllValidatorsForArgument(sArgumentKey);
        LOGGER.exiting(ValidationManager.class.getName(), "isArgumentValueValid");
        return fIsValid;
    }

    private List parseOutputForErrorMessages(String sOutput) {
        LOGGER.entering(ValidationManager.class.getName(), "parseOutputForErrorMessages");
        Vector<String> vValidationErrorMessages = new Vector<String>();
        if (sOutput == null || sOutput.equals("")) {
            return vValidationErrorMessages;
        }
        String[] saValidationErrorMessages = sOutput.split("validationErrorMessage=");
        for (int i = 1; i < saValidationErrorMessages.length; ++i) {
            if (saValidationErrorMessages == null || saValidationErrorMessages[i].equals("")) continue;
            vValidationErrorMessages.add(saValidationErrorMessages[i].trim());
        }
        LOGGER.exiting(ValidationManager.class.getName(), "parseOutputForErrorMessages");
        return vValidationErrorMessages;
    }

    private void storeErrorMessage(String sArgumentKey, String sOutput) {
        List listArgumentValidationErrorMessage;
        LOGGER.entering(ValidationManager.class.getName(), "storeErrorMessage");
        if (this.m_hashtableValidationErrorMessages.containsKey(sArgumentKey) && (listArgumentValidationErrorMessage = (List)this.m_hashtableValidationErrorMessages.get(sArgumentKey)) != null && listArgumentValidationErrorMessage.size() != 0) {
            List lErrorMessages = this.parseOutputForErrorMessages(sOutput);
            for (int i = 0; i < lErrorMessages.size(); ++i) {
                String sErrorMessage = (String)lErrorMessages.get(i);
                if (listArgumentValidationErrorMessage.contains(sErrorMessage)) continue;
                listArgumentValidationErrorMessage.add(sErrorMessage);
                LOGGER.exiting(ValidationManager.class.getName(), "storeErrorMessage");
            }
            return;
        }
        Vector<String> vInitialListOfErrorMessagesForArgument = new Vector<String>();
        List lErrorMessages = this.parseOutputForErrorMessages(sOutput);
        for (int i = 0; i < lErrorMessages.size(); ++i) {
            String sErrorMessage = (String)lErrorMessages.get(i);
            if (vInitialListOfErrorMessagesForArgument.contains(sErrorMessage)) continue;
            vInitialListOfErrorMessagesForArgument.add(sErrorMessage);
            LOGGER.exiting(ValidationManager.class.getName(), "storeErrorMessage");
        }
        this.m_hashtableValidationErrorMessages.put(sArgumentKey, vInitialListOfErrorMessagesForArgument);
        LOGGER.exiting(ValidationManager.class.getName(), "storeErrorMessage");
    }

    private void clearErrorMessages() {
        LOGGER.entering(ValidationManager.class.getName(), "clearErrorMessages");
        LOGGER.exiting(ValidationManager.class.getName(), "clearErrorMessages");
        this.m_hashtableValidationErrorMessages = new Hashtable();
    }

    private Map addTemplateSpecificArguments(Map mapAllActionArguments) {
        LOGGER.entering(ValidationManager.class.getName(), "addTemplateSpecificArguments");
        Hashtable<String, String> mapTemplateSpecific = new Hashtable<String, String>(mapAllActionArguments);
        if (mapTemplateSpecific.containsKey(S_TEMPLATE_PATH)) {
            mapTemplateSpecific.put(S_TEMPLATE_PATH, this.getTemplatePath());
        }
        mapTemplateSpecific.put("WS_CMT_CONF_DIR", this.getTemplatePath());
        mapTemplateSpecific.put("WS_CMT_ACTION_REGISTRY", this.getActionRegistry());
        LOGGER.exiting(ValidationManager.class.getName(), "addTemplateSpecificArguments");
        return mapTemplateSpecific;
    }

    private boolean validateAllValidatorsForArgument(String sArgumentKey) {
        List<ValidatorConfigAction> listValidators;
        LOGGER.entering(ValidationManager.class.getName(), "validateAllValidatorsForArgument");
        boolean fOverallValidationValue = true;
        this.m_mapOmittedValidators = this.getOmittedValidators();
        if (this.m_mapOmittedValidators == null) {
            this.m_mapOmittedValidators = new Hashtable();
        }
        if ((listValidators = this.m_mapValidators.get(sArgumentKey)) == null || listValidators.size() == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "validateAllValidatorsForArgument", "No validators found for argument" + sArgumentKey);
            LOGGER.exiting(ValidationManager.class.getName(), "validateAllValidatorsForArgument");
            return true;
        }
        Properties propertiesStoredSystemProperties = SystemPropertiesUtils.getCurrentSystemProperties();
        System.setProperty(S_VALIDATOR_ARG_KEY, sArgumentKey);
        Vector vOmitList = (Vector)this.m_mapOmittedValidators.get(sArgumentKey);
        if (vOmitList == null) {
            vOmitList = new Vector();
        }
        for (int i = 0; i < listValidators.size(); ++i) {
            ValidatorConfigAction validator = listValidators.get(i);
            if (!vOmitList.contains(S_ALL_ARG) && !vOmitList.contains(validator.getActionName()) && validator.doIRun()) {
                boolean f = true;
                boolean fValidationValue = validator.executeValidator();
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "validateAllValidatorsForArgument", "Argument " + sArgumentKey + " passed validation? " + fValidationValue);
                if (fValidationValue) continue;
                fOverallValidationValue = fValidationValue;
                this.storeErrorMessage(sArgumentKey, validator.getActionOutput());
                continue;
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "validateAllValidatorsForArgument", "Skipped execution of:" + validator.getActionName());
        }
        SystemPropertiesUtils.resetSystemProperties(propertiesStoredSystemProperties);
        LOGGER.exiting(ValidationManager.class.getName(), "validateAllValidatorsForArgument");
        return fOverallValidationValue;
    }

    private static String determineActionRegistry() {
        LOGGER.entering(ValidationManager.class.getName(), "determineActionRegistry");
        LOGGER.exiting(ValidationManager.class.getName(), "determineActionRegistry");
        return ArgumentValueFetcher.getArgumentValue("WS_CMT_ACTION_REGISTRY");
    }

    private static String determineTemplatePath() {
        LOGGER.entering(ValidationManager.class.getName(), "determineTemplatePath");
        LOGGER.exiting(ValidationManager.class.getName(), "determineTemplatePath");
        return ArgumentValueFetcher.getArgumentValue("WS_CMT_CONF_DIR");
    }
}

