/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.utils;

import com.ibm.ws.install.configmanager.actionengine.ActionArgument;
import com.ibm.ws.install.configmanager.actionengine.ActionRegistryParser;
import com.ibm.ws.install.configmanager.actionengine.ArgumentRegistryParser;
import com.ibm.ws.install.configmanager.actionengine.DefaulterConfigAction;
import com.ibm.ws.install.configmanager.actionengine.Environment;
import com.ibm.ws.install.configmanager.actionengine.Parameter;
import com.ibm.ws.install.configmanager.actionengine.RegistryStructureException;
import com.ibm.ws.install.configmanager.actionengine.ValidatorConfigAction;
import com.ibm.ws.install.configmanager.launcher.ArgumentValueFetcher;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.install.configmanager.osutils.TargetPlatform;
import com.ibm.ws.install.configmanager.utils.EnvironmentUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryParsingUtils {
    private static final String S_TAG_REG_PATH = "path";
    private static final String S_TAG_REG_PRIORITY = "priority";
    private static final String S_TAG_REG_SUPPORTED_ENVIRONMENTS = "supportedEnvironments";
    private static final String S_TAG_REG_ALIAS = "alias";
    private static final String S_TAG_REG_DEFAULTER = "defaulter";
    private static final String S_TAG_REG_VALIDATOR = "validator";
    private static final String S_TAG_REG_KEY = "key";
    private static final String S_TAG_REG_VALUES = "values";
    private static final String S_TAG_REG_REQUIRED = "required";
    private static final String S_TAG_REG_HELP_BUNDLE = "helpbundle";
    private static final String S_TAG_REG_PLATFORM = "platform";
    private static final String S_TAG_REG_ISVISIBLE = "isVisible";
    private static final String S_TAG_REG_ARGUMENT = "argument";
    private static final String S_EMPTY = "";
    private static final String S_DEFAULTER_IS_FATAL = "false";
    private static final String S_DEFAULTER_IS_OPTIONAL = "false";
    private static final String S_VALIDATOR_IS_FATAL = "true";
    private static final String S_VALIDATOR_IS_OPTIONAL = "false";
    private static final String S_VALIDATOR_PRIORITY = "01";
    private static final String S_REGISTRY_ERROR_DEF_ORVALIDATORS_IN_ARGUMENY_REG = "Argument defaulter and validators definitions were found within the action registry, while argument registry is available. The registry model is corrupt.";
    private static final String S_REGISTRY_ERROR_ARG_ATTR_IN_ARGUMENT_REG = "Argument attributes were found within the action registry, while argument registry is available. The registry model is corrupt.";
    private static final Logger LOGGER = LoggerFactory.createLogger(RegistryParsingUtils.class);
    private static final String S_CLASS_NAME = RegistryParsingUtils.class.getName();

    public static List<ValidatorConfigAction> getValidatorsForTheGivenArgumentNode(Node nodeArgument) {
        LOGGER.entering(ActionRegistryParser.class.getName(), "getValidatorsForTheGivenArgumentNode");
        Vector<ValidatorConfigAction> listValidatorsForThisArgument = new Vector<ValidatorConfigAction>();
        NodeList nodeListArgumentChildNodes = nodeArgument.getChildNodes();
        NamedNodeMap namedNodeMapOfArgumentAttributes = nodeArgument.getAttributes();
        String sArgumentKeyName = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_KEY, namedNodeMapOfArgumentAttributes);
        for (int j = 0; j < nodeListArgumentChildNodes.getLength(); ++j) {
            Node nodeArgumentChildNode = nodeListArgumentChildNodes.item(j);
            if (!nodeArgumentChildNode.getNodeName().equals(S_TAG_REG_VALIDATOR)) continue;
            NamedNodeMap namedNodeMapOfAttributes = nodeArgumentChildNode.getAttributes();
            String sActionFilePathRelativeToConfigRepository = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_PATH, namedNodeMapOfAttributes);
            String sActionAlias = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_ALIAS, namedNodeMapOfAttributes);
            List<Environment> sSupportedEnvironments = EnvironmentUtils.split(RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_SUPPORTED_ENVIRONMENTS, namedNodeMapOfAttributes));
            if (sSupportedEnvironments == null) {
                sSupportedEnvironments = new ArrayList<Environment>();
                sSupportedEnvironments.add(Environment.LOCAL);
            }
            String sActionIsFatal = S_VALIDATOR_IS_FATAL;
            String sActionIsOptional = "false";
            String sActionPriority = S_VALIDATOR_PRIORITY;
            String sActionDescriptionBundle = S_EMPTY;
            if (sActionFilePathRelativeToConfigRepository == null || sActionIsFatal == null) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getValidatorsForTheGivenArgumentNode", "Encountered invalid or missing attributes for a validator, skipping it, argument registry is possibly corrupt");
                continue;
            }
            int nActionPriority = 999999999;
            if (sActionPriority != null) {
                nActionPriority = Integer.parseInt(sActionPriority);
            }
            if (sActionAlias == null) {
                sActionAlias = S_EMPTY;
            }
            boolean fIsFatal = Boolean.valueOf(sActionIsFatal);
            boolean fIsOptional = Boolean.valueOf(sActionIsOptional);
            String sActionFileAbsolutePath = new File(ArgumentValueFetcher.getArgumentValue("WS_CMT_CONF_DIR"), sActionFilePathRelativeToConfigRepository).getAbsolutePath();
            ValidatorConfigAction caValidatorThis = new ValidatorConfigAction(sActionFileAbsolutePath, nActionPriority, fIsFatal, RegistryParsingUtils.getParameterListFromANode(nodeArgumentChildNode.getChildNodes()), sActionDescriptionBundle, fIsOptional, sActionAlias, sSupportedEnvironments);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getValidatorsForTheGivenArgumentNode", "Registered a validator for the argument: " + sArgumentKeyName);
            listValidatorsForThisArgument.add(caValidatorThis);
        }
        LOGGER.exiting(ActionRegistryParser.class.getName(), "getValidatorsForTheGivenArgumentNode");
        return listValidatorsForThisArgument;
    }

    public static DefaulterConfigAction getDefaulterForTheGivenArgumentNode(Node nodeArgument) {
        LOGGER.entering(ActionRegistryParser.class.getName(), "getDefaultersForTheGivenArgumentNode");
        DefaulterConfigAction caDefaulterForThisArgument = null;
        NodeList nodeListArgumentChildNodes = nodeArgument.getChildNodes();
        NamedNodeMap namedNodeMapOfArgumentAttributes = nodeArgument.getAttributes();
        String sArgumentKeyName = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_KEY, namedNodeMapOfArgumentAttributes);
        for (int j = 0; j < nodeListArgumentChildNodes.getLength(); ++j) {
            List<Environment> sSupportedEnvironments;
            Node nodeArgumentChildNode = nodeListArgumentChildNodes.item(j);
            if (!nodeArgumentChildNode.getNodeName().equals(S_TAG_REG_DEFAULTER)) continue;
            NamedNodeMap namedNodeMapOfDefaulterAttributes = nodeArgumentChildNode.getAttributes();
            String sActionFilePathRelativeToConfigRepository = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_PATH, namedNodeMapOfDefaulterAttributes);
            String sActionPriority = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_PRIORITY, namedNodeMapOfDefaulterAttributes);
            String sActionIsFatal = "false";
            String sActionIsOptional = "false";
            String sActionDescriptionBundle = S_EMPTY;
            String sActionAlias = S_EMPTY;
            if (sActionFilePathRelativeToConfigRepository == null || sActionIsFatal == null) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getDefaulterForTheGivenArgumentNode", "Encountered invalid or missing attributes for a defaulter, skipping it, action registry is possibly corrupt");
                continue;
            }
            int nActionPriority = 999999999;
            if (sActionPriority != null) {
                nActionPriority = Integer.parseInt(sActionPriority);
            }
            if ((sSupportedEnvironments = EnvironmentUtils.split(RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_SUPPORTED_ENVIRONMENTS, namedNodeMapOfDefaulterAttributes))) == null) {
                sSupportedEnvironments = new ArrayList<Environment>();
                sSupportedEnvironments.add(Environment.LOCAL);
            }
            boolean fIsFatal = Boolean.valueOf(sActionIsFatal);
            boolean fIsOptional = Boolean.valueOf(sActionIsOptional);
            String sActionFileAbsolutePath = new File(ArgumentValueFetcher.getArgumentValue("WS_CMT_CONF_DIR"), sActionFilePathRelativeToConfigRepository).getAbsolutePath();
            DefaulterConfigAction caDefaulterThis = new DefaulterConfigAction(sActionFileAbsolutePath, nActionPriority, fIsFatal, RegistryParsingUtils.getParameterListFromANode(nodeArgumentChildNode.getChildNodes()), sActionDescriptionBundle, fIsOptional, sActionAlias, sSupportedEnvironments);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getDefaulterForTheGivenArgumentNode", "Registered a defaulter for the argument: " + sArgumentKeyName);
            caDefaulterForThisArgument = caDefaulterThis;
        }
        LOGGER.exiting(ActionRegistryParser.class.getName(), "getDefaultersForTheGivenArgumentNode");
        return caDefaulterForThisArgument;
    }

    public static String getAttributeValueFromGivenNamedNodeMapOfAttributes(String sAttributeName, NamedNodeMap namednodemapAttributes) {
        LOGGER.entering(S_CLASS_NAME, "getAttributeValueFromGivenNamedNodeMapOfAttributes");
        for (int nAttributeNumber = 0; nAttributeNumber < namednodemapAttributes.getLength(); ++nAttributeNumber) {
            Node nodeAttributeThis = namednodemapAttributes.item(nAttributeNumber);
            String sAttributeNameThis = nodeAttributeThis.getNodeName();
            if (!sAttributeNameThis.equals(sAttributeName)) continue;
            LOGGER.exiting(S_CLASS_NAME, "getAttributeValueFromGivenNamedNodeMapOfAttributes");
            return nodeAttributeThis.getNodeValue();
        }
        LOGGER.exiting(S_CLASS_NAME, "getAttributeValueFromGivenNamedNodeMapOfAttributes");
        return null;
    }

    public static List<ActionArgument> getActionArgumentListForTheGivenNode(Node node) {
        LOGGER.entering(ActionRegistryParser.class.getName(), "getActionArgumentListForTheGivenActionNode");
        Vector<ActionArgument> listArgumentsForThisAction = new Vector<ActionArgument>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node nodeThis = nodeList.item(i);
            if (!nodeThis.getNodeName().equals(S_TAG_REG_ARGUMENT)) continue;
            NamedNodeMap namednodemapAttributes = nodeThis.getAttributes();
            String sArgumentKeyName = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_KEY, namednodemapAttributes);
            if (sArgumentKeyName == null) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getActionArgumentListForTheGivenActionNode", "Invalid argument entries found for an action, skipping, action registry is possibly corrupt");
                continue;
            }
            String sValuesExpected = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_VALUES, namednodemapAttributes);
            int nValuesExpected = 0;
            if (sValuesExpected != null) {
                try {
                    nValuesExpected = Integer.parseInt(sValuesExpected);
                }
                catch (NumberFormatException e) {
                    LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getActionArgumentListForTheGivenActionNode", "Priority coded incorrectly for argument: " + sArgumentKeyName);
                    LogUtils.logException(LOGGER, e);
                }
            }
            String sIsRequired = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_REQUIRED, namednodemapAttributes);
            boolean fArgumentRequired = Boolean.valueOf(sIsRequired);
            String sHelpBundle = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_HELP_BUNDLE, namednodemapAttributes);
            String sIsVisible = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_ISVISIBLE, namednodemapAttributes);
            String sPlatform = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_PLATFORM, namednodemapAttributes);
            DefaulterConfigAction caDefaulter = RegistryParsingUtils.getDefaulterForTheGivenArgumentNode(nodeThis);
            List<ValidatorConfigAction> listValidators = RegistryParsingUtils.getValidatorsForTheGivenArgumentNode(nodeThis);
            if (sPlatform != null && !TargetPlatform.getPlatformName().equalsIgnoreCase(sPlatform)) continue;
            ActionArgument aa = null;
            if (sIsVisible != null) {
                boolean fArgumentVisible = Boolean.valueOf(sIsVisible);
                aa = new ActionArgument(sArgumentKeyName, nValuesExpected, fArgumentRequired, fArgumentVisible, sHelpBundle, caDefaulter, listValidators);
            } else {
                aa = new ActionArgument(sArgumentKeyName, nValuesExpected, fArgumentRequired, sHelpBundle, caDefaulter, listValidators);
            }
            listArgumentsForThisAction.add(aa);
        }
        LOGGER.exiting(ActionRegistryParser.class.getName(), "getActionArgumentListForTheGivenActionNode");
        return listArgumentsForThisAction;
    }

    public static List<ActionArgument> getActionArgumentListForTheGivenNodeFromArgumentRegistry(Document document, Node nodeAction) throws RegistryStructureException {
        LOGGER.entering(ActionRegistryParser.class.getName(), "getActionArgumentListForTheGivenActionNodeFromArgumentRegistry");
        Vector<ActionArgument> listArgumentsForThisAction = new Vector<ActionArgument>();
        NodeList nodeList = nodeAction.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node nodeThis = nodeList.item(i);
            if (!nodeThis.getNodeName().equals(S_TAG_REG_ARGUMENT)) continue;
            NamedNodeMap namednodemapAttributes = nodeThis.getAttributes();
            String sArgumentKeyName = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_KEY, namednodemapAttributes);
            if (sArgumentKeyName == null) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getActionArgumentListForTheGivenActionNodeFromArgumentRegistry", "Invalid argument entries found for an action, skipping, action registry is possibly corrupt");
                continue;
            }
            if (namednodemapAttributes.getLength() > 1) {
                throw new RegistryStructureException(S_REGISTRY_ERROR_ARG_ATTR_IN_ARGUMENT_REG);
            }
            if (nodeThis.getChildNodes().getLength() > 0) {
                throw new RegistryStructureException(S_REGISTRY_ERROR_DEF_ORVALIDATORS_IN_ARGUMENY_REG);
            }
            ActionArgument aa = ArgumentRegistryParser.getActionArgument(document, sArgumentKeyName);
            if (aa != null) {
                listArgumentsForThisAction.add(aa);
                continue;
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getActionArgumentListForTheGivenActionNodeFromArgumentRegistry", sArgumentKeyName + " argument definition is not present within the parsed argument registry. " + "Skipping this argument");
        }
        LOGGER.exiting(ActionRegistryParser.class.getName(), "getActionArgumentListForTheGivenActionNodeFromArgumentRegistry");
        return listArgumentsForThisAction;
    }

    public static Document parseRegistryXMLFileIntoADOMModel(File fileRegistry) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        LOGGER.entering(S_CLASS_NAME, "parseArgumentRegistryXMLFileIntoADOMModel");
        DocumentBuilderFactory documentbuilderfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentbuilder = documentbuilderfactory.newDocumentBuilder();
        Document documentArgumentRegistry = documentbuilder.parse(fileRegistry);
        LOGGER.exiting(S_CLASS_NAME, "parseArgumentRegistryXMLFileIntoADOMModel");
        return documentArgumentRegistry;
    }

    public static String convertRegistryFilePathToRegistryType(File fileRegistry) {
        return fileRegistry.getName();
    }

    public static File convertRelativeRegistryPathToFullRegistryFilePath(String sRegistryType) {
        String sConfigRepositoryPath = ArgumentValueFetcher.getArgumentValue("WS_CMT_CONF_DIR");
        return new File(sConfigRepositoryPath + File.separator + sRegistryType);
    }

    private static List<Parameter> getParameterListFromANode(NodeList nodeList) {
        Vector<Parameter> listParameters = new Vector<Parameter>();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            Node nodeArgumentChildNode = nodeList.item(j);
            if (!nodeArgumentChildNode.getNodeName().equals("param")) continue;
            NamedNodeMap namedNodeMapOfAttributes = nodeArgumentChildNode.getAttributes();
            String sKey = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_KEY, namedNodeMapOfAttributes);
            String sValue = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes("value", namedNodeMapOfAttributes);
            String sPlatform = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_PLATFORM, namedNodeMapOfAttributes);
            if (sPlatform != null && !PlatformConstants.getCurrentPlatformName().equalsIgnoreCase(sPlatform)) continue;
            listParameters.add(new Parameter(sKey, sValue));
        }
        return listParameters;
    }
}

