/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashtableUtils {
    private static final String S_EQUALS = "=";
    private static final String S_EOLN = "\n";
    private static final Logger LOGGER = LoggerFactory.createLogger(HashtableUtils.class);
    private static final String S_CLASS_NAME = HashtableUtils.class.getName();
    protected static final String S_EMPTY = "";

    public static boolean getHashtableValueAsBoolean(Object oKey, Hashtable hashtable) {
        LOGGER.entering(HashtableUtils.class.getName(), "getHashtableValueAsBoolean");
        Object oVal = hashtable.get(oKey);
        if (oVal == null) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getHashtableValueAsBoolean", "Given key " + oKey.toString() + " was not found in the given hashtable, returning false");
            return false;
        }
        String sVal = oVal.toString();
        LOGGER.exiting(HashtableUtils.class.getName(), "getHashtableValueAsBoolean");
        return Boolean.valueOf(sVal);
    }

    public static String getHashtableValueAsString(Object oKey, Hashtable hashtable) {
        LOGGER.entering(HashtableUtils.class.getName(), "getHashtableValueAsString");
        Object oVal = hashtable.get(oKey);
        if (oVal == null) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getHashtableValueAsString", "Given key " + oKey.toString() + " was not found in the given hashtable, returning an empty string");
            LOGGER.exiting(HashtableUtils.class.getName(), "getHashtableValueAsString");
            return S_EMPTY;
        }
        String sVal = oVal.toString();
        LOGGER.exiting(HashtableUtils.class.getName(), "getHashtableValueAsString");
        return sVal;
    }

    public static void renameKey(Object oKeyOriginal, Object oKeyNew, Hashtable<Object, Object> hashtable) {
        LOGGER.entering(HashtableUtils.class.getName(), "renameKey");
        Object oVal = hashtable.get(oKeyOriginal);
        hashtable.remove(oKeyOriginal);
        hashtable.put(oKeyNew, oVal);
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "renameKey", "Renamed this key " + oKeyOriginal.toString() + " to this " + oKeyNew.toString());
        LOGGER.exiting(HashtableUtils.class.getName(), "renameKey");
    }

    public static String convertHashtableToPropertiesString(Hashtable hashtable) {
        LOGGER.entering(HashtableUtils.class.getName(), "convertHashtableToPropertiesString");
        String sReturn = S_EMPTY;
        if (hashtable != null) {
            Enumeration enumerationKeys = hashtable.keys();
            while (enumerationKeys.hasMoreElements()) {
                Object oKey = enumerationKeys.nextElement();
                sReturn = sReturn + oKey.toString() + S_EQUALS + hashtable.get(oKey).toString() + S_EOLN;
            }
        }
        LOGGER.exiting(HashtableUtils.class.getName(), "convertHashtableToPropertiesString");
        return sReturn;
    }
}

