/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.utils;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileUtils {
    private static final String S_DOTS = "..";
    private static final String S_UNDERSCORE = "_";
    private static final String S_FILE_URL = "file://";
    private static final String S_DOT = ".";
    private static final Logger LOGGER = LoggerFactory.createLogger(FileUtils.class);
    private static final String S_CLASS_NAME = FileUtils.class.getName();
    protected static final String S_EMPTY = "";

    public static String getLocaleFilePath(String sGivenFilePath, String sExpectedExtension) {
        LOGGER.entering(FileUtils.class.getName(), "getLocaleFilePath");
        String sLocale = Locale.getDefault().toString();
        String sLocaleFile = sGivenFilePath + S_UNDERSCORE + sLocale + S_DOT + sExpectedExtension;
        if (new File(sLocaleFile).exists()) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getLocaleFilePath", "Locale specific path for " + sGivenFilePath + " is: " + sLocaleFile);
            LOGGER.exiting(FileUtils.class.getName(), "getLocaleFilePath");
            return sLocaleFile;
        }
        sLocale = Locale.getDefault().getLanguage();
        sLocaleFile = sGivenFilePath + S_UNDERSCORE + sLocale + S_DOT + sExpectedExtension;
        if (new File(sLocaleFile).exists()) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getLocaleFilePath", "Locale specific path for " + sGivenFilePath + " is: " + sLocaleFile);
            LOGGER.exiting(FileUtils.class.getName(), "getLocaleFilePath");
            return sLocaleFile;
        }
        sLocaleFile = sGivenFilePath + S_DOT + sExpectedExtension;
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getLocaleFilePath", "Locale specific path for " + sGivenFilePath + " is: " + sLocaleFile);
        LOGGER.exiting(FileUtils.class.getName(), "getLocaleFilePath");
        return sLocaleFile;
    }

    public static URL getFileURLForThisFilePath(String sFilePath) throws MalformedURLException {
        LOGGER.entering(FileUtils.class.getName(), "getFileURLForThisFilePath");
        if (sFilePath.toLowerCase().startsWith(S_FILE_URL)) {
            LOGGER.exiting(FileUtils.class.getName(), "getFileURLForThisFilePath");
            return new URL(sFilePath);
        }
        LOGGER.exiting(FileUtils.class.getName(), "getFileURLForThisFilePath");
        return new File(sFilePath).toURL();
    }

    public static String[] getAllFilesInThisDirectory(String sDirectoryPath) {
        LOGGER.entering(FileUtils.class.getName(), "getAllFilesInThisDirectory");
        if (sDirectoryPath == null) {
            return new String[0];
        }
        File fileThisDirectory = new File(sDirectoryPath);
        if (!fileThisDirectory.isDirectory()) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getAllFilesInThisDirectory", sDirectoryPath + " is not a directory, returning an empty list");
            LOGGER.exiting(FileUtils.class.getName(), "getAllFilesInThisDirectory");
            return new String[0];
        }
        Object[] asFileList = fileThisDirectory.list();
        if (asFileList == null || asFileList.length == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getAllFilesInThisDirectory", sDirectoryPath + " contains no files.");
            LOGGER.exiting(FileUtils.class.getName(), "getAllFilesInThisDirectory");
            return asFileList;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getAllFilesInThisDirectory", sDirectoryPath + " contains these files: " + LogUtils.getArrayAsALoggableString(asFileList));
        LOGGER.exiting(FileUtils.class.getName(), "getAllFilesInThisDirectory");
        return asFileList;
    }

    public static String[] getAllFilesInThisDirectoryMatchingThisPatternIgnoreCase(String sDirectoryPath, String sPattern) {
        LOGGER.entering(FileUtils.class.getName(), "getAllFilesInThisDirectoryMatchingThisPatternIgnoreCase");
        String[] asAllFiles = FileUtils.getAllFilesInThisDirectory(sDirectoryPath);
        Vector<String> vsFiltered = new Vector<String>();
        for (int i = 0; i < asAllFiles.length; ++i) {
            if (!asAllFiles[i].toLowerCase().matches(sPattern.toLowerCase())) continue;
            vsFiltered.add(asAllFiles[i]);
        }
        Object[] asFilteredFiles = new String[vsFiltered.size()];
        for (int i = 0; i < vsFiltered.size(); ++i) {
            asFilteredFiles[i] = (String)vsFiltered.elementAt(i);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getAllFilesInThisDirectoryMatchingThisPatternIgnoreCase", "List of files in " + sDirectoryPath + " matching the pattern " + sPattern + " is: " + LogUtils.getArrayAsALoggableString(asFilteredFiles));
        LOGGER.exiting(FileUtils.class.getName(), "getAllFilesInThisDirectoryMatchingThisPatternIgnoreCase");
        return asFilteredFiles;
    }

    public static String readFile(String sFilePath) throws IOException, FileNotFoundException {
        LOGGER.entering(FileUtils.class.getName(), "readFile");
        byte[] abTotal = null;
        FileInputStream fileinputstreamThis = new FileInputStream(sFilePath);
        String sFileContents = S_EMPTY;
        try {
            abTotal = new byte[fileinputstreamThis.available()];
            fileinputstreamThis.read(abTotal);
            sFileContents = new String(abTotal);
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "readFile", "Contents read from " + sFilePath + " follow\n" + sFileContents);
        }
        catch (IOException ioEx) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "readFile", "Error reading from file: " + sFilePath);
            throw ioEx;
        }
        finally {
            fileinputstreamThis.close();
            LOGGER.exiting(FileUtils.class.getName(), "readFile");
        }
        return sFileContents;
    }

    public static String makeSureDirectoryEndsWithASlash(String sDirectory) {
        LOGGER.entering(FileUtils.class.getName(), "makeSureDirectoryEndsWithASlash");
        String sDirectoryCopy = sDirectory;
        if (!sDirectoryCopy.substring(sDirectoryCopy.length() - 1).equals(PlatformConstants.getFileSystemPathSeparator())) {
            sDirectoryCopy = sDirectoryCopy + PlatformConstants.getFileSystemPathSeparator();
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "makeSureDirectoryEndsWithASlash", "Incoming path was: " + sDirectory + ", outgoing is: " + sDirectoryCopy);
        LOGGER.exiting(FileUtils.class.getName(), "makeSureDirectoryEndsWithASlash");
        return sDirectoryCopy;
    }

    public static String getNormalizedPath(String sPath) {
        if (sPath == null) {
            return null;
        }
        return FileUtils.getNormalizedPath(new File(sPath)).getPath();
    }

    public static File getNormalizedPath(File file) {
        if (file == null) {
            return null;
        }
        String sPath = file.getAbsolutePath();
        boolean fIsTrailingFileSep = sPath.endsWith(File.separator);
        boolean fIsStartingFileSep = sPath.startsWith(File.separator);
        StringTokenizer st = new StringTokenizer(sPath, File.separator);
        Vector<String> listPathNames = new Vector<String>();
        while (st.hasMoreTokens()) {
            String sToken = st.nextToken();
            if (S_DOT.equals(sToken)) continue;
            if (listPathNames.size() > 1 && PlatformConstants.isCurrentPlatformWindows() && S_DOTS.equals(sToken)) {
                listPathNames.remove(listPathNames.size() - 1);
                continue;
            }
            if (listPathNames.size() > 0 && !PlatformConstants.isCurrentPlatformWindows() && S_DOTS.equals(sToken)) {
                listPathNames.remove(listPathNames.size() - 1);
                continue;
            }
            if (S_DOTS.equals(sToken)) continue;
            listPathNames.add(sToken);
        }
        StringBuffer sb = new StringBuffer();
        if (fIsStartingFileSep) {
            sb.append(File.separator);
        }
        Iterator i = listPathNames.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(File.separator);
        }
        if (fIsTrailingFileSep) {
            sb.append(File.separator);
        } else if (PlatformConstants.isCurrentPlatformWindows() && listPathNames.size() == 1) {
            sb.append(File.separator);
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "getNormalizedPath", "The path " + sPath + " was sucessfully normalized to " + sb.toString());
        return new File(sb.toString());
    }
}

