/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.utils;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassPathModifier {
    private static final String S_JAR_FILE_PATTERN = "^.*\\.jar$";
    private static final String S_ERROR_ADDING_TO_CLASSPATH = "Error adding the given URL to the classpath";
    private static final String S_ADD_URL_METHOD_NAME = "addURL";
    private static final Logger LOGGER = LoggerFactory.createLogger(ClassPathModifier.class);
    private static final String S_CLASS_NAME = ClassPathModifier.class.getName();

    public static void addAllJARsInDirectoryToClassPath(String sDir) throws IOException {
        LOGGER.entering(ClassPathModifier.class.getName(), "addAllJARsInDirectoryToClassPath");
        Object[] asJARFiles = FileUtils.getAllFilesInThisDirectoryMatchingThisPatternIgnoreCase(sDir, S_JAR_FILE_PATTERN);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "addAllJARsInDirectoryToClassPath", "ListJAR files in found in " + sDir + " is: " + LogUtils.getArrayAsALoggableString(asJARFiles));
        for (int i = 0; i < asJARFiles.length; ++i) {
            String sThisJARFilePath = new File(sDir, (String)asJARFiles[i]).getAbsolutePath();
            ClassPathModifier.addFileToClassPath(sThisJARFilePath);
        }
        LOGGER.exiting(ClassPathModifier.class.getName(), "addAllJARsInDirectoryToClassPath");
    }

    public static void addFileToClassPath(String sFilePath) throws IOException {
        LOGGER.entering(ClassPathModifier.class.getName(), "addFileToClassPath");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "addFileToClassPath", "Adding this file to the system JVM classpath: " + sFilePath);
        ClassPathModifier.addURLToClassPath(new File(sFilePath).toURI().toURL());
        LOGGER.exiting(ClassPathModifier.class.getName(), "addFileToClassPath");
    }

    public static void addURLToClassPath(URL urlToAddToClassPath) throws IOException {
        LOGGER.entering(ClassPathModifier.class.getName(), "addURLToClassPath");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "addURLToClassPath", "Adding this URL to the system JVM classpath: " + urlToAddToClassPath.toString());
        try {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            if (!(currentClassLoader instanceof URLClassLoader)) {
                URLClassLoader urlLoader = new URLClassLoader(new URL[]{urlToAddToClassPath}, currentClassLoader);
                Thread.currentThread().setContextClassLoader(urlLoader);
                currentClassLoader = urlLoader;
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "addURLToClassPath", "URLClassLoader will be appended to the " + currentClassLoader.getClass().getCanonicalName() + " in the class loader chain.");
            }
            URLClassLoader urlclassloaderSystemClassLoader = (URLClassLoader)currentClassLoader;
            Class<URLClassLoader> classSystemClassLoader = URLClassLoader.class;
            Method method = classSystemClassLoader.getDeclaredMethod(S_ADD_URL_METHOD_NAME, URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlclassloaderSystemClassLoader, urlToAddToClassPath);
        }
        catch (Throwable t) {
            LogUtils.logException(LOGGER, t);
            LOGGER.throwing(ClassPathModifier.class.getName(), "addURLToClassPath", new IOException(S_ERROR_ADDING_TO_CLASSPATH));
            throw new IOException(S_ERROR_ADDING_TO_CLASSPATH);
        }
        LOGGER.exiting(ClassPathModifier.class.getName(), "addURLToClassPath");
    }
}

