/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.tests;

import com.ibm.ws.install.configmanager.actionengine.Parameter;
import com.ibm.ws.install.configmanager.utils.ParameterPassingUtils;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestParameterPassing
extends TestCase {
    private static final String S_PARAMETER_PREFIX = "parameter.";
    private static final String S_KEY = "key";

    public TestParameterPassing(String sTestName) {
        super(sTestName);
    }

    public void testParameterPassingUtilsRetrieveParameter() {
        int index = 3;
        String[] saValues = new String[]{"0", "1", "2", "3", "4", "profileName", "nodeName", "7", "8", "9"};
        String[] saKeys = this.setSystemPropertiesWithTestData(saValues);
        String sParam = ParameterPassingUtils.retrieveParameter(saKeys[index]);
        Assert.assertEquals((String)saValues[index], (String)sParam);
    }

    public void testParameterPassingUtilsRetrieveParametersAsAMap() {
        boolean bRemovePrefix = true;
        String[] saValues = new String[]{"0", "1", "2", "3", "4", "profileName", "nodeName", "7", "8", "9"};
        String[] saKeys = this.setSystemPropertiesWithTestData(saValues);
        Map<String, String> mParams = ParameterPassingUtils.retrieveParametersAsAMap(bRemovePrefix);
        for (int i = 0; i < saValues.length; ++i) {
            if (bRemovePrefix) {
                Assert.assertEquals((String)saValues[i], (String)mParams.get(saKeys[i]));
                continue;
            }
            Assert.assertEquals((String)saValues[i], (String)mParams.get(S_PARAMETER_PREFIX + saKeys[i]));
        }
    }

    public void testParameterPassingUtilsRetrieveParametersAsProperties() {
        boolean bRemovePrefix = false;
        String[] saValues = new String[]{"0", "1", "2", "3", "4", "profileName", "nodeName", "7", "8", "9"};
        String[] saKeys = this.setSystemPropertiesWithTestData(saValues);
        Properties propParams = ParameterPassingUtils.retrieveParametersAsProperties(bRemovePrefix);
        for (int i = 0; i < saValues.length; ++i) {
            if (bRemovePrefix) {
                Assert.assertEquals((Object)saValues[i], (Object)propParams.get(saKeys[i]));
                continue;
            }
            Assert.assertEquals((Object)saValues[i], (Object)propParams.get(S_PARAMETER_PREFIX + saKeys[i]));
        }
    }

    private String[] setSystemPropertiesWithTestData(String[] saValues) {
        String[] saKeys = new String[saValues.length];
        Vector<Parameter> listParams = new Vector<Parameter>();
        for (int i = 0; i < saValues.length; ++i) {
            saKeys[i] = S_KEY + Integer.toString(i);
            listParams.add(new Parameter(saKeys[i], saValues[i]));
        }
        ParameterPassingUtils.setParametersIntoSystemProperties(listParams);
        return saKeys;
    }
}

