/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.logging;

import java.io.File;
import java.io.IOException;

public class LoggerFactoryConstants {
    public static final String S_DEFAULT_LOG_FILE_PATH = "cmtbootstraplog.txt";
    public static final int N_DEFAULT_LOG_LEVEL = 3;
    public static final String S_ARG_LOG_LEVEL = "WS_CMT_LOGLEVEL";
    public static final String S_ARG_LOG_HOME = "WS_CMT_LOG_HOME";
    public static final String S_ARG_LOG_FILE_NAME = "WS_CMT_LOG_NAME";
    public static final String S_ARG_APPEND_LOGS = "WS_CMT_APPEND_LOGS";
    private static final String S_TEMP_LOG_PREFIX = "~._cmt";
    private static final String S_JAVA_TEMP = "java.io.tmpdir";
    private static final String S_EMPTY = "";
    private static final String S_LOG_FILE_NAME = "cmtlog.txt";

    public static int getDesiredLogLevel() {
        String sLogArg = System.getProperty(S_ARG_LOG_LEVEL);
        if (sLogArg == null) {
            return 3;
        }
        try {
            return Integer.parseInt(sLogArg);
        }
        catch (NumberFormatException e) {
            return 3;
        }
    }

    public static String getGlobalLogDirectory() {
        String sLogHomeDir = System.getProperty(S_ARG_LOG_HOME);
        if (sLogHomeDir == null) {
            sLogHomeDir = System.getProperty(S_JAVA_TEMP);
        }
        return new File(sLogHomeDir).getAbsolutePath();
    }

    public static String getGlobalLogFilePath() {
        String sLogFileName = S_LOG_FILE_NAME;
        if (LoggerFactoryConstants.isEmptyFileHandlerCase()) {
            return S_EMPTY;
        }
        if (System.getProperty(S_ARG_LOG_FILE_NAME) != null) {
            sLogFileName = System.getProperty(S_ARG_LOG_FILE_NAME);
        } else {
            try {
                File tmpFile = File.createTempFile(S_TEMP_LOG_PREFIX, null);
                if (tmpFile != null) {
                    sLogFileName = tmpFile.getName();
                    tmpFile.delete();
                }
            }
            catch (IOException ioe) {
                sLogFileName = S_LOG_FILE_NAME;
            }
        }
        String sLogFilePath = new File(LoggerFactoryConstants.getGlobalLogDirectory(), sLogFileName).getAbsolutePath();
        return sLogFilePath;
    }

    public static boolean getDesiredAppendSetting() {
        String sAppendLogsArg = System.getProperty(S_ARG_APPEND_LOGS);
        return sAppendLogsArg != null && sAppendLogsArg.equals(String.valueOf(true));
    }

    public static boolean isEmptyFileHandlerCase() {
        return System.getProperty(S_ARG_LOG_HOME) == null && System.getProperty(S_ARG_LOG_FILE_NAME) == null;
    }
}

