/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogUtils {
    private static final String S_EXCEPTION_MESSAGE_TYPE = "Exception was thrown, type of exception is: ";
    private static final String S_EXCEPTION_MESSAGE_ENGLISH = "The exception message is: ";
    private static final String S_EXCEPTION_MESSAGE_TRANSLATED = "The translated exception message is: ";
    private static final String S_EXCEPTION_MESSAGE_STACK_TRACE = "The stack trace follows";
    private static final String S_BRACKET_OPEN = "{";
    private static final String S_BRACKET_CLOSE = "}";
    private static final String S_SPACE = " ";
    private static final String S_QUOTE = "\"";
    private static final String S_COMMA = ",";
    private static final String S_CLASS_NAME = LogUtils.class.getName();

    public static synchronized void logException(Logger logger, Throwable e) {
        LogUtils.logException(logger, e, Level.WARNING);
    }

    public static synchronized void logException(Logger logger, Throwable e, Level level) {
        logger.logp(level, S_CLASS_NAME, "logException", S_EXCEPTION_MESSAGE_TYPE + e.getClass());
        logger.logp(level, S_CLASS_NAME, "logException", S_EXCEPTION_MESSAGE_ENGLISH + e.getMessage());
        logger.logp(level, S_CLASS_NAME, "logException", S_EXCEPTION_MESSAGE_TRANSLATED + e.getLocalizedMessage());
        logger.logp(level, S_CLASS_NAME, "logException", S_EXCEPTION_MESSAGE_STACK_TRACE);
        logger.logp(level, S_CLASS_NAME, "logException", LogUtils.getExceptionStackTraceAsString(e));
    }

    public static synchronized String getArrayAsALoggableString(Object[] aoIn) {
        String sReturn = "{ ";
        if (aoIn == null) {
            sReturn = sReturn + S_BRACKET_CLOSE;
            return sReturn;
        }
        for (int i = 0; i < aoIn.length; ++i) {
            sReturn = i != aoIn.length - 1 ? sReturn + S_QUOTE + aoIn[i].toString() + S_QUOTE + S_SPACE + S_COMMA : sReturn + S_QUOTE + aoIn[i].toString() + S_QUOTE;
        }
        sReturn = sReturn + S_SPACE + S_BRACKET_CLOSE;
        return sReturn;
    }

    private static String getExceptionStackTraceAsString(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

