/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.launcher;

import com.ibm.ws.install.configmanager.ConfigManager;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.ArrayUtils;
import com.ibm.ws.install.configmanager.utils.HashtableUtils;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Launcher {
    private static Hashtable<String, String> m_hashtableArguments = new Hashtable();
    private static final String S_DASH = "-";
    private static final Logger LOGGER = LoggerFactory.reinitAndCreateLogger(Launcher.class);
    private static final String S_CLASS_NAME = Launcher.class.getName();

    public static void main(String[] asArgs) {
        LOGGER.entering(Launcher.class.getName(), "main");
        Launcher.fillInCommandLineArguments(asArgs);
        LOGGER.exiting(Launcher.class.getName(), "main");
        System.exit(ConfigManager.launch());
    }

    public static int mainForInProcessCMTCallers() {
        LOGGER.entering(Launcher.class.getName(), "main");
        int exitCode = ConfigManager.launch();
        LOGGER.exiting(Launcher.class.getName(), "main");
        return exitCode;
    }

    public static int mainForInProcessCMTCallers(String[] asArgs) {
        LOGGER.entering(Launcher.class.getName(), "main");
        Launcher.fillInCommandLineArguments(asArgs);
        LOGGER.exiting(Launcher.class.getName(), "main");
        return ConfigManager.launch();
    }

    public static String getArgumentValue(String sArgumentKey) {
        LOGGER.entering(Launcher.class.getName(), "getArgumentValue");
        String oValue = m_hashtableArguments.get(sArgumentKey);
        if (oValue != null) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "getArgumentValue", sArgumentKey + " resolved to: " + oValue.toString() + " from incoming command line");
            LOGGER.exiting(Launcher.class.getName(), "getArgumentValue");
            return oValue.toString();
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "getArgumentValue", sArgumentKey + " could not be resolved from the incoming command line");
        LOGGER.exiting(Launcher.class.getName(), "getArgumentValue");
        return null;
    }

    private static void fillInCommandLineArguments(String[] asArgs) {
        LOGGER.entering(Launcher.class.getName(), "fillInCommandLineArguments");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "fillInCommandLineArguments", "Incoming arguments are: " + ArrayUtils.join(", ", asArgs));
        int i = 0;
        while (i < asArgs.length) {
            if (asArgs[i].startsWith(S_DASH) && i + 1 < asArgs.length) {
                String sArgName = asArgs[i].substring(S_DASH.length());
                String sArgValue = asArgs[i + 1];
                LOGGER.logp(Level.FINE, S_CLASS_NAME, "fillInCommandLineArguments", sArgName + " was found in the incoming command line, its value was: " + sArgValue);
                m_hashtableArguments.put(sArgName, sArgValue);
                i += 2;
                continue;
            }
            ++i;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "fillInCommandLineArguments", "Parsed hashtable of arguments is: " + HashtableUtils.convertHashtableToPropertiesString(m_hashtableArguments));
        LOGGER.exiting(Launcher.class.getName(), "fillInCommandLineArguments");
    }
}

