/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.launcher;

import com.ibm.ws.install.configmanager.launcher.Launcher;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArgumentValueFetcher {
    private static final String S_EMPTY = "";
    private static final Logger LOGGER = LoggerFactory.createLogger(ArgumentValueFetcher.class);
    private static final String S_CLASS_NAME = ArgumentValueFetcher.class.getName();

    public static String getArgumentValue(String sPropertyName) {
        LOGGER.entering(ArgumentValueFetcher.class.getName(), "getArgumentValue");
        LOGGER.exiting(ArgumentValueFetcher.class.getName(), "getArgumentValue");
        return ArgumentValueFetcher.getArgumentValue(sPropertyName, true);
    }

    public static String getArgumentValue(String sPropertyName, boolean fIsValueLogged) {
        LOGGER.entering(ArgumentValueFetcher.class.getName(), "getArgumentValue");
        String sArgumentValue = Launcher.getArgumentValue(sPropertyName);
        if (!ArgumentValueFetcher.isEmptyOrNullString(sArgumentValue)) {
            if (fIsValueLogged) {
                LOGGER.logp(Level.FINE, S_CLASS_NAME, "getArgumentValue", "Argument: " + sPropertyName + ", Value: " + sArgumentValue + ", found from incoming command line");
            }
            LOGGER.exiting(ArgumentValueFetcher.class.getName(), "getArgumentValue");
            return sArgumentValue;
        }
        sArgumentValue = System.getProperty(sPropertyName);
        if (!ArgumentValueFetcher.isEmptyOrNullString(sArgumentValue)) {
            if (fIsValueLogged) {
                LOGGER.logp(Level.FINE, S_CLASS_NAME, "getArgumentValue", "Argument: " + sPropertyName + ", Value: " + sArgumentValue + ", found from JDK system properties");
            }
            LOGGER.exiting(ArgumentValueFetcher.class.getName(), "getArgumentValue");
            return sArgumentValue;
        }
        sArgumentValue = PlatformConstants.getEnvironmentVariableValue(sPropertyName);
        if (!ArgumentValueFetcher.isEmptyOrNullString(sArgumentValue)) {
            if (fIsValueLogged) {
                LOGGER.logp(Level.FINE, S_CLASS_NAME, "getArgumentValue", "Argument: " + sPropertyName + ", Value: " + sArgumentValue + ", found from system environment");
            }
            LOGGER.exiting(ArgumentValueFetcher.class.getName(), "getArgumentValue");
            return sArgumentValue;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getArgumentValue", "Could not resolve this argument: " + sPropertyName + ", returning null");
        LOGGER.exiting(ArgumentValueFetcher.class.getName(), "getArgumentValue");
        return null;
    }

    public static String[] getArgumentValues(String sPropertyBaseName) {
        LOGGER.entering(ArgumentValueFetcher.class.getName(), "getArgumentValues");
        ArrayList<String> arraylistPropertyValues = new ArrayList<String>();
        if (ArgumentValueFetcher.isArgumentAvailable(sPropertyBaseName)) {
            arraylistPropertyValues.add(ArgumentValueFetcher.getArgumentValue(sPropertyBaseName, false));
            LOGGER.exiting(ArgumentValueFetcher.class.getName(), "getArgumentValues");
            return arraylistPropertyValues.toArray(new String[0]);
        }
        int i = 1;
        while (ArgumentValueFetcher.isArgumentAvailable(sPropertyBaseName + i)) {
            arraylistPropertyValues.add(ArgumentValueFetcher.getArgumentValue(sPropertyBaseName + i, false));
            ++i;
        }
        LOGGER.exiting(ArgumentValueFetcher.class.getName(), "getArgumentValues");
        return arraylistPropertyValues.toArray(new String[0]);
    }

    public static boolean isArgumentAvailable(String sArgumentName) {
        LOGGER.entering(ArgumentValueFetcher.class.getName(), "isArgumentAvailable");
        String sArgumentValue = ArgumentValueFetcher.getArgumentValue(sArgumentName, false);
        if (sArgumentValue != null) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "isArgumentAvailable", sArgumentName + " could be resolved");
            LOGGER.exiting(ArgumentValueFetcher.class.getName(), "isArgumentAvailable");
            return true;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "isArgumentAvailable", sArgumentName + " could not be resolved");
        LOGGER.exiting(ArgumentValueFetcher.class.getName(), "isArgumentAvailable");
        return false;
    }

    private static boolean isEmptyOrNullString(String sTest) {
        LOGGER.entering(ArgumentValueFetcher.class.getName(), "isEmptyOrNullString");
        if (sTest == null) {
            LOGGER.exiting(ArgumentValueFetcher.class.getName(), "isEmptyOrNullString");
            return true;
        }
        if (sTest.trim().equals(S_EMPTY)) {
            LOGGER.exiting(ArgumentValueFetcher.class.getName(), "isEmptyOrNullString");
            return true;
        }
        LOGGER.exiting(ArgumentValueFetcher.class.getName(), "isEmptyOrNullString");
        return false;
    }
}

