/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine.ant.utils;

import com.ibm.ws.install.configmanager.ConfigManager;
import com.ibm.ws.install.configmanager.launcher.ArgumentValueFetcher;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class CheckForOmittedApps
extends Task {
    private String appToCheck;
    private String appToCheck_alias = "";
    private boolean isAppOmitted = false;
    private String sAppOmitted = null;
    private String property = null;
    private boolean defaultAppOmitted = false;
    private boolean sampleAppOmitted = false;
    private boolean adminAppOmitted = false;
    private String m_sErrorMessage = "";
    private final String DEFAULTAPP = "defaultAppDeployAndConfig";
    private final String DEFAULTAPPALIAS = "deployDefaultApp";
    private final String SAMPLEAPPALIAS = "installSamples";
    private final String SAMPLEAPP = "samplesInstallAndConfig";
    private final String ADMINAPP = "deployAdminConsole";
    private final String ADMINAPPALIAS = "deployAdminConsole";
    private final String ALL_APPLICATIONS = "All";
    private String[] m_asAppsOmitted = null;
    private static final String S_EMPTY = "";
    private static final String S_INVALID_APPLICATION_TO_CHECK = "An Invalid Application Name was specified.";
    private static final String S_INVALID_PROPERTY = "An invalid property was specified.";
    private static final Logger LOGGER = LoggerFactory.createLogger(CheckForOmittedApps.class);
    private static final String S_CLASS_NAME = CheckForOmittedApps.class.getName();

    public void init() throws BuildException {
        super.init();
        this.m_asAppsOmitted = this.createOmittedActions();
    }

    public void execute() throws BuildException {
        super.execute();
        LOGGER.entering(CheckForOmittedApps.class.getName(), "execute");
        if (!this.doAllParamsCheckOutOk()) {
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        Project project = this.getProject();
        this.appToCheck_alias = this.appToCheck.equals("All") ? S_EMPTY : this.assignAlias(this.appToCheck);
        this.isAppOmitted = false;
        String action = null;
        List listOptionalActions = this.getOptionalConfigActionsList();
        if (this.appToCheck.equals("All")) {
            for (int i = 0; i < this.m_asAppsOmitted.length; ++i) {
                action = this.m_asAppsOmitted[i];
                if (action.equals("defaultAppDeployAndConfig") || action.equals("deployDefaultApp")) {
                    this.defaultAppOmitted = true;
                }
                if (action.equals("samplesInstallAndConfig") || action.equals("installSamples")) {
                    this.sampleAppOmitted = true;
                }
                if (!action.equals("deployAdminConsole") && !action.equals("deployAdminConsole")) continue;
                this.adminAppOmitted = true;
            }
            if (this.defaultAppOmitted && this.sampleAppOmitted && this.adminAppOmitted) {
                this.isAppOmitted = true;
            }
        } else {
            for (String app : this.m_asAppsOmitted) {
                if (app.equals(this.appToCheck)) {
                    this.isAppOmitted = true;
                    continue;
                }
                if (!app.equals(this.appToCheck_alias)) continue;
                this.isAppOmitted = true;
            }
        }
        this.sAppOmitted = this.isAppOmitted ? "true" : "false";
        project.setProperty(this.property, this.sAppOmitted);
        LOGGER.exiting(CheckForOmittedApps.class.getName(), "execute");
    }

    private boolean doAllParamsCheckOutOk() {
        if (this.appToCheck == null) {
            this.m_sErrorMessage = S_INVALID_APPLICATION_TO_CHECK;
            return false;
        }
        if (this.appToCheck.equals(S_EMPTY)) {
            this.m_sErrorMessage = S_INVALID_APPLICATION_TO_CHECK;
            return false;
        }
        if (this.property == null) {
            this.m_sErrorMessage = S_INVALID_PROPERTY;
            return false;
        }
        if (this.property.equals(S_EMPTY)) {
            this.m_sErrorMessage = S_INVALID_PROPERTY;
            return false;
        }
        return true;
    }

    private String[] createOmittedActions() {
        LOGGER.entering(CheckForOmittedApps.class.getName(), "createOmittedActions");
        LOGGER.exiting(CheckForOmittedApps.class.getName(), "createOmittedActions");
        return ArgumentValueFetcher.getArgumentValues("omitAction");
    }

    private String assignAlias(String appInput) {
        String alias = S_EMPTY;
        if (appInput.equals("defaultAppDeployAndConfig")) {
            alias = "deployDefaultApp";
        }
        if (appInput.equals("deployAdminConsole")) {
            alias = "deployAdminConsole";
        }
        if (appInput.equals("samplesInstallAndConfig")) {
            alias = "installSamples";
        }
        return alias;
    }

    private List getOptionalConfigActionsList() {
        Vector listOptionalActions;
        String s_configDir = System.getProperty("WS_CMT_CONF_DIR");
        String s_actionRegistry = System.getProperty("WS_CMT_ACTION_REGISTRY");
        if (s_configDir != null && s_actionRegistry != null) {
            listOptionalActions = ConfigManager.getOptionalConfigActionsList(s_configDir, s_actionRegistry);
        } else {
            System.out.println("Could not determine optional config actions");
            listOptionalActions = new Vector();
        }
        return listOptionalActions;
    }

    public void setAppToCheck(String application) {
        this.appToCheck = application;
    }

    public boolean getIsAppOmitted() {
        return this.isAppOmitted;
    }

    public void setIsAppOmitted(boolean isAppOmitted) {
        this.isAppOmitted = isAppOmitted;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getProperty() {
        return this.property;
    }
}

