/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine;

import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.actionengine.ActionImpl;
import com.ibm.ws.install.configmanager.actionengine.JACLAction;
import com.ibm.ws.install.configmanager.execengine.ExecEngine;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.install.configmanager.utils.ArrayUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlatformNativeShellScriptAction
extends ActionImpl {
    private String m_sOutput = "";
    private String m_sErrorOutput = "";
    private static final Logger LOGGER = LoggerFactory.createLogger(PlatformNativeShellScriptAction.class);
    private static final String S_CLASS_NAME = PlatformNativeShellScriptAction.class.getName();

    public PlatformNativeShellScriptAction(String sActionPath, boolean fFatal) {
        super(sActionPath, fFatal);
    }

    public boolean executeAction() {
        LOGGER.entering(PlatformNativeShellScriptAction.class.getName(), "executeAction");
        ExecEngine execEngine = new ExecEngine();
        int nRetCode = execEngine.executeIncomingArguments(this.getExecStringArrayToExecuteThisActionUsingPlatformShell(), ConfigManagerConstants.getProcessTimeOutTime());
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "executeAction", this.getActionPath() + " returned " + nRetCode + ", 0 is expected on success");
        this.m_sOutput = execEngine.getProcessStdOut();
        this.m_sErrorOutput = execEngine.getProcessStdErr();
        boolean fResult = false;
        if (nRetCode == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeAction", this.getActionPath() + " executed successfully");
            fResult = true;
        } else {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeAction", this.getActionPath() + " failed to execute");
            fResult = false;
        }
        LOGGER.exiting(PlatformNativeShellScriptAction.class.getName(), "executeAction");
        return fResult;
    }

    public boolean rollBackAction() {
        LOGGER.entering(PlatformNativeShellScriptAction.class.getName(), "rollBackAction");
        LOGGER.exiting(PlatformNativeShellScriptAction.class.getName(), "rollBackAction");
        return false;
    }

    public String getActionManualCommand() {
        LOGGER.entering(PlatformNativeShellScriptAction.class.getName(), "getActionManualCommand");
        String sManualCmd = PlatformConstants.convertExecArrayToPlatformSpecificExecCommand(this.getExecStringArrayToExecuteThisActionUsingPlatformShell());
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "getActionManualCommand", "The manual command for " + this.getActionPath() + " action is: " + sManualCmd);
        LOGGER.exiting(PlatformNativeShellScriptAction.class.getName(), "getActionManualCommand");
        return sManualCmd;
    }

    private String[] getExecStringArrayToExecuteThisActionUsingPlatformShell() {
        LOGGER.entering(PlatformNativeShellScriptAction.class.getName(), "getExecStringArrayToExecuteThisActionUsingPlatformShell");
        String[] asPrefix = PlatformConstants.getShellExecPrefixForCurrentPlatform();
        Object[] asCmd = new String[asPrefix.length + 1];
        ArrayUtils.appendArray(asCmd, asPrefix, 0);
        asCmd[asPrefix.length] = this.getActionPathAsSafeShellParameter();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getExecStringArrayToExecuteThisActionUsingPlatformShell", "The string array to execute " + this.getActionPath() + " SHELL action is: " + LogUtils.getArrayAsALoggableString(asCmd));
        LOGGER.exiting(PlatformNativeShellScriptAction.class.getName(), "getExecStringArrayToExecuteThisActionUsingPlatformShell");
        return asCmd;
    }

    public String getActionErrorOutput() {
        LOGGER.entering(JACLAction.class.getName(), "getActionErrorOutput");
        LOGGER.exiting(JACLAction.class.getName(), "getActionErrorOutput");
        return this.m_sErrorOutput;
    }

    public String getActionOutput() {
        LOGGER.entering(JACLAction.class.getName(), "getActionOutput");
        LOGGER.exiting(JACLAction.class.getName(), "getActionOutput");
        return this.m_sOutput;
    }
}

