/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine;

import com.ibm.ws.install.configmanager.actionengine.ArgumentConfigAction;
import com.ibm.ws.install.configmanager.actionengine.Environment;
import com.ibm.ws.install.configmanager.actionengine.Parameter;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaulterConfigAction
extends ArgumentConfigAction {
    private static final String S_DEFAULT_VALUE = null;
    private static final String S_DEFAULT_VALUE_KEY = "defaultValue";
    private static final String S_DEFAULTED_VALUE_PATTERN = "(defaultValue=)(.*)";
    private static final Pattern PATTERN_DEFAULTED_VALUE = Pattern.compile("(defaultValue=)(.*)");
    private static final int N_NAME_GROUP_NO_DEFAULT_VALUE = 2;
    private static final Logger LOGGER = LoggerFactory.createLogger(DefaulterConfigAction.class);
    private static final String S_CLASS_NAME = DefaulterConfigAction.class.getName();

    public DefaulterConfigAction(String sActionPath, int nPriority, boolean fFatal, List<Parameter> listParameters, String sResourceBundle, boolean fOptional, String alias, List<Environment> listSupportedEnvironments) {
        super(sActionPath, nPriority, fFatal, listParameters, sResourceBundle, fOptional, alias, listSupportedEnvironments);
    }

    public String executeDefaulter() {
        String sOutput = super.executeArgumentAction();
        return DefaulterConfigAction.parseOutputForDefault(sOutput);
    }

    private static String parseOutputForDefault(String sOutput) {
        LOGGER.entering(S_CLASS_NAME, "parseOutputForDefault");
        if (sOutput == null) {
            LOGGER.exiting(S_CLASS_NAME, "parseOutputForDefault");
            return S_DEFAULT_VALUE;
        }
        Matcher defaultValueMatcher = PATTERN_DEFAULTED_VALUE.matcher(sOutput);
        String sDefaultValue = S_DEFAULT_VALUE;
        if (defaultValueMatcher.find()) {
            sDefaultValue = defaultValueMatcher.group(2);
        }
        LOGGER.exiting(S_CLASS_NAME, "parseOutputForDefault");
        return sDefaultValue;
    }
}

