/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine;

import com.ibm.ws.install.configmanager.actionengine.Action;
import com.ibm.ws.install.configmanager.actionengine.ActionFactory;
import com.ibm.ws.install.configmanager.actionengine.ActionRegistryParser;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.install.configmanager.utils.FileUtils;
import com.ibm.ws.install.configmanager.utils.ResourceBundleUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigAction
implements Comparable,
Action {
    protected int m_nPriority = -1;
    protected boolean m_fActionFatalToConfigStatus = true;
    protected String m_sActionName = null;
    protected String sActionAlias = null;
    protected String m_sActionPath = null;
    protected List m_listArguments = null;
    protected boolean m_fActionIsOptional = false;
    protected Action m_action = null;
    protected String m_sResourceBundle = null;
    private static final String S_ACTION_NAME_WITH_PRIORITY_PATTERN = "(\\d+)([FSfs])([^\\s]+)(\\.)(\\w+)";
    private static final Pattern PATTERN_ACTION_NAME_WITH_PRIORITY = Pattern.compile("(\\d+)([FSfs])([^\\s]+)(\\.)(\\w+)");
    private static final int N_PRIORITY_GROUP = 1;
    private static final int N_FATAL_GROUP = 2;
    private static final int N_NAME_GROUP = 3;
    private static final String S_ACTION_NAME_PATTERN = "([^\\s]+)(\\.)(\\w+)";
    public static final Pattern PATTERN_ACTION_NAME = Pattern.compile("([^\\s]+)(\\.)(\\w+)");
    private static final int N_NAME_GROUP_NO_PRIORITY_FATALITY_CODE_IN_ACTION_NAME = 1;
    private static final String S_CONFIG_ACTION_DESCRIPTION_PREFIX = "ConfigAction.";
    private static final String S_CONFIG_ACTION_SHORT_DESCRIPTION_SUFFIX = ".shortDescription";
    private static final String S_CONFIG_ACTION_LONG_DESCRIPTION_SUFFIX = ".longDescription";
    protected static final String S_EMPTY = "";
    private static final String S_FATAL_FLAG = "F";
    private static final String S_DASH = "-";
    private static final Logger LOGGER = LoggerFactory.createLogger(ConfigAction.class);
    private static final String S_CLASS_NAME = ConfigAction.class.getName();

    public boolean executeAction() {
        LOGGER.entering(ConfigAction.class.getName(), "executeAction");
        if (this.doIRun()) {
            if (this.m_action == null) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeAction", "The configuartion action " + this.getActionPath() + " was not initialized properly. The execution of this action " + "is unsuccessful.");
                LOGGER.exiting(S_CLASS_NAME, "executeAction");
                return false;
            }
            LOGGER.exiting(S_CLASS_NAME, "executeAction");
            return this.m_action.executeAction();
        }
        LOGGER.exiting(ConfigAction.class.getName(), "executeAction");
        return true;
    }

    public boolean rollBackAction() {
        LOGGER.entering(ConfigAction.class.getName(), "rollBackAction");
        if (this.doIRun()) {
            LOGGER.exiting(ConfigAction.class.getName(), "rollBackAction");
            return this.m_action.rollBackAction();
        }
        LOGGER.exiting(ConfigAction.class.getName(), "rollBackAction");
        return true;
    }

    public String getActionManualCommand() {
        return this.m_action.getActionManualCommand();
    }

    public String getActionOutput() {
        LOGGER.entering(ConfigAction.class.getName(), "getActionOutput");
        if (this.doIRun()) {
            LOGGER.exiting(ConfigAction.class.getName(), "getActionOutput");
            return this.m_action.getActionOutput();
        }
        LOGGER.exiting(ConfigAction.class.getName(), "getActionOutput");
        return S_EMPTY;
    }

    public String getActionErrorOutput() {
        LOGGER.entering(ConfigAction.class.getName(), "getActionErrorOutput");
        if (this.doIRun()) {
            LOGGER.exiting(ConfigAction.class.getName(), "getActionErrorOutput");
            return this.m_action.getActionErrorOutput();
        }
        LOGGER.exiting(ConfigAction.class.getName(), "getActionErrorOutput");
        return S_EMPTY;
    }

    protected boolean doIRun() {
        return true;
    }

    public int compareTo(Object o) {
        LOGGER.entering(ConfigAction.class.getName(), "compareTo");
        ConfigAction caIncoming = (ConfigAction)o;
        if (this.getThisActionPriority() < caIncoming.getThisActionPriority()) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "compareTo", "Returing less than from compareTo, actions are: " + this.getActionPath() + ", " + caIncoming.getActionPath());
            LOGGER.exiting(ConfigAction.class.getName(), "compareTo");
            return -1;
        }
        if (this.getThisActionPriority() > caIncoming.getThisActionPriority()) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "compareTo", "Returing greater than from compareTo, actions are: " + this.getActionPath() + ", " + caIncoming.getActionPath());
            LOGGER.exiting(ConfigAction.class.getName(), "compareTo");
            return 1;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "compareTo", "Returing equal from compareTo, actions are: " + this.getActionPath() + ", " + caIncoming.getActionPath());
        LOGGER.exiting(ConfigAction.class.getName(), "compareTo");
        return 0;
    }

    public static List createActionsSorted(String sRepositoryPath) {
        List listActions = null;
        listActions = ActionRegistryParser.isAnActionRegistryAvailable() ? ActionRegistryParser.getSortedActionListFromRegistryFile() : ConfigAction.getSortedActionListNoRegistryFile(sRepositoryPath);
        return listActions;
    }

    public static ConfigAction createAction(String sActionPath) {
        LOGGER.entering(ConfigAction.class.getName(), "createAction");
        String sActionFileName = new File(sActionPath).getName();
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "createAction", "Incoming action path was: " + sActionPath + ", the file name is: " + sActionFileName);
        if (!ConfigAction.isValidActionFileNameWithPriority(sActionFileName)) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "createAction", sActionPath + " could not be parsed as valid config action file name, returning an empty action for it");
            LOGGER.exiting(ConfigAction.class.getName(), "createAction");
            ConfigAction configAction = new ConfigAction();
            ConfigAction.setEmtpyActionNoPriorityNotFatal(configAction, sActionPath);
            return configAction;
        }
        ConfigAction caThis = new ConfigAction();
        ConfigAction.initializeActionProperties(caThis, sActionPath);
        LOGGER.exiting(ConfigAction.class.getName(), "createAction");
        return caThis;
    }

    private ConfigAction() {
    }

    public static ConfigAction createAction(String sActionPath, int nPriority, boolean fFatal, List listArguments, String sResourceBundle, boolean fOptional, String alias) {
        LOGGER.entering(ConfigAction.class.getName(), "createAction");
        ConfigAction configAction = new ConfigAction(sActionPath, nPriority, fFatal, listArguments, sResourceBundle, fOptional, alias);
        LOGGER.exiting(ConfigAction.class.getName(), "createAction");
        return configAction;
    }

    public static ConfigAction createAction(String sActionPath, int nPriority, boolean fFatal, List listArguments, String sResourceBundle, boolean fOptional) {
        return ConfigAction.createAction(sActionPath, nPriority, fFatal, listArguments, sResourceBundle, fOptional, S_EMPTY);
    }

    protected ConfigAction(String sActionPath, int nPriority, boolean fFatal, List listArguments, String sResourceBundle, boolean fOptional, String alias) {
        LOGGER.entering(ConfigAction.class.getName(), "constructor");
        String sActionFileName = new File(sActionPath).getName();
        if (!ConfigAction.isValidActionFileName(sActionFileName)) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "constructor", sActionPath + " could not be parsed as valid config action file name, returning an empty action for it");
            ConfigAction.setEmtpyActionNoPriorityNotFatal(this, sActionPath);
            LOGGER.exiting(ConfigAction.class.getName(), "constructor");
            return;
        }
        this.m_sActionPath = sActionPath;
        this.m_nPriority = nPriority;
        this.m_fActionFatalToConfigStatus = fFatal;
        this.m_sActionName = ConfigAction.getActionName(sActionFileName);
        this.m_fActionIsOptional = fOptional;
        this.m_listArguments = listArguments;
        this.m_sResourceBundle = sResourceBundle;
        this.setActionAlias(alias);
        this.m_action = ActionFactory.getAction(this.m_sActionPath, this.m_fActionFatalToConfigStatus);
        LOGGER.exiting(ConfigAction.class.getName(), "constructor");
    }

    public static List createRequiredActions(List vcaAllConfigActions) {
        LOGGER.entering(ConfigAction.class.getName(), "createRequiredActions");
        Vector<ConfigAction> vcaRequiredActions = new Vector<ConfigAction>();
        for (ConfigAction ca : vcaAllConfigActions) {
            if (ca.isActionOptional()) continue;
            vcaRequiredActions.add(ca);
        }
        LOGGER.exiting(ConfigAction.class.getName(), "createRequiredActions");
        return vcaRequiredActions;
    }

    public static List createOptionalActions(List vcaAllConfigActions) {
        LOGGER.entering(ConfigAction.class.getName(), "createOptionalActions");
        Vector<ConfigAction> vcaOptionalActions = new Vector<ConfigAction>();
        for (ConfigAction ca : vcaAllConfigActions) {
            if (!ca.isActionOptional()) continue;
            vcaOptionalActions.add(ca);
        }
        LOGGER.exiting(ConfigAction.class.getName(), "createOptionalActions");
        return vcaOptionalActions;
    }

    public int getThisActionPriority() {
        LOGGER.entering(ConfigAction.class.getName(), "getThisActionPriority");
        LOGGER.exiting(ConfigAction.class.getName(), "getThisActionPriority");
        return this.m_nPriority;
    }

    public boolean isActionFailureFatalToConfiguration() {
        LOGGER.entering(ConfigAction.class.getName(), "isActionFailureFatalToConfiguration");
        LOGGER.exiting(ConfigAction.class.getName(), "isActionFailureFatalToConfiguration");
        return this.m_fActionFatalToConfigStatus;
    }

    public boolean isActionOptional() {
        LOGGER.entering(ConfigAction.class.getName(), "isActionOptional");
        LOGGER.exiting(ConfigAction.class.getName(), "isActionOptional");
        return this.m_fActionIsOptional;
    }

    public String getActionPath() {
        LOGGER.entering(ConfigAction.class.getName(), "getActionPath");
        LOGGER.exiting(ConfigAction.class.getName(), "getActionPath");
        return this.m_sActionPath;
    }

    public String getActionName() {
        return this.m_sActionName;
    }

    public String getActionAlias() {
        return this.sActionAlias;
    }

    public void setActionAlias(String actionAlias) {
        this.sActionAlias = actionAlias;
    }

    public String getActionPathAsSafeShellParameter() {
        LOGGER.entering(ConfigAction.class.getName(), "getActionPathAsSafeShellParameter");
        LOGGER.exiting(ConfigAction.class.getName(), "getActionPathAsSafeShellParameter");
        return PlatformConstants.convertToShellParam(this.m_sActionPath);
    }

    public List getActionArgumentList() {
        return this.m_listArguments;
    }

    public String getActionDescriptonBundle() {
        return this.m_sResourceBundle;
    }

    public String getLongDescription() {
        if (this.m_sResourceBundle == null) {
            return S_EMPTY;
        }
        String sKey = S_CONFIG_ACTION_DESCRIPTION_PREFIX + this.getActionName() + S_CONFIG_ACTION_LONG_DESCRIPTION_SUFFIX;
        return ResourceBundleUtils.getResourceBundleLocaleString(sKey, this.m_sResourceBundle);
    }

    public String getShortDescription() {
        if (this.m_sResourceBundle == null) {
            return S_EMPTY;
        }
        String sKey = S_CONFIG_ACTION_DESCRIPTION_PREFIX + this.getActionName() + S_CONFIG_ACTION_SHORT_DESCRIPTION_SUFFIX;
        return ResourceBundleUtils.getResourceBundleLocaleString(sKey, this.m_sResourceBundle);
    }

    public String toString() {
        LOGGER.entering(ConfigAction.class.getName(), "toString");
        LOGGER.exiting(ConfigAction.class.getName(), "toString");
        return this.getClass().getName() + S_DASH + this.getActionPath();
    }

    public boolean isThisActionActuallyPresentOnTheFileSystem() {
        return new File(this.getActionPath()).exists();
    }

    private static List getSortedActionListNoRegistryFile(String sRepositoryPath) {
        LOGGER.entering(ConfigAction.class.getName(), "getSortedActionListNoRegistryFile");
        Vector<ConfigAction> vcaActions = new Vector<ConfigAction>();
        String[] asFiles = FileUtils.getAllFilesInThisDirectory(sRepositoryPath);
        if (asFiles == null) {
            LOGGER.exiting(ConfigAction.class.getName(), "getSortedActionListNoRegistryFile");
            return vcaActions;
        }
        for (int i = 0; i < asFiles.length; ++i) {
            File sActionFile = new File(sRepositoryPath, asFiles[i]);
            String sFullActionPath = sActionFile.getAbsolutePath();
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "getSortedActionListNoRegistryFile", "Processing this file: " + sFullActionPath);
            if (!sActionFile.exists() || !sActionFile.isFile()) continue;
            ConfigAction caThis = ConfigAction.createAction(sFullActionPath);
            vcaActions.add(caThis);
        }
        Collections.sort(vcaActions);
        LOGGER.exiting(ConfigAction.class.getName(), "getSortedActionListNoRegistryFile");
        return vcaActions;
    }

    private static boolean isValidActionFileNameWithPriority(String sActionFileName) {
        LOGGER.entering(ConfigAction.class.getName(), "isValidActionFileNameWithPriority");
        boolean fValidActionFileName = PATTERN_ACTION_NAME_WITH_PRIORITY.matcher(sActionFileName).matches();
        if (!fValidActionFileName) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "isValidActionFileNameWithPriority", sActionFileName + " did not match the action name pattern");
        }
        LOGGER.exiting(ConfigAction.class.getName(), "isValidActionFileNameWithPriority");
        return fValidActionFileName;
    }

    private static boolean isValidActionFileName(String sActionFileName) {
        LOGGER.entering(ConfigAction.class.getName(), "isValidActionFileName");
        boolean fValidActionFileName = PATTERN_ACTION_NAME.matcher(sActionFileName).matches();
        if (!fValidActionFileName) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "isValidActionFileName", sActionFileName + " did not match the action name pattern");
        }
        LOGGER.exiting(ConfigAction.class.getName(), "isValidActionFileName");
        return fValidActionFileName;
    }

    private static void initializeActionProperties(ConfigAction caThis, String sActionPath) {
        LOGGER.entering(ConfigAction.class.getName(), "initializeActionProperties");
        String sActionFileName = new File(sActionPath).getName();
        caThis.m_sActionPath = sActionPath;
        caThis.m_nPriority = ConfigAction.getPriority(sActionFileName);
        caThis.m_fActionFatalToConfigStatus = ConfigAction.getFatalToConfigIfFailsFlag(sActionFileName);
        caThis.m_sActionName = ConfigAction.getActionName(sActionFileName);
        caThis.m_listArguments = new Vector();
        caThis.m_action = ActionFactory.getAction(caThis.m_sActionPath, caThis.m_fActionFatalToConfigStatus);
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "initializeActionProperties", "Priority for " + sActionPath + " is: " + caThis.m_nPriority);
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "initializeActionProperties", "Fatal flag for " + sActionPath + " is: " + caThis.m_fActionFatalToConfigStatus);
        LOGGER.exiting(ConfigAction.class.getName(), "initializeActionProperties");
    }

    private static void setEmtpyActionNoPriorityNotFatal(ConfigAction ca, String sActionPath) {
        LOGGER.entering(ConfigAction.class.getName(), "setEmtpyActionNoPriorityNotFatal");
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "setEmtpyActionNoPriorityNotFatal", "Creating empty action for: " + sActionPath);
        ca.m_sActionName = new File(sActionPath).getName();
        ca.m_sActionPath = sActionPath;
        ca.m_nPriority = 999999999;
        ca.m_fActionFatalToConfigStatus = false;
        ca.m_listArguments = new Vector();
        ca.m_action = ActionFactory.getEmptyAction(sActionPath, ca.m_fActionFatalToConfigStatus);
        LOGGER.exiting(ConfigAction.class.getName(), "setEmtpyActionNoPriorityNotFatal");
    }

    private static int getPriority(String sActionFileName) {
        int nPriority;
        LOGGER.entering(ConfigAction.class.getName(), "getPriority");
        Matcher matcher = PATTERN_ACTION_NAME_WITH_PRIORITY.matcher(sActionFileName);
        if (matcher.matches()) {
            nPriority = Integer.parseInt(matcher.group(1));
        } else {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getPriority", sActionFileName + " did not match the action name pattern, assigning N_NO_PRIORITY to it");
            nPriority = 999999999;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getPriority", "The parsed priority for " + sActionFileName + " was: " + nPriority);
        LOGGER.exiting(ConfigAction.class.getName(), "getPriority");
        return nPriority;
    }

    private static String getActionName(String sActionFileName) {
        LOGGER.entering(ConfigAction.class.getName(), "getActionName");
        Matcher matcherActionNameEncodesFatalityAndPriorityCode = PATTERN_ACTION_NAME_WITH_PRIORITY.matcher(sActionFileName);
        Matcher matcherActionNameDoesNotEncodeFatalityAndPriorityCode = PATTERN_ACTION_NAME.matcher(sActionFileName);
        String sName = S_EMPTY;
        if (matcherActionNameEncodesFatalityAndPriorityCode.matches()) {
            sName = matcherActionNameEncodesFatalityAndPriorityCode.group(3);
        }
        if (matcherActionNameDoesNotEncodeFatalityAndPriorityCode.matches()) {
            sName = matcherActionNameDoesNotEncodeFatalityAndPriorityCode.group(1);
        }
        if (sName.equals(S_EMPTY)) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getActionName", sActionFileName + " did not match the action name pattern, assigning name as an empty string");
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getActionName", "The parsed name for " + sActionFileName + " was: " + sName);
        LOGGER.exiting(ConfigAction.class.getName(), "getActionName");
        return sName;
    }

    private static boolean getFatalToConfigIfFailsFlag(String sActionFileName) {
        boolean fFatalToConfigIfFails;
        LOGGER.entering(ConfigAction.class.getName(), "getFatalToConfigIfFailsFlag");
        Matcher matcher = PATTERN_ACTION_NAME_WITH_PRIORITY.matcher(sActionFileName);
        if (matcher.matches()) {
            String sFatalFlag = matcher.group(2);
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "getFatalToConfigIfFailsFlag", "Fatal flag string for " + sActionFileName + " was parsed to be: " + sFatalFlag);
            if (S_FATAL_FLAG.equalsIgnoreCase(sFatalFlag)) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getFatalToConfigIfFailsFlag", sActionFileName + " was determined to be fatal to the overall configuration if it fails");
                fFatalToConfigIfFails = true;
            } else {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getFatalToConfigIfFailsFlag", sActionFileName + " was not determined to be fatal to the overall configuration if it fails");
                fFatalToConfigIfFails = false;
            }
        } else {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getFatalToConfigIfFailsFlag", sActionFileName + " could not be parsed as a valid action name, assuming its not fatal to configuration if it fails");
            fFatalToConfigIfFails = false;
        }
        LOGGER.exiting(ConfigAction.class.getName(), "getFatalToConfigIfFailsFlag");
        return fFatalToConfigIfFails;
    }
}

