/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine;

import com.ibm.ws.install.configmanager.actionengine.ActionArgument;
import com.ibm.ws.install.configmanager.actionengine.ActionRegistryParser;
import com.ibm.ws.install.configmanager.actionengine.RegistryStructureException;
import com.ibm.ws.install.configmanager.launcher.ArgumentValueFetcher;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.FileUtils;
import com.ibm.ws.install.configmanager.utils.RegistryParsingUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentRegistryParser {
    private static Map<File, List<ActionArgument>> m_mapRegistryToArgList = new Hashtable<File, List<ActionArgument>>();
    private static File m_fileArgumentRegistryPath;
    private static final String S_TAG_REG_ARGUMENT_REGISTRY = "argumentRegistry";
    private static final String S_TAG_REG_PATH = "path";
    private static final String S_TAG_ACTION_REGISTRY = "actionRegistry";
    private static final Logger LOGGER;
    private static final String S_CLASS_NAME;

    public static ActionArgument getActionArgument(Document documentActionRegistry, String sArgumentKey) {
        LOGGER.entering(S_CLASS_NAME, "getActionArgument");
        try {
            File fileRegistry = new File(new URI(documentActionRegistry.getDocumentURI()));
            fileRegistry = FileUtils.getNormalizedPath(fileRegistry);
            if (!m_mapRegistryToArgList.containsKey(fileRegistry)) {
                ArgumentRegistryParser.initialize(documentActionRegistry);
                if (!m_mapRegistryToArgList.containsKey(fileRegistry)) {
                    LOGGER.logp(Level.INFO, S_CLASS_NAME, "getActionArgument", fileRegistry + " argument definition is not present within the parsed argument registry " + "The parser might have not been initialized with the proper registry.");
                    return null;
                }
            }
            ActionArgument aaToReturn = ArgumentRegistryParser.getActionArgumentFromCache(fileRegistry, sArgumentKey);
            return aaToReturn;
        }
        catch (URISyntaxException urise) {
            LogUtils.logException(LOGGER, urise);
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getActionArgument", "The action registry document " + documentActionRegistry.getDocumentURI() + " returned a malformed URI. Therefore not able to retrieve the corresponding" + "argument definitions.");
            LOGGER.exiting(S_CLASS_NAME, "getActionArgument");
            return null;
        }
    }

    public static boolean isArgumentRegistryAvailable(Document document) throws RegistryStructureException {
        LOGGER.entering(S_CLASS_NAME, "isArgumentRegistryAvailable");
        File fileArgumentRegistryPath = ArgumentRegistryParser.getArgumentRegistryFileFromActionRegistryDOM(document);
        if (fileArgumentRegistryPath == null) {
            LOGGER.exiting(S_CLASS_NAME, "isArgumentRegistryAvailable");
            return false;
        }
        if (!fileArgumentRegistryPath.exists()) {
            throw new RegistryStructureException("The path to the argument registry, " + m_fileArgumentRegistryPath + "specified withing the action registry does not exists on the file system.");
        }
        LOGGER.exiting(S_CLASS_NAME, "isArgumentRegistryAvailable");
        return true;
    }

    public static void initialize(Document document) {
        LOGGER.entering(S_CLASS_NAME, "initialize");
        try {
            m_fileArgumentRegistryPath = ArgumentRegistryParser.getArgumentRegistryFileFromActionRegistryDOM(document);
            Document documentArgumentRegistryDOM = RegistryParsingUtils.parseRegistryXMLFileIntoADOMModel(ArgumentRegistryParser.getArgumentRegistryFile());
            m_mapRegistryToArgList = ArgumentRegistryParser.addActionArgumentFromActionRegistryDOMToCache(documentArgumentRegistryDOM);
            LOGGER.exiting(S_CLASS_NAME, "initialize");
        }
        catch (ParserConfigurationException parserconfigurationexception) {
            LogUtils.logException(LOGGER, parserconfigurationexception);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getActionArgument", "XML parser initialization exception while trying to parse the action registry, returning null as action list");
        }
        catch (SAXException saxexception) {
            LogUtils.logException(LOGGER, saxexception);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getActionArgument", "Action registry is corrupt, returning null as action list");
        }
        catch (IOException ioexception) {
            LogUtils.logException(LOGGER, ioexception);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getActionArgument", "I/O exception in accessing the action registry, returning null as action list");
        }
        catch (RegistryStructureException exception) {
            LogUtils.logException(LOGGER, exception);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getActionArgument", "I/O exception in accessing the action registry, returning null as action list");
        }
    }

    private static ActionArgument getActionArgumentFromCache(File fileRegistry, String sArgumentKey) {
        LOGGER.entering(S_CLASS_NAME, "getActionArgumentFromCache");
        List<ActionArgument> listActionArguments = m_mapRegistryToArgList.get(fileRegistry);
        for (ActionArgument aaThis : listActionArguments) {
            if (!aaThis.getKey().equals(sArgumentKey)) continue;
            LOGGER.exiting(S_CLASS_NAME, "getActionArgumentFromCache");
            return aaThis;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getActionArgumentFromCache", "Argument " + sArgumentKey + " was not present in the list of argument applicable to " + fileRegistry.getAbsolutePath() + " registry file. Returning null.");
        LOGGER.exiting(S_CLASS_NAME, "getActionArgumentFromCache");
        return null;
    }

    private static File getArgumentRegistryFile() {
        return m_fileArgumentRegistryPath;
    }

    private static File getArgumentRegistryFileFromActionRegistryDOM(Document documentActionRegistry) throws RegistryStructureException {
        LOGGER.entering(S_CLASS_NAME, "getArgumentRegistryPathFromDOM");
        Node node = documentActionRegistry.getElementsByTagName(S_TAG_REG_ARGUMENT_REGISTRY).item(0);
        if (node == null) {
            LOGGER.exiting(S_CLASS_NAME, "getArgumentRegistryPathFromDOM");
            return null;
        }
        NamedNodeMap namedDocumentMapOfAttributes = node.getAttributes();
        String sArgumentRegistryPathRelativeToConfigDir = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_PATH, namedDocumentMapOfAttributes);
        if (sArgumentRegistryPathRelativeToConfigDir != null) {
            String sConfigDirPath = ArgumentValueFetcher.getArgumentValue("WS_CMT_CONF_DIR");
            LOGGER.exiting(S_CLASS_NAME, "getArgumentRegistryPathFromDOM");
            return FileUtils.getNormalizedPath(new File(sConfigDirPath + File.separator + sArgumentRegistryPathRelativeToConfigDir));
        }
        LOGGER.exiting(S_CLASS_NAME, "getArgumentRegistryPathFromDOM");
        return null;
    }

    private static Map<File, List<ActionArgument>> addActionArgumentFromActionRegistryDOMToCache(Document document) {
        LOGGER.entering(ActionRegistryParser.class.getName(), "convertDOMToMapOfRegistriesToActionArguments");
        NodeList nodelistArguments = document.getElementsByTagName(S_TAG_ACTION_REGISTRY);
        for (int nNodeNumber = 0; nNodeNumber < nodelistArguments.getLength(); ++nNodeNumber) {
            Node nodeRegistryThis = nodelistArguments.item(nNodeNumber);
            NamedNodeMap namednodemapAttributes = nodeRegistryThis.getAttributes();
            String sRegistryPathRelativeToConfigRepository = RegistryParsingUtils.getAttributeValueFromGivenNamedNodeMapOfAttributes(S_TAG_REG_PATH, namednodemapAttributes);
            List<ActionArgument> listActionArguments = RegistryParsingUtils.getActionArgumentListForTheGivenNode(nodeRegistryThis);
            m_mapRegistryToArgList.put(FileUtils.getNormalizedPath(RegistryParsingUtils.convertRelativeRegistryPathToFullRegistryFilePath(sRegistryPathRelativeToConfigRepository)), listActionArguments);
        }
        LOGGER.exiting(ActionRegistryParser.class.getName(), "convertDOMToMapOfRegistriesToActionArguments");
        return m_mapRegistryToArgList;
    }

    static {
        LOGGER = LoggerFactory.createLogger(ArgumentRegistryParser.class);
        S_CLASS_NAME = ArgumentRegistryParser.class.getName();
    }
}

