/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine;

import com.ibm.ws.install.configmanager.actionengine.Action;
import com.ibm.ws.install.configmanager.actionengine.ConfigAction;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import java.util.logging.Logger;

public abstract class ActionImpl
implements Action {
    private String m_sActionPath = null;
    private boolean m_fActionFatalToConfigStatus = true;
    protected static final String S_EMPTY = "";
    private static final Logger LOGGER = LoggerFactory.createLogger(ActionImpl.class);

    public ActionImpl(String sActionPath, boolean fFatal) {
        this.m_sActionPath = sActionPath;
        this.m_fActionFatalToConfigStatus = fFatal;
    }

    protected String getActionPath() {
        return this.m_sActionPath;
    }

    protected boolean isActionFailureFatalToConfiguration() {
        LOGGER.entering(ConfigAction.class.getName(), "isActionFailureFatalToConfiguration");
        LOGGER.exiting(ConfigAction.class.getName(), "isActionFailureFatalToConfiguration");
        return this.m_fActionFatalToConfigStatus;
    }

    public abstract boolean executeAction();

    public abstract boolean rollBackAction();

    public abstract String getActionManualCommand();

    public abstract String getActionOutput();

    public abstract String getActionErrorOutput();

    protected String getActionPathAsSafeShellParameter() {
        LOGGER.entering(ActionImpl.class.getName(), "getActionPathAsSafeShellParameter");
        LOGGER.exiting(ActionImpl.class.getName(), "getActionPathAsSafeShellParameter");
        return PlatformConstants.convertToShellParam(this.m_sActionPath);
    }
}

