/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine;

import com.ibm.ws.install.configmanager.actionengine.ANTAction;
import com.ibm.ws.install.configmanager.actionengine.Action;
import com.ibm.ws.install.configmanager.actionengine.ActionImpl;
import com.ibm.ws.install.configmanager.actionengine.ConfigAction;
import com.ibm.ws.install.configmanager.actionengine.EmptyAction;
import com.ibm.ws.install.configmanager.actionengine.IJCAction;
import com.ibm.ws.install.configmanager.actionengine.JACLAction;
import com.ibm.ws.install.configmanager.actionengine.PlatformNativeShellScriptAction;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class ActionFactory {
    private static final String S_JACL = "jacl";
    private static final String S_SH = "sh";
    private static final String S_BAT = "bat";
    private static final String S_ANT = "ant";
    private static final String S_IJC = "ijc";
    private static final int N_SUFFIX_GROUP = 3;
    private static final Logger LOGGER = LoggerFactory.createLogger(ActionFactory.class);
    private static final String S_CLASS_NAME = ActionFactory.class.getName();

    public static Action getAction(String sActionFileName, boolean fFatal) {
        ActionImpl result = null;
        LOGGER.entering(S_CLASS_NAME, "getAction");
        String sActionTrueFileName = new File(sActionFileName).getName();
        Matcher matcher = ConfigAction.PATTERN_ACTION_NAME.matcher(sActionTrueFileName);
        if (matcher.matches()) {
            String sActionType = matcher.group(3);
            if (sActionType.equalsIgnoreCase(S_JACL)) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getActionClass", sActionTrueFileName + " was parsed to be of type JACL (.jacl) action");
                result = new JACLAction(sActionFileName, fFatal);
            }
            if (sActionType.equalsIgnoreCase(S_SH)) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getActionClass", sActionTrueFileName + " was parsed to be of type SHELL (.sh) action");
                result = new PlatformNativeShellScriptAction(sActionFileName, fFatal);
            }
            if (sActionType.equalsIgnoreCase(S_BAT)) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getActionClass", sActionTrueFileName + " was parsed to be of type SHELL (.bat) action");
                result = new PlatformNativeShellScriptAction(sActionFileName, fFatal);
            }
            if (sActionType.equalsIgnoreCase(S_ANT)) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getActionClass", sActionTrueFileName + " was parsed to be of type ANT (.ant) action");
                result = new ANTAction(sActionFileName, fFatal);
            }
            if (sActionType.equalsIgnoreCase(S_IJC)) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getActionClass", sActionTrueFileName + " was parsed to be of type InProcess Java Call (.ijc) action");
                result = new IJCAction(sActionFileName, fFatal);
            }
        } else {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getActionClass", sActionTrueFileName + " could not be parsed as a valid action name, assuming an empty action");
            result = new EmptyAction(sActionFileName, fFatal);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getActionClass", "Returning " + result.getClass().getName() + " as the executing class for " + sActionFileName);
        LOGGER.exiting(S_CLASS_NAME, "getAction");
        return result;
    }

    public static Action getEmptyAction(String sActionFileName, boolean fFatal) {
        LOGGER.entering(S_CLASS_NAME, "getEmptyAction");
        EmptyAction result = new EmptyAction(sActionFileName, fFatal);
        LOGGER.exiting(S_CLASS_NAME, "getEmptyAction");
        return result;
    }
}

