/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine;

import com.ibm.ws.install.configmanager.actionengine.ActionImpl;
import com.ibm.ws.install.configmanager.actionengine.ant.utils.ANTLogToCmtLogAdapter;
import com.ibm.ws.install.configmanager.actionengine.ant.utils.InProcessAntRunner;
import com.ibm.ws.install.configmanager.launcher.OutputStreamHandler;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.install.configmanager.utils.ArrayUtils;
import com.ibm.ws.install.configmanager.utils.ParameterPassingUtils;
import com.ibm.ws.install.configmanager.utils.WASHomeLocater;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ANTAction
extends ActionImpl {
    private String m_sOutput = "";
    private String m_sErrorOutput = "";
    public static final String S_IS_CONFIG_ACTION_FATAL_FLAG = "isConfigActionFatal";
    private static final String S_SPACE = " ";
    private static final String S_EMPTY = "";
    private static final String S_ANT_BUILD_FILE_OPTION = "-buildfile";
    private static final String S_ANT_LOGGER_OPTION = "-logger";
    private static final String S_WAS_HOME = "WAS_HOME";
    private static final String S_SLASH_BIN = "/bin/";
    private static final String S_ANT_EXEC_PARAM = PlatformConstants.getANTInterpretorName();
    private static final String S_WS_ANT_EXEC_PARAM = PlatformConstants.getWSANTInterpretorName();
    private static final Logger LOGGER = LoggerFactory.createLogger(ANTAction.class);
    private static final String S_CLASS_NAME = ANTAction.class.getName();

    public ANTAction(String sActionPath, boolean fFatal) {
        super(sActionPath, fFatal);
    }

    public boolean executeAction() {
        LOGGER.entering(ANTAction.class.getName(), "executeAction");
        boolean fResult = false;
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeAction", "Using an InProcess ANT call to execute this action: " + this.getActionPath());
        fResult = this.executeActionUsingAnInProcessANTCall();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeAction", "Result of executing " + this.getActionPath() + " was: " + fResult);
        LOGGER.exiting(ANTAction.class.getName(), "executeAction");
        return fResult;
    }

    public boolean rollBackAction() {
        LOGGER.entering(ANTAction.class.getName(), "rollBackAction");
        LOGGER.exiting(ANTAction.class.getName(), "rollBackAction");
        return false;
    }

    public String getActionManualCommand() {
        LOGGER.entering(ANTAction.class.getName(), "getActionManualCommand");
        String sManualCmd = PlatformConstants.convertExecArrayToPlatformSpecificExecCommand(this.getExecStringArrayToExecuteThisActionUsingANT());
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "getActionManualCommand", "The manual command for " + this.getActionPath() + " action is: " + sManualCmd);
        LOGGER.exiting(ANTAction.class.getName(), "getActionManualCommand");
        return sManualCmd;
    }

    private boolean executeActionUsingAnInProcessANTCall() {
        LOGGER.entering(ANTAction.class.getName(), "executeActionUsingAnInProcessANTCall");
        String sPreviousProp = System.getProperty(S_IS_CONFIG_ACTION_FATAL_FLAG, S_EMPTY);
        System.setProperty(S_IS_CONFIG_ACTION_FATAL_FLAG, Boolean.toString(this.isActionFailureFatalToConfiguration()));
        boolean fResult = InProcessAntRunner.start(new String[]{S_ANT_BUILD_FILE_OPTION, this.getActionPath(), S_ANT_LOGGER_OPTION, ANTLogToCmtLogAdapter.class.getName()}, ParameterPassingUtils.retrieveParametersAsProperties(false), null);
        OutputStreamHandler.put();
        this.m_sOutput = OutputStreamHandler.putOutputToString();
        System.setProperty(S_IS_CONFIG_ACTION_FATAL_FLAG, sPreviousProp);
        LOGGER.exiting(ANTAction.class.getName(), "executeActionUsingAnInProcessANTCall");
        return fResult;
    }

    private String[] getExecStringArrayToExecuteThisActionUsingANT() {
        LOGGER.entering(ANTAction.class.getName(), "getExecStringArrayToExecuteThisActionUsingANT");
        String[] asPrefix = PlatformConstants.getShellExecPrefixForCurrentPlatform();
        Object[] asCmd = new String[asPrefix.length + 1];
        ArrayUtils.appendArray(asCmd, asPrefix, 0);
        asCmd[asPrefix.length] = WASHomeLocater.getWASHome() == null ? S_ANT_EXEC_PARAM + S_SPACE + S_ANT_BUILD_FILE_OPTION + S_SPACE + this.getActionPathAsSafeShellParameter() : WASHomeLocater.getWASHome() + S_SLASH_BIN + S_WS_ANT_EXEC_PARAM + S_SPACE + S_ANT_BUILD_FILE_OPTION + S_SPACE + this.getActionPathAsSafeShellParameter();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getExecStringArrayToExecuteThisActionUsingANT", "The string array to execute " + this.getActionPath() + " ANT action is: " + LogUtils.getArrayAsALoggableString(asCmd));
        LOGGER.exiting(ANTAction.class.getName(), "getExecStringArrayToExecuteThisActionUsingANT");
        return asCmd;
    }

    public String getActionErrorOutput() {
        LOGGER.entering(ANTAction.class.getName(), "getActionErrorOutput");
        LOGGER.exiting(ANTAction.class.getName(), "getActionErrorOutput");
        return this.m_sErrorOutput;
    }

    public String getActionOutput() {
        LOGGER.entering(ANTAction.class.getName(), "getActionOutput");
        LOGGER.exiting(ANTAction.class.getName(), "getActionOutput");
        return this.m_sOutput;
    }
}

