/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbpersistence.utilpm;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class TwoFacedHashMap {
    private int MAX_ENTRIES_PER_MAP;
    private final int PUT_IN_FIRST_MAP = 1;
    private final int PUT_IN_SECOND_MAP = 2;
    private HashMap firstHashMap;
    private HashMap secondHashMap;
    private int whichMapToUse = 1;
    private int DEFAULT_SIZE = 5000;

    public TwoFacedHashMap(int n) {
        this.MAX_ENTRIES_PER_MAP = n <= 0 ? this.DEFAULT_SIZE : n / 2;
        this.firstHashMap = new HashMap();
        this.secondHashMap = new HashMap();
    }

    public int size() {
        return this.firstHashMap.size() + this.secondHashMap.size();
    }

    public boolean isEmpty() {
        return this.firstHashMap.isEmpty() && this.secondHashMap.isEmpty();
    }

    public Object get(Object object) {
        Object var2_2 = null;
        var2_2 = this.firstHashMap.containsKey(object) ? this.firstHashMap.get(object) : this.secondHashMap.get(object);
        return var2_2;
    }

    public boolean containsKey(Object object) {
        return this.firstHashMap.containsKey(object) || this.secondHashMap.containsKey(object);
    }

    public synchronized void put(Object object, Object object2) {
        if (this.whichMapToUse == 1) {
            this.firstHashMap.put(object, object2);
            if (this.firstHashMap.size() >= this.MAX_ENTRIES_PER_MAP) {
                this.secondHashMap = new HashMap();
                this.whichMapToUse = 2;
            }
        } else {
            this.secondHashMap.put(object, object2);
            if (this.secondHashMap.size() >= this.MAX_ENTRIES_PER_MAP) {
                this.firstHashMap = new HashMap();
                this.whichMapToUse = 1;
            }
        }
    }

    public synchronized void remove(Object object) {
        if (this.firstHashMap.containsKey(object)) {
            this.firstHashMap.remove(object);
        } else {
            this.secondHashMap.remove(object);
        }
    }

    public synchronized void clear() {
        this.firstHashMap.clear();
        this.secondHashMap.clear();
    }

    public boolean containsValue(Object object) {
        return this.firstHashMap.containsValue(object) || this.secondHashMap.containsValue(object);
    }

    public Set keySet() {
        Set set = this.firstHashMap.keySet();
        set.addAll(this.secondHashMap.keySet());
        return Collections.synchronizedSet(set);
    }

    public Collection values() {
        Collection collection = this.firstHashMap.values();
        collection.addAll(this.secondHashMap.values());
        return Collections.synchronizedCollection(collection);
    }

    public Set entrySet() {
        Set set = this.firstHashMap.entrySet();
        set.addAll(this.secondHashMap.entrySet());
        return Collections.synchronizedSet(set);
    }
}

