/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbpersistence.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cpmi.PMBeanInfo;
import com.ibm.websphere.cpmi.PersistenceManager;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ejbpersistence.PMCacheInvalidationRequest;
import com.ibm.ws.ejbpersistence.associations.ForwardOneToOneLinkImpl;
import com.ibm.ws.ejbpersistence.associations.LinkImpl;
import com.ibm.ws.ejbpersistence.beanextensions.ConcreteBeanClassExtension;
import com.ibm.ws.ejbpersistence.beanextensions.PersistenceManagerImpl;
import com.ibm.ws.ejbpersistence.cache.CacheManager;
import com.ibm.ws.ejbpersistence.cache.CacheManagerFactory;
import com.ibm.ws.ejbpersistence.cache.InputStreamWithClassLoader;
import com.ibm.ws.ejbpersistence.utilpm.PMExceptionHandler;
import com.ibm.ws.ejbpersistence.utilpm.PMLogger;
import com.ibm.ws.ejbpersistence.utilpm.PersistenceManagerException;
import com.ibm.ws.ejbpersistence.utilpm.PersistenceManagerInternalError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.wsspi.jms.JmsMessageListenerSupport;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class PMCacheInvalidationMessageListener
implements MessageListener {
    private static PMCacheInvalidationMessageListener topicListener = null;
    private static String busName;
    private static final String topicConnectionFactoryUri = "com.ibm.websphere.ejbpersistence.InvalidateTCF";
    private static final String topicString = "com.ibm.websphere.ejbpersistence.invalidate";
    private static final boolean NON_TRANSACTIONAL_SESSION = false;
    private static LinkImpl helper;
    private static PMCacheInvalidationMessageListener singletonSelf;
    private static TopicConnectionFactory topicConnectionFactory;
    private PersistenceManagerImpl ourpm;
    private EJBContainer ejbContainer;
    private static TopicSession topicSession;
    private static TopicConnection topicConnection;
    private static TraceComponent mytc;

    public static void setupInvalidationReceiver() {
        if (mytc.isEntryEnabled()) {
            Tr.entry(mytc, "setupInvalidationReceiver()", new Object[0]);
        }
        if (CacheManagerFactory.cacheInvalidationEnabled && topicListener == null) {
            if (mytc.isDebugEnabled()) {
                Tr.debug(mytc, "Setting up a singleton PMCacheInvalidationMessageListener as a JMS topic listener.");
            }
            try {
                InitialContext initialContext = new InitialContext();
                topicConnectionFactory = (TopicConnectionFactory)initialContext.lookup(topicConnectionFactoryUri);
                if (mytc.isDebugEnabled()) {
                    Tr.debug(mytc, "JNDI lookup of topicConnectionFactory returns " + topicConnectionFactory);
                }
                try {
                    Topic topic = (Topic)initialContext.lookup(topicString);
                    topicConnection = topicConnectionFactory.createTopicConnection();
                    topicSession = topicConnection.createTopicSession(false, 1);
                    TopicSubscriber topicSubscriber = topicSession.createSubscriber(topic);
                    topicListener = new PMCacheInvalidationMessageListener();
                    JmsMessageListenerSupport.setMessageListener(topicSubscriber, topicListener);
                    topicConnection.start();
                }
                catch (JMSException jMSException) {
                    PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR5026E: Exception during invalidate listener initialization", jMSException);
                    PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
                    try {
                        if (topicConnection != null) {
                            topicConnection.close();
                        }
                    }
                    catch (Throwable throwable) {
                    }
                }
                catch (NamingException namingException) {
                    PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR5026E: Exception during invalidate listener initialization", namingException);
                    PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
                }
                catch (Throwable throwable) {
                    PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR1000E: Exception occurred :", throwable);
                    PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
                }
            }
            catch (Exception exception) {
                PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR5026E: Exception during invalidate listener initialization", exception);
                PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
            }
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit(mytc, "setupInvalidationReceiver()");
        }
    }

    public void onMessage(Message message) {
        if (mytc.isEntryEnabled()) {
            Tr.entry(mytc, "onMessage(javax.jms.Message msg)", new Object[]{message});
        }
        PMCacheInvalidationRequest pMCacheInvalidationRequest = null;
        try {
            ObjectMessage objectMessage = (ObjectMessage)message;
            pMCacheInvalidationRequest = (PMCacheInvalidationRequest)objectMessage.getObject();
            if (mytc.isDebugEnabled()) {
                Tr.debug(mytc, "PMCacheInvalidationRequest from msg = " + pMCacheInvalidationRequest);
            }
            this.invalidate(pMCacheInvalidationRequest);
            Topic topic = (Topic)objectMessage.getJMSReplyTo();
            if (topic != null) {
                if (mytc.isDebugEnabled()) {
                    Tr.debug(mytc, "About to send (publish) invalidation ACK to (non-null) reply-to Destination: " + topic);
                }
                TopicPublisher topicPublisher = topicSession.createPublisher(topic);
                Message message2 = topicSession.createMessage();
                message2.setJMSType("cycle");
                message2.setJMSCorrelationID(message.getJMSCorrelationID());
                topicPublisher.publish(message2);
            }
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener.onMessage", (String)"2", (Object)this);
            PersistenceManagerException persistenceManagerException = new PersistenceManagerException("PMGR5021E: PM's invalidation listener received a message but the message parameter was not a PMCacheInvalidationRequest object as required.");
            PMExceptionHandler.logException(mytc, persistenceManagerException);
            return;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener.onMessage", (String)"10", (Object)this);
            PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR0000", new Object[]{"PMCacheInvalidation error: " + exception});
            PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
            return;
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit(mytc, "onMessage(javax.jms.Message msg)");
        }
    }

    public void invalidate(byte[] byArray) {
        if (mytc.isEntryEnabled()) {
            Tr.entry(mytc, "invalidate(byte[] requestInWireFormat)", new Object[]{byArray});
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit(mytc, "invalidate(byte[] requestInWireFormat)");
        }
    }

    public void invalidate(PMCacheInvalidationRequest pMCacheInvalidationRequest) {
        PersistenceManager[] persistenceManagerArray;
        if (mytc.isEntryEnabled()) {
            Tr.entry(mytc, "invalidate(PMCacheInvalidationRequest request)", new Object[]{pMCacheInvalidationRequest});
        }
        if (this.ourpm == null) {
            this.ejbContainer = helper.getContainerInterface();
            persistenceManagerArray = this.ejbContainer.getPersistenceManagers();
            for (int i = 0; i < persistenceManagerArray.length; ++i) {
                if (!(persistenceManagerArray[i] instanceof PersistenceManagerImpl)) continue;
                this.ourpm = (PersistenceManagerImpl)persistenceManagerArray[i];
                break;
            }
            if (this.ourpm == null) {
                PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR0000", new Object[]{"PersistenceManagerImpl==null"});
                FFDCFilter.processException((Throwable)persistenceManagerInternalError, (String)"com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener.onMessage", (String)"810", (Object)this);
                PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
                return;
            }
        }
        try {
            persistenceManagerArray = this.ourpm.getPMHomeInfo(pMCacheInvalidationRequest.getBeanHomeJNDIName());
            J2EEName j2EEName = persistenceManagerArray.getJ2EEName();
            PMBeanInfo pMBeanInfo = persistenceManagerArray.getPMBeanInfo();
            CacheManager cacheManager = ((ConcreteBeanClassExtension)pMBeanInfo).getCacheManager();
            switch (pMCacheInvalidationRequest.getInvalidationType()) {
                case 0: {
                    ClassLoader classLoader = this.ejbContainer.getClassLoader(j2EEName);
                    InputStreamWithClassLoader inputStreamWithClassLoader = new InputStreamWithClassLoader(classLoader, pMCacheInvalidationRequest.getKeyAsByteArray());
                    Serializable serializable = (Serializable)inputStreamWithClassLoader.readObject();
                    cacheManager.ejbInvalidate(serializable);
                    break;
                }
                case 1: {
                    ClassLoader classLoader = this.ejbContainer.getClassLoader(j2EEName);
                    InputStreamWithClassLoader inputStreamWithClassLoader = new InputStreamWithClassLoader(classLoader, pMCacheInvalidationRequest.getKeyAsByteArray());
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    try {
                        while (true) {
                            Object object = inputStreamWithClassLoader.readObject();
                            arrayList.add(object);
                        }
                    }
                    catch (EOFException eOFException) {
                        cacheManager.ejbInvalidate(arrayList);
                        break;
                    }
                }
                case 2: {
                    cacheManager.ejbInvalidateAll();
                }
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener.onMessage", (String)"820", (Object)this);
            PersistenceManagerInternalError persistenceManagerInternalError = new PersistenceManagerInternalError("PMGR5024E: IOException while accessing byte-array-ized key object {0}", new Object[]{pMCacheInvalidationRequest.getKeyAsByteArray()}, iOException);
            PMExceptionHandler.logException(mytc, persistenceManagerInternalError);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.ejbpersistence.cache.PMCacheInvalidationMessageListener.onMessage", (String)"830", (Object)this);
            PersistenceManagerException persistenceManagerException = new PersistenceManagerException("PMGR5025E: ClassNotFoundException while deserializing bean primary key object passed by client code. Key object is not of the correct class for bean type with home JNDI name = {0}.", new Object[]{pMCacheInvalidationRequest.getBeanHomeJNDIName()}, classNotFoundException);
            PMExceptionHandler.logException(mytc, persistenceManagerException);
        }
        if (mytc.isEntryEnabled()) {
            Tr.exit(mytc, "invalidate(PMCacheInvalidationRequest request)");
        }
    }

    static {
        helper = new ForwardOneToOneLinkImpl(null, null, null, null);
        mytc = PMLogger.registerTC(PMCacheInvalidationMessageListener.class);
        if (CacheManagerFactory.cacheInvalidationEnabled) {
            busName = CacheManagerFactory.cacheInvalidationJvmArg;
            if (mytc.isDebugEnabled()) {
                Tr.debug(mytc, "PM cache invalidation enabled, using busName = " + busName);
            }
        } else if (mytc.isDebugEnabled()) {
            Tr.debug(mytc, "Property com.ibm.ws.ejbpersistence.cacheinvalidation not specified, default is not enabled");
        }
    }
}

