/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbpersistence.beanextensions;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.appprofile.accessintent.ReadAheadHint;
import com.ibm.ws.ejbpersistence.beanextensions.ConcreteBeanClassExtensionImpl;
import com.ibm.ws.ejbpersistence.beanextensions.DataAccessSpecImpl;
import java.util.HashMap;
import java.util.Set;

final class DataAccessSpecGroup {
    static TraceComponent tc = ConcreteBeanClassExtensionImpl.registerTC(DataAccessSpecGroup.class);
    private String name;
    private boolean isBeanFinder;
    private ConcreteBeanClassExtensionImpl classExt;
    private HashMap[] specsWithRR = null;
    DataAccessSpecImpl[] specsNoRR = null;
    private static int MAX_LOCK_TYPE = 5;

    DataAccessSpecGroup(String string, boolean bl, ConcreteBeanClassExtensionImpl concreteBeanClassExtensionImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "DataAccessSpecGroup()", new Object[]{string, new Boolean(bl)});
        }
        this.name = string;
        this.isBeanFinder = bl;
        this.classExt = concreteBeanClassExtensionImpl;
        this.specsWithRR = new HashMap[MAX_LOCK_TYPE];
        this.specsNoRR = new DataAccessSpecImpl[MAX_LOCK_TYPE];
        for (int i = 0; i < MAX_LOCK_TYPE; ++i) {
            this.specsWithRR[i] = null;
            this.specsNoRR[i] = null;
        }
    }

    String getName() {
        return this.name;
    }

    boolean isBeanFinder() {
        return this.isBeanFinder;
    }

    void put(DataAccessSpecImpl dataAccessSpecImpl) {
        if (!this.isBeanFinder) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Put spec for none bean finder: ", dataAccessSpecImpl);
            }
            this.specsNoRR[1] = dataAccessSpecImpl;
            return;
        }
        ReadAheadHint readAheadHint = dataAccessSpecImpl.getReadAhead();
        if (readAheadHint == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Put spec for bean finder w/o read ahead: ", dataAccessSpecImpl);
            }
            this.specsNoRR[dataAccessSpecImpl.getLockType()] = dataAccessSpecImpl;
            return;
        }
        int n = dataAccessSpecImpl.getLockType();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Put spec for bean finder with read ahead: ", dataAccessSpecImpl);
        }
        if (this.specsWithRR[n] == null) {
            this.specsWithRR[n] = new HashMap();
        }
        this.specsWithRR[n].put(readAheadHint, dataAccessSpecImpl);
    }

    DataAccessSpecImpl getOther(AccessIntent accessIntent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Get spec for none bean finder:" + accessIntent);
        }
        return this.specsNoRR[1];
    }

    DataAccessSpecImpl getBeanFinder(AccessIntent accessIntent) {
        if (this.classExt.isOptimistic(accessIntent) || this.classExt.isReadIntent(accessIntent)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Get spec for optimistic or pessimistic read:", accessIntent);
            }
            return this.get(1, this.classExt.getReadAhead(accessIntent));
        }
        int n = this.classExt.getLockTypeInternal(accessIntent);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Get spec for pessimistic update lockType:" + n + ",intent:" + accessIntent);
        }
        return this.get(n, this.classExt.getReadAhead(accessIntent));
    }

    private DataAccessSpecImpl get(int n, ReadAheadHint readAheadHint) {
        if (readAheadHint == null || this.specsWithRR[n] == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "There is no readAhead spec defined.");
            }
            return this.specsNoRR[n];
        }
        DataAccessSpecImpl dataAccessSpecImpl = (DataAccessSpecImpl)this.specsWithRR[n].get(readAheadHint);
        if (dataAccessSpecImpl == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "There is no immediate match for path:" + readAheadHint);
            }
            ReadAheadHint readAheadHint22 = null;
            ReadAheadHint readAheadHint3 = null;
            int n2 = 0;
            Set set = this.specsWithRR[n].keySet();
            for (ReadAheadHint readAheadHint22 : set) {
                int n3 = readAheadHint.bestFitRating(readAheadHint22);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Path defined/bestFitRating", new Object[]{readAheadHint22, new Integer(n3)});
                }
                if (n3 > n2 || n3 == -1) {
                    n2 = n3;
                    readAheadHint3 = readAheadHint22;
                }
                if (n3 != -1) continue;
            }
            if (readAheadHint3 != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Use this path", readAheadHint3);
                }
                dataAccessSpecImpl = (DataAccessSpecImpl)this.specsWithRR[n].get(readAheadHint3);
            }
        }
        if (dataAccessSpecImpl == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "No match found.");
            }
            return this.specsNoRR[n];
        }
        return dataAccessSpecImpl;
    }
}

