/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ejbcontainer.AmbiguousEJBReferenceException;
import com.ibm.ws.naming.util.NullRefAddrException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmbiguousEJBRefObjectFactory
implements ObjectFactory {
    private static final String CLASS_NAME = AmbiguousEJBRefObjectFactory.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJBContainer", "com.ibm.ejs.container.container");
    static final String ADDR_TYPE = "AmbiguousEJBReference";

    public AmbiguousEJBRefObjectFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>");
        }
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectInstance : " + obj);
        }
        if (!(obj instanceof Reference)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getObjectInstance : Reference object not provided : " + obj);
            }
            return null;
        }
        Reference ref = (Reference)obj;
        if (!ref.getFactoryClassName().equals(CLASS_NAME)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getObjectInstance : Incorrect factory for Reference : " + obj);
            }
            return null;
        }
        RefAddr addr = ref.get(ADDR_TYPE);
        if (addr == null) {
            NullRefAddrException nex = new NullRefAddrException("The address for this Reference is empty (null)");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getObjectInstance : " + nex.getMessage());
            }
            throw nex;
        }
        String message = (String)addr.getContent();
        AmbiguousEJBReferenceException ambiguousEx = new AmbiguousEJBReferenceException(message);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectInstance : " + ambiguousEx.getMessage());
        }
        throw ambiguousEx;
    }
}

