/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.jitdeploy;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.container.EJBMethodInfoImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.classloader.CompoundClassLoader;
import com.ibm.ws.ejbcontainer.jitdeploy.EJBHomeImpl;
import com.ibm.ws.ejbcontainer.jitdeploy.EJBUtils;
import com.ibm.ws.ejbcontainer.jitdeploy.EJBWrapper;
import com.ibm.ws.ejbcontainer.jitdeploy.EJBWrapperType;
import com.ibm.ws.ejbcontainer.jitdeploy.JIT_Stub;
import com.ibm.ws.ejbcontainer.jitdeploy.JIT_Tie;
import com.ibm.ws.ejbcontainer.jitdeploy.RMItoIDL;
import com.ibm.ws.ejbcontainer.jitdeploy.WSEJBProxy;
import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.reflect.Method;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JITDeploy {
    private static final String CLASS_NAME = JITDeploy.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "JITDeploy", "com.ibm.ejs.container.container");

    public static Class<?> getComponentInterface(Class homeInterface, String beanName) throws EJBConfigurationException {
        return EJBHomeImpl.getComponentInterface(homeInterface, beanName);
    }

    public static void validateInterfaceBasics(Class remoteHome, Class remoteInterface, Class localHome, Class localInterface, Class webServiceEndpointInterface, Class[] remoteBusinessInterfaces, Class[] localBusinessInterfaces, Class ejbClass, String beanName, int beanType) throws EJBConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "validateInterfaceBasics : " + beanName);
        }
        if (remoteHome != null) {
            EJBHomeImpl.validateInterfaceBasics(remoteHome, remoteInterface, EJBWrapperType.REMOTE_HOME, beanName, beanType);
        }
        if (remoteInterface != null) {
            EJBWrapper.validateInterfaceBasics(remoteInterface, EJBWrapperType.REMOTE, beanName);
            if (remoteHome == null) {
                Tr.error(tc, "JIT_MISSING_REMOTE_HOME_CNTR5001E", new Object[]{beanName, remoteInterface.getName()});
                throw new EJBConfigurationException("An EJB remote component interface requires a remote-home interface : " + remoteInterface.getName() + " on EJB " + beanName);
            }
        }
        if (localHome != null) {
            EJBHomeImpl.validateInterfaceBasics(localHome, localInterface, EJBWrapperType.LOCAL_HOME, beanName, beanType);
        }
        if (localInterface != null && beanType != 6) {
            EJBWrapper.validateInterfaceBasics(localInterface, EJBWrapperType.LOCAL, beanName);
            if (localHome == null) {
                Tr.error(tc, "JIT_MISSING_LOCAL_HOME_CNTR5002E", new Object[]{beanName, localInterface.getName()});
                throw new EJBConfigurationException("An EJB local component interface requires a local-home interface : " + localInterface.getName() + " on EJB " + beanName);
            }
        }
        if (webServiceEndpointInterface != null) {
            EJBWrapper.validateInterfaceBasics(webServiceEndpointInterface, EJBWrapperType.SERVICE_ENDPOINT, beanName);
        }
        if (remoteBusinessInterfaces != null) {
            for (Class remote : remoteBusinessInterfaces) {
                EJBWrapper.validateInterfaceBasics(remote, EJBWrapperType.BUSINESS_REMOTE, beanName);
            }
        }
        if (localBusinessInterfaces != null) {
            for (Class local : localBusinessInterfaces) {
                EJBWrapper.validateInterfaceBasics(local, EJBWrapperType.BUSINESS_LOCAL, beanName);
            }
        }
        if (ejbClass != null) {
            EJBUtils.validateEjbClass(ejbClass, beanName, beanType);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "validateInterfaceBasics : " + beanName);
        }
    }

    public static Class generateEJBWrapper(ClassLoader classLoader, String wrapperClassName, Class wrapperInterface, EJBWrapperType wrapperType, Method[] allMethods, EJBMethodInfoImpl[] methodInfos, String ejbClassName, String beanName) throws ClassNotFoundException, EJBConfigurationException {
        Class rtnClass = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "generateEJBWrapper: " + wrapperClassName + " : " + beanName);
        }
        try {
            byte[] classbytes = EJBWrapper.generateClassBytes(wrapperClassName, wrapperInterface, wrapperType, allMethods, methodInfos, ejbClassName, beanName);
            CompoundClassLoader appcl = (CompoundClassLoader)classLoader;
            rtnClass = appcl.defineApplicationClass(wrapperClassName, classbytes);
        }
        catch (EJBConfigurationException ejbex) {
            FFDCFilter.processException((Throwable)ejbex, (String)(CLASS_NAME + ".generateEJBWrapper"), (String)"110");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "generateEJBWrapper failed: " + ejbex.getMessage());
            }
            throw ejbex;
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".generateEJBWrapper"), (String)"119");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "generateEJBWrapper failed: " + ex.getMessage());
            }
            throw new ClassNotFoundException(wrapperClassName + " : " + ex.getMessage(), ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "generateEJBWrapper: " + rtnClass);
        }
        return rtnClass;
    }

    public static Class generate_Tie(ClassLoader classLoader, String remoteClassName, Class remoteInterface, String beanName) throws ClassNotFoundException, EJBConfigurationException {
        Class rtnClass = null;
        String tieClassName = JIT_Tie.getTieClassName(remoteClassName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "generate_Tie: " + tieClassName + " : " + beanName);
        }
        Method[] remoteMethods = remoteInterface.getMethods();
        String[] idlNames = RMItoIDL.getIdlMethodNames(remoteMethods);
        try {
            byte[] classbytes = JIT_Tie.generateClassBytes(tieClassName, remoteClassName, remoteInterface, remoteMethods, idlNames);
            CompoundClassLoader appcl = (CompoundClassLoader)classLoader;
            rtnClass = appcl.defineApplicationClass(tieClassName, classbytes);
        }
        catch (EJBConfigurationException ejbex) {
            FFDCFilter.processException((Throwable)ejbex, (String)(CLASS_NAME + ".generate_Tie"), (String)"110");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "generate_Tie failed: " + ejbex.getMessage());
            }
            throw ejbex;
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".generate_Tie"), (String)"119");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "generate_Tie failed: " + ex.getMessage());
            }
            throw new ClassNotFoundException(tieClassName + " : " + ex.getMessage(), ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "generate_Tie: " + rtnClass);
        }
        return rtnClass;
    }

    public static String getStubClassName(Class remoteInterface) {
        return JIT_Stub.getStubClassName(remoteInterface.getName());
    }

    public static byte[] generate_StubBytes(Class remoteInterface) throws EJBConfigurationException {
        String stubClassName = JIT_Stub.getStubClassName(remoteInterface.getName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "generate_StubBytes: " + stubClassName);
        }
        Method[] remoteMethods = remoteInterface.getMethods();
        String[] idlNames = RMItoIDL.getIdlMethodNames(remoteMethods);
        byte[] classbytes = JIT_Stub.generateClassBytes(stubClassName, remoteInterface, remoteMethods, idlNames);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "generate_StubBytes: " + stubClassName + ":" + classbytes.length);
        }
        return classbytes;
    }

    static Class generate_Stub(ClassLoader classLoader, Class remoteInterface, Method[] remoteMethods, String[] idlNames) throws ClassNotFoundException, EJBConfigurationException {
        Class rtnClass = null;
        String stubClassName = JIT_Stub.getStubClassName(remoteInterface.getName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "generate_Stub: " + stubClassName);
        }
        try {
            rtnClass = classLoader.loadClass(stubClassName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "generate_Stub: already loaded: " + stubClassName);
            }
            return rtnClass;
        }
        catch (ClassNotFoundException cnfex) {
            try {
                byte[] classbytes = JIT_Stub.generateClassBytes(stubClassName, remoteInterface, remoteMethods, idlNames);
                CompoundClassLoader appcl = (CompoundClassLoader)classLoader;
                rtnClass = appcl.defineApplicationClass(stubClassName, classbytes);
            }
            catch (EJBConfigurationException ejbex) {
                FFDCFilter.processException((Throwable)ejbex, (String)(CLASS_NAME + ".generate_Stub"), (String)"110");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "generate_Stub failed: " + ejbex.getMessage());
                }
                throw ejbex;
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".generate_Stub"), (String)"119");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "generate_Stub failed: " + ex.getMessage());
                }
                throw new ClassNotFoundException(stubClassName + " : " + ex.getMessage(), ex);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "generate_Stub: " + rtnClass);
            }
            return rtnClass;
        }
    }

    public static final Class generateEJBHomeImplClass(ClassLoader classLoader, String homeClassName, Class remoteInterface, Class localInterface, Class ejbClass, Class pkeyClass, HashMap<String, String> initMethods, String beanName, int beanType) throws ClassNotFoundException, EJBConfigurationException {
        Class rtnClass = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "generateEJBHomeImplClass: " + homeClassName + " : " + beanName);
        }
        try {
            byte[] classbytes = EJBHomeImpl.generateClassBytes(homeClassName, remoteInterface, localInterface, ejbClass, pkeyClass, initMethods, beanName, beanType);
            CompoundClassLoader appcl = (CompoundClassLoader)classLoader;
            rtnClass = appcl.defineApplicationClass(homeClassName, classbytes);
        }
        catch (EJBConfigurationException ejbex) {
            FFDCFilter.processException((Throwable)ejbex, (String)(CLASS_NAME + ".generateEJBHomeImplClass"), (String)"476");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "generateEJBHomeImplClass failed: " + ejbex.getMessage());
            }
            throw ejbex;
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".generateEJBHomeImplClass"), (String)"195");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "generateEJBHomeImplClass failed: " + ex.getMessage());
            }
            throw new ClassNotFoundException(homeClassName + " : " + ex.getMessage(), ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "generateEJBHomeImplClass: " + rtnClass);
        }
        return rtnClass;
    }

    public static Class generateWSEJBProxy(ClassLoader classLoader, String proxyClassName, Class proxyInterface, Method[] proxyMethods, EJBMethodInfoImpl[] methodInfos, String ejbClassName, String beanName) throws ClassNotFoundException, EJBConfigurationException {
        Class rtnClass = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "generateWSEJBProxy: " + proxyClassName + " : " + beanName);
        }
        try {
            byte[] classbytes = WSEJBProxy.generateClassBytes(proxyClassName, proxyInterface, proxyMethods, methodInfos, ejbClassName, beanName);
            CompoundClassLoader appcl = (CompoundClassLoader)classLoader;
            rtnClass = appcl.defineApplicationClass(proxyClassName, classbytes);
        }
        catch (EJBConfigurationException ejbex) {
            FFDCFilter.processException((Throwable)ejbex, (String)(CLASS_NAME + ".generateWSEJBProxy"), (String)"536");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "generateWSEJBProxy failed: " + ejbex.getMessage());
            }
            throw ejbex;
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".generateWSEJBProxy"), (String)"545");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "generateWSEJBProxy failed: " + ex.getMessage());
            }
            throw new ClassNotFoundException(proxyClassName + " : " + ex.getMessage(), ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "generateWSEJBProxy: " + rtnClass);
        }
        return rtnClass;
    }
}

