/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.jitdeploy;

import com.ibm.ejs.container.ContainerEJBException;
import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.container.EJBMethodInfoImpl;
import com.ibm.ejs.container.util.DeploymentUtil;
import com.ibm.ejs.container.util.MethodAttribUtils;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.jitdeploy.EJBUtils;
import com.ibm.ws.ejbcontainer.jitdeploy.EJBWrapperType;
import com.ibm.ws.ejbcontainer.jitdeploy.JITUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class EJBWrapper {
    private static final String CLASS_NAME = EJBWrapper.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "JITDeploy", "com.ibm.ejs.container.container");
    static final Type TYPE_EJSDeployedSupport = Type.getType((String)"Lcom/ibm/ejs/container/EJSDeployedSupport;");
    static final Type TYPE_RemoteException = Type.getType((String)"Ljava/rmi/RemoteException;");

    static byte[] generateClassBytes(String wrapperClassName, Class wrapperInterface, EJBWrapperType wrapperType, java.lang.reflect.Method[] allMethods, EJBMethodInfoImpl[] methodInfos, String ejbClassName, String beanName) throws EJBConfigurationException {
        boolean isHomeWrapper = wrapperType == EJBWrapperType.REMOTE_HOME || wrapperType == EJBWrapperType.LOCAL_HOME;
        String internalClassName = JITUtils.convertClassName(wrapperClassName);
        String internalInterfaceName = JITUtils.convertClassName(wrapperInterface.getName());
        String internalEJBClassName = JITUtils.convertClassName(ejbClassName);
        String internalParentName = EJBWrapper.getParentClassName(wrapperType);
        boolean isRmiRemote = Remote.class.isAssignableFrom(wrapperInterface);
        if (TraceComponent.isAnyTracingEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "generateClassBytes");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "     className = " + internalClassName);
                Tr.debug(tc, "     interface = " + internalInterfaceName);
                Tr.debug(tc, "     parent    = " + internalParentName);
                Tr.debug(tc, "     ejb       = " + internalEJBClassName);
                if (isRmiRemote) {
                    Tr.debug(tc, "     implements java.rmi.Remote");
                }
            }
        }
        EJBWrapper.validateInterfaceBasics(wrapperInterface, wrapperType, ejbClassName);
        ClassWriter cw = new ClassWriter(true);
        cw.visit(46, 33, internalClassName, null, internalParentName, new String[]{internalInterfaceName});
        String sourceFileName = wrapperClassName.substring(wrapperClassName.lastIndexOf(".") + 1) + ".java";
        cw.visitSource(sourceFileName, null);
        EJBWrapper.addCtor(cw, internalParentName);
        java.lang.reflect.Method[] methods = isHomeWrapper ? allMethods : DeploymentUtil.getMethods(wrapperInterface, null);
        int methodId = -1;
        for (int i = 0; i < methods.length; ++i) {
            java.lang.reflect.Method method = methods[i];
            String implMethodName = method.getName();
            if (isHomeWrapper && !isRmiRemote && (implMethodName.startsWith("create") || implMethodName.startsWith("find"))) {
                implMethodName = implMethodName + "_Local";
            }
            if (!isHomeWrapper && implMethodName.startsWith("ejb")) {
                Tr.error(tc, "JIT_INVALID_MTHD_PREFIX_CNTR5010E", new Object[]{beanName, wrapperInterface.getName(), implMethodName});
                throw new EJBConfigurationException("EJB business method " + implMethodName + " on interface " + wrapperInterface.getName() + " must not start with 'ejb'.");
            }
            ++methodId;
            EJBMethodInfoImpl methodInfo = methodInfos[methodId = EJBUtils.getMethodId(method, allMethods, methodId)];
            boolean aroundInvoke = methodInfo.getAroundInvokeInterceptorProxies() != null;
            boolean isStatelessCreate = methodInfo.isHomeCreate() && methodInfo.isStatelessSessionBean();
            EJBWrapper.addEJBMethod(cw, internalClassName, internalEJBClassName, method, implMethodName, methodId, isRmiRemote, aroundInvoke, isStatelessCreate);
        }
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JITUtils.writeToClassFile(internalClassName, classBytes);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "generateClassBytes: " + classBytes.length + " bytes");
        }
        return classBytes;
    }

    private static void addCtor(ClassWriter cw, String parent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "     adding method : <init> ()V");
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, parent, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void addEJBMethod(ClassWriter cw, String className, String implClassName, java.lang.reflect.Method method, String implMethodName, int methodId, boolean isRmiRemote, boolean aroundInvoke, boolean isStatelessCreate) throws EJBConfigurationException {
        String setUncheckedException;
        String methodName = method.getName();
        String methodSignature = MethodAttribUtils.jdiMethodSignature(method);
        String EjbPreInvoke = isStatelessCreate ? "EjbPreInvokeForStatelessCreate" : "EjbPreInvoke";
        String EjbPostInvoke = isStatelessCreate ? "EjbPostInvokeForStatelessCreate" : "postInvoke";
        String string = setUncheckedException = isRmiRemote ? "setUncheckedException" : "setUncheckedLocalException";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "     adding method : " + methodName + " " + methodSignature + " : aroundInvoke = " + aroundInvoke);
        }
        Class[] methodExceptions = method.getExceptionTypes();
        Class<?>[] checkedExceptions = JITUtils.getCheckedExceptions(method, isRmiRemote, true);
        Type returnType = Type.getType(method.getReturnType());
        Type[] argTypes = JITUtils.getTypes(method.getParameterTypes());
        Type[] exceptionTypes = JITUtils.getTypes(methodExceptions);
        Method m = new Method(methodName, returnType, argTypes);
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, exceptionTypes, (ClassVisitor)cw);
        mg.visitCode();
        int s = mg.newLocal(TYPE_EJSDeployedSupport);
        mg.loadThis();
        mg.visitFieldInsn(180, className, "container", "Lcom/ibm/ejs/container/EJSContainer;");
        mg.loadThis();
        mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSContainer", "getEJSDeployedSupport", "(Lcom/ibm/ejs/container/EJSWrapperBase;)Lcom/ibm/ejs/container/EJSDeployedSupport;");
        mg.storeLocal(s);
        int returnValue = -1;
        if (returnType != Type.VOID_TYPE) {
            returnValue = mg.newLocal(returnType);
            switch (returnType.getSort()) {
                case 1: {
                    mg.push(false);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    mg.push(0);
                    break;
                }
                case 6: {
                    mg.push(0.0f);
                    break;
                }
                case 7: {
                    mg.push(0L);
                    break;
                }
                case 8: {
                    mg.push(0.0);
                    break;
                }
                default: {
                    mg.visitInsn(1);
                }
            }
            mg.storeLocal(returnValue);
        }
        Label main_try_begin = new Label();
        mg.visitLabel(main_try_begin);
        Label if_JaccArgs_End = null;
        int args = mg.newLocal(JITUtils.TYPE_Object_ARRAY);
        if (!aroundInvoke) {
            mg.visitInsn(1);
            mg.storeLocal(args);
            mg.loadThis();
            mg.visitFieldInsn(180, className, "container", "Lcom/ibm/ejs/container/EJSContainer;");
            mg.loadThis();
            mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSContainer", "doesJaccNeedsEJBArguments", "(Lcom/ibm/ejs/container/EJSWrapperBase;)Z");
            if_JaccArgs_End = new Label();
            mg.visitJumpInsn(153, if_JaccArgs_End);
        }
        mg.push(argTypes.length);
        mg.visitTypeInsn(189, "java/lang/Object");
        mg.storeLocal(args);
        for (int i = 0; i < argTypes.length; ++i) {
            mg.loadLocal(args);
            mg.push(i);
            switch (argTypes[i].getSort()) {
                case 1: {
                    mg.visitTypeInsn(187, "java/lang/Boolean");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Boolean", "<init>", "(Z)V");
                    break;
                }
                case 2: {
                    mg.visitTypeInsn(187, "java/lang/Character");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Character", "<init>", "(C)V");
                    break;
                }
                case 3: {
                    mg.visitTypeInsn(187, "java/lang/Byte");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Byte", "<init>", "(B)V");
                    break;
                }
                case 4: {
                    mg.visitTypeInsn(187, "java/lang/Short");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Short", "<init>", "(S)V");
                    break;
                }
                case 5: {
                    mg.visitTypeInsn(187, "java/lang/Integer");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Integer", "<init>", "(I)V");
                    break;
                }
                case 6: {
                    mg.visitTypeInsn(187, "java/lang/Float");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Float", "<init>", "(F)V");
                    break;
                }
                case 7: {
                    mg.visitTypeInsn(187, "java/lang/Long");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Long", "<init>", "(J)V");
                    break;
                }
                case 8: {
                    mg.visitTypeInsn(187, "java/lang/Double");
                    mg.visitInsn(89);
                    mg.loadArg(i);
                    mg.visitMethodInsn(183, "java/lang/Double", "<init>", "(D)V");
                    break;
                }
                default: {
                    mg.loadArg(i);
                }
            }
            mg.visitInsn(83);
        }
        if (!aroundInvoke) {
            mg.visitLabel(if_JaccArgs_End);
        }
        Type implType = Type.getType((String)("L" + implClassName + ";"));
        int bean = mg.newLocal(implType);
        mg.loadThis();
        mg.visitFieldInsn(180, className, "container", "Lcom/ibm/ejs/container/EJSContainer;");
        mg.loadThis();
        mg.push(methodId);
        mg.loadLocal(s);
        mg.loadLocal(args);
        mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSContainer", EjbPreInvoke, "(Lcom/ibm/ejs/container/EJSWrapperBase;ILcom/ibm/ejs/container/EJSDeployedSupport;[Ljava/lang/Object;)Ljava/lang/Object;");
        mg.checkCast(implType);
        mg.storeLocal(bean);
        if (aroundInvoke) {
            mg.loadThis();
            mg.visitFieldInsn(180, className, "container", "Lcom/ibm/ejs/container/EJSContainer;");
            mg.loadLocal(s);
            mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSContainer", "invoke", "(Lcom/ibm/ejs/container/EJSDeployedSupport;)Ljava/lang/Object;");
            if (returnType == Type.VOID_TYPE) {
                mg.pop();
            } else {
                JITUtils.unbox(mg, returnType);
                mg.storeLocal(returnValue);
            }
        } else {
            mg.loadLocal(bean);
            mg.loadArgs(0, argTypes.length);
            mg.visitMethodInsn(182, implClassName, implMethodName, m.getDescriptor());
            if (returnType != Type.VOID_TYPE) {
                mg.storeLocal(returnValue);
            }
        }
        Label main_try_end = new Label();
        mg.visitLabel(main_try_end);
        Label main_finally_begin = new Label();
        mg.visitJumpInsn(168, main_finally_begin);
        Label main_tcf_exit = new Label();
        mg.visitJumpInsn(167, main_tcf_exit);
        Label[] main_catch_label = new Label[checkedExceptions.length];
        int caught_ex = mg.newLocal(JITUtils.TYPE_Exception);
        for (int i = 0; i < checkedExceptions.length; ++i) {
            main_catch_label[i] = new Label();
            mg.visitLabel(main_catch_label[i]);
            mg.storeLocal(caught_ex);
            mg.loadLocal(s);
            mg.loadLocal(caught_ex);
            mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSDeployedSupport", "setCheckedException", "(Ljava/lang/Exception;)V");
            mg.loadLocal(caught_ex);
            mg.visitInsn(191);
        }
        Label main_catch_throwable = new Label();
        mg.visitLabel(main_catch_throwable);
        int main_th = mg.newLocal(JITUtils.TYPE_Throwable);
        mg.storeLocal(main_th);
        mg.loadLocal(s);
        mg.loadLocal(main_th);
        mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSDeployedSupport", setUncheckedException, "(Ljava/lang/Throwable;)V");
        mg.visitJumpInsn(168, main_finally_begin);
        mg.visitJumpInsn(167, main_tcf_exit);
        Label main_finally_ex = new Label();
        mg.visitLabel(main_finally_ex);
        int main_finally_th = mg.newLocal(JITUtils.TYPE_Throwable);
        mg.storeLocal(main_finally_th);
        mg.visitJumpInsn(168, main_finally_begin);
        mg.loadLocal(main_finally_th);
        mg.visitInsn(191);
        mg.visitLabel(main_finally_begin);
        int main_finally_return = mg.newLocal(JITUtils.TYPE_Object);
        mg.storeLocal(main_finally_return);
        Label finally_try_begin = new Label();
        mg.visitLabel(finally_try_begin);
        mg.loadThis();
        mg.visitFieldInsn(180, className, "container", "Lcom/ibm/ejs/container/EJSContainer;");
        mg.loadThis();
        mg.push(methodId);
        mg.loadLocal(s);
        mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSContainer", EjbPostInvoke, "(Lcom/ibm/ejs/container/EJSWrapperBase;ILcom/ibm/ejs/container/EJSDeployedSupport;)V");
        Label finally_try_end = new Label();
        mg.visitLabel(finally_try_end);
        Label finally_finally_begin = new Label();
        mg.visitJumpInsn(168, finally_finally_begin);
        Label finally_tcf_exit = new Label();
        mg.visitJumpInsn(167, finally_tcf_exit);
        Label finally_catch_remote = new Label();
        if (!isRmiRemote) {
            mg.visitLabel(finally_catch_remote);
            int finally_remote = mg.newLocal(TYPE_RemoteException);
            mg.storeLocal(finally_remote);
            mg.loadLocal(s);
            mg.loadLocal(finally_remote);
            mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSDeployedSupport", "setUncheckedLocalException", "(Ljava/lang/Throwable;)V");
            mg.visitJumpInsn(168, finally_finally_begin);
            mg.visitJumpInsn(167, finally_tcf_exit);
        }
        Label finally_finally_ex = new Label();
        mg.visitLabel(finally_finally_ex);
        int finally_finally_th = mg.newLocal(JITUtils.TYPE_Throwable);
        mg.storeLocal(finally_finally_th);
        mg.visitJumpInsn(168, finally_finally_begin);
        mg.loadLocal(finally_finally_th);
        mg.throwException();
        mg.visitLabel(finally_finally_begin);
        int finally_finally_return = mg.newLocal(JITUtils.TYPE_Object);
        mg.storeLocal(finally_finally_return);
        mg.loadThis();
        mg.visitFieldInsn(180, className, "container", "Lcom/ibm/ejs/container/EJSContainer;");
        mg.loadLocal(s);
        mg.visitMethodInsn(182, "com/ibm/ejs/container/EJSContainer", "putEJSDeployedSupport", "(Lcom/ibm/ejs/container/EJSDeployedSupport;)V");
        mg.ret(finally_finally_return);
        mg.visitLabel(finally_tcf_exit);
        mg.ret(main_finally_return);
        mg.visitLabel(main_tcf_exit);
        if (returnType != Type.VOID_TYPE) {
            mg.loadLocal(returnValue);
        }
        mg.returnValue();
        for (int i = 0; i < checkedExceptions.length; ++i) {
            mg.visitTryCatchBlock(main_try_begin, main_try_end, main_catch_label[i], JITUtils.convertClassName(checkedExceptions[i].getName()));
        }
        mg.visitTryCatchBlock(main_try_begin, main_try_end, main_catch_throwable, "java/lang/Throwable");
        mg.visitTryCatchBlock(main_try_begin, main_finally_ex, main_finally_ex, null);
        if (!isRmiRemote) {
            mg.visitTryCatchBlock(finally_try_begin, finally_try_end, finally_catch_remote, "java/rmi/RemoteException");
        }
        mg.visitTryCatchBlock(finally_try_begin, finally_finally_ex, finally_finally_ex, null);
        mg.endMethod();
        mg.visitEnd();
    }

    private static String getParentClassName(EJBWrapperType wrapperType) {
        String internalParentName = null;
        if (wrapperType == EJBWrapperType.REMOTE || wrapperType == EJBWrapperType.REMOTE_HOME) {
            internalParentName = "com/ibm/ejs/container/EJSWrapper";
        } else if (wrapperType == EJBWrapperType.LOCAL || wrapperType == EJBWrapperType.LOCAL_HOME) {
            internalParentName = "com/ibm/ejs/container/EJSLocalWrapper";
        } else if (wrapperType == EJBWrapperType.BUSINESS_LOCAL) {
            internalParentName = "com/ibm/ejs/container/BusinessLocalWrapper";
        } else if (wrapperType == EJBWrapperType.BUSINESS_REMOTE) {
            internalParentName = "com/ibm/ejs/container/BusinessRemoteWrapper";
        } else {
            throw new ContainerEJBException("EJBContainer internal error: Wrapper Type not supported: " + (Object)((Object)wrapperType));
        }
        return internalParentName;
    }

    static void validateInterfaceBasics(Class wrapperInterface, EJBWrapperType wrapperType, String beanName) throws EJBConfigurationException {
        if (!Modifier.isInterface(wrapperInterface.getModifiers())) {
            Tr.error(tc, "JIT_INTERFACE_NOT_INTERFACE_CNTR5011E", new Object[]{beanName, wrapperInterface.getName()});
            throw new EJBConfigurationException("Configured " + (Object)((Object)wrapperType) + " interface is not an interface : " + wrapperInterface.getName() + " of bean " + beanName);
        }
        if (wrapperType == EJBWrapperType.BUSINESS_LOCAL || wrapperType == EJBWrapperType.BUSINESS_REMOTE) {
            Class invalidExtends = EJBWrapper.getInvalidBusinessExtends(wrapperInterface);
            if (invalidExtends != null) {
                Tr.error(tc, "JIT_INVALID_EXTENDS_JAVAX_EJB_CNTR5012E", new Object[]{beanName, wrapperInterface.getName(), invalidExtends.getName()});
                throw new EJBConfigurationException("Configured " + (Object)((Object)wrapperType) + " interface extends " + invalidExtends.getName() + " : " + wrapperInterface.getName() + " of bean " + beanName);
            }
            if (wrapperType == EJBWrapperType.BUSINESS_LOCAL && Remote.class.isAssignableFrom(wrapperInterface)) {
                Tr.error(tc, "JIT_INVALID_EXTENDS_REMOTE_CNTR5013E", new Object[]{beanName, wrapperInterface.getName()});
                throw new EJBConfigurationException("Configured " + (Object)((Object)wrapperType) + " interface extends " + "javax.rmi.Remote : " + wrapperInterface.getName() + " of bean " + beanName);
            }
        } else if (wrapperType == EJBWrapperType.LOCAL) {
            if (!EJBLocalObject.class.isAssignableFrom(wrapperInterface)) {
                Tr.error(tc, "JIT_MUST_EXTEND_EJBLOCAL_CNTR5014E", new Object[]{beanName, wrapperInterface.getName()});
                throw new EJBConfigurationException("Configured " + (Object)((Object)wrapperType) + " interface does not extend " + EJBLocalObject.class.getName() + " : " + wrapperInterface.getName() + " of bean " + beanName);
            }
        } else if (wrapperType == EJBWrapperType.REMOTE) {
            if (!EJBObject.class.isAssignableFrom(wrapperInterface)) {
                Tr.error(tc, "JIT_MUST_EXTEND_EJBOBJECT_CNTR5015E", new Object[]{beanName, wrapperInterface.getName()});
                throw new EJBConfigurationException("Configured " + (Object)((Object)wrapperType) + " interface does not extend " + EJBObject.class.getName() + " : " + wrapperInterface.getName() + " of bean " + beanName);
            }
        } else if (wrapperType == EJBWrapperType.SERVICE_ENDPOINT && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Field[] fields;
            if (!Remote.class.isAssignableFrom(wrapperInterface)) {
                Tr.debug(tc, "Configured " + (Object)((Object)wrapperType) + " interface does not         extend " + Remote.class.getName() + " : " + wrapperInterface.getName() + " of bean " + beanName);
            }
            for (Field field : fields = wrapperInterface.getFields()) {
                int modifier = field.getModifiers();
                if (!Modifier.isStatic(modifier) || !Modifier.isFinal(modifier)) continue;
                Tr.debug(tc, "Configured " + (Object)((Object)wrapperType) + " interface declares a constant : " + field.getName() + " on " + wrapperInterface.getName() + " of bean " + beanName);
            }
        }
    }

    private static Class getInvalidBusinessExtends(Class wrapperInterface) {
        if (EJBLocalObject.class.isAssignableFrom(wrapperInterface)) {
            return EJBLocalObject.class;
        }
        if (EJBLocalHome.class.isAssignableFrom(wrapperInterface)) {
            return EJBLocalHome.class;
        }
        if (EJBObject.class.isAssignableFrom(wrapperInterface)) {
            return EJBObject.class;
        }
        if (EJBHome.class.isAssignableFrom(wrapperInterface)) {
            return EJBHome.class;
        }
        return null;
    }
}

