/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.jitdeploy;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.jitdeploy.JITUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.ejb.EntityBean;

public final class EJBUtils {
    private static final String CLASS_NAME = EJBUtils.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "JITDeploy", "com.ibm.ejs.container.container");

    static int getMethodId(Method method, Method[] allMethods, int startIndex) {
        int i;
        int numMethods = allMethods.length;
        for (i = startIndex; i < numMethods; ++i) {
            if (!EJBUtils.methodsMatch(method, allMethods[i])) continue;
            return i;
        }
        for (i = 0; i < startIndex; ++i) {
            if (!EJBUtils.methodsMatch(method, allMethods[i])) continue;
            return i;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getMethodId: start = " + startIndex);
            Tr.debug(tc, "getMethodId: method = " + method);
            for (i = 0; i < numMethods; ++i) {
                Tr.debug(tc, "getMethodId: [" + i + "] = " + allMethods[i]);
            }
        }
        throw new RuntimeException("Internal Error: Method not found: " + method);
    }

    private static boolean methodsMatch(Method m1, Method m2) {
        Class<?>[] parms2;
        Class<?>[] parms1;
        if (m1 == m2) {
            return true;
        }
        if (m1.getName().equals(m2.getName()) && (parms1 = m1.getParameterTypes()).length == (parms2 = m2.getParameterTypes()).length) {
            int length = parms1.length;
            for (int i = 0; i < length; ++i) {
                if (parms1[i] == parms2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static void validateEjbClass(Class ejbClass, String beanName, int beanType) throws EJBConfigurationException {
        int modifiers = ejbClass.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            Tr.error(tc, "JIT_NON_PUBLIC_CLASS_CNTR5003E", new Object[]{beanName, ejbClass.getName()});
            throw new EJBConfigurationException("EJB class " + ejbClass.getName() + " must be defined as public : " + beanName);
        }
        if (Modifier.isFinal(modifiers)) {
            Tr.error(tc, "JIT_INVALID_FINAL_CLASS_CNTR5004E", new Object[]{beanName, ejbClass.getName()});
            throw new EJBConfigurationException("EJB class " + ejbClass.getName() + " must not be defined as final : " + beanName);
        }
        if (beanType != 5 && Modifier.isAbstract(modifiers)) {
            Tr.error(tc, "JIT_INVALID_ABSTRACT_CLASS_CNTR5005E", new Object[]{beanName, ejbClass.getName()});
            throw new EJBConfigurationException("EJB class " + ejbClass.getName() + " must not be defined as abstract : " + beanName);
        }
        if (ejbClass.getEnclosingClass() != null) {
            Tr.error(tc, "JIT_NOT_TOP_LEVEL_CLASS_CNTR5006E", new Object[]{beanName, ejbClass.getName()});
            throw new EJBConfigurationException("EJB class " + ejbClass.getName() + " must be a top level class : " + beanName);
        }
        try {
            ejbClass.getConstructor(JITUtils.NO_PARAMS);
        }
        catch (Throwable ex) {
            Tr.error(tc, "JIT_NO_DEFAULT_CTOR_CNTR5007E", new Object[]{beanName, ejbClass.getName()});
            throw new EJBConfigurationException("EJB class " + ejbClass.getName() + " must have a public constructor that takes no parameters : " + beanName, ex);
        }
        try {
            ejbClass.getDeclaredMethod("finalize", JITUtils.NO_PARAMS);
            Tr.error(tc, "JIT_INVALID_FINALIZE_MTHD_CNTR5008E", new Object[]{beanName, ejbClass.getName()});
            throw new EJBConfigurationException("EJB class " + ejbClass.getName() + " must not define the finalize() method : " + beanName);
        }
        catch (Throwable ex) {
            if (!(beanType != 4 && beanType != 5 || EntityBean.class.isAssignableFrom(ejbClass))) {
                Tr.error(tc, "JIT_MISSING_ENTITYBEAN_CNTR5009E", new Object[]{beanName, ejbClass.getName()});
                throw new EJBConfigurationException("EJB Entity class " + ejbClass.getName() + " must implement javax.ejb.EntityBean : " + beanName);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "validateEjbClass : successful : " + ejbClass.getName());
            }
            return;
        }
    }
}

