/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.injection.factory;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.EJSWrapper;
import com.ibm.ejs.container.EJSWrapperForBasicSFSBHome;
import com.ibm.ejs.container.HomeOfHomes;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.SetContextClassLoaderPrivileged;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.ws.ejbcontainer.injection.factory.EJBLinkInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.util.NullRefAddrException;
import com.ibm.ws.runtime.component.EJBContainerImpl;
import com.ibm.ws.runtime.component.EJBContainerImpl_threadLocal;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.ImplFactory;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionUtil;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.rmi.PortableRemoteObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBLinkObjectFactory
implements ObjectFactory {
    private static final String CLASS_NAME = EJBLinkObjectFactory.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJBContainer", "com.ibm.ejs.container.container");
    private static final J2EENameFactory J2EENAME_FACTORY = (J2EENameFactory)ImplFactory.loadImplFromKey(J2EENameFactory.class);

    public EJBLinkObjectFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        ClassLoader classLoader;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectInstance : " + obj);
        }
        Object retObj = null;
        if (!(obj instanceof Reference)) {
            InjectionException inex = new InjectionException("Binding object is not a Reference : " + obj);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) throw inex;
            Tr.exit(tc, "getObjectInstance : " + (Object)((Object)inex));
            throw inex;
        }
        Reference ref = (Reference)obj;
        if (!ref.getFactoryClassName().equals(CLASS_NAME)) {
            InjectionException inex = new InjectionException("Incorrect factory for Reference : " + obj);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) throw inex;
            Tr.exit(tc, "getObjectInstance : " + (Object)((Object)inex));
            throw inex;
        }
        RefAddr addr = ref.get("EJBLinkInfo");
        if (addr == null) {
            NullRefAddrException ne = new NullRefAddrException("The address for this Reference is empty (null)");
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) throw ne;
            Tr.exit(tc, "getObjectInstance : " + ne);
            throw ne;
        }
        EJBLinkInfo info = (EJBLinkInfo)addr.getContent();
        EJSHome home = info.ivHome;
        if (home == null) {
            HomeOfHomes homeOfHomes = EJSContainer.homeOfHomes;
            if (info.ivBeanName != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "bean name specified (" + info.ivBeanName + "), looking for home in same/specified module...");
                }
                String module = info.ivModule;
                String bean = info.ivBeanName;
                int bidx = bean.indexOf(35);
                if (bidx > -1) {
                    int midx = bean.lastIndexOf(47);
                    module = midx > -1 && midx < bidx ? bean.substring(midx + 1, bidx) : bean.substring(0, bidx);
                    bean = bean.substring(bidx + 1);
                }
                if (module.endsWith(".jar")) {
                    J2EEName j2eeName = J2EENAME_FACTORY.create(info.ivApplication, module, bean);
                    home = (EJSHome)homeOfHomes.getHome(j2eeName);
                } else if (module != info.ivModule) {
                    throw new InjectionConfigurationException("Incorrect ejb-link/beanName syntax: " + bean + " : module name must end with .jar : " + module);
                }
                if (home == null && module == info.ivModule) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "looking for home in other modules...");
                    }
                    home = homeOfHomes.getHomeByName(info.ivApplication, bean);
                }
            } else {
                String beanInterface;
                String string = beanInterface = info.ivHomeInterface != null ? info.ivHomeInterface : info.ivBeanInterface;
                if (beanInterface != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "bean name not specified, auto-link on " + beanInterface);
                    }
                    home = homeOfHomes.getHomeByInterface(info.ivApplication, info.ivModule, beanInterface);
                }
            }
            if (home == null) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) throw new InjectionException("EJB Reference could not be resolved");
                Tr.exit(tc, "EJB Reference could not be resolved");
                throw new InjectionException("EJB Reference could not be resolved");
            }
            info.ivHome = home;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "home = " + home.getJ2EEName());
        }
        if (info.ivHomeInterface != null) {
            if (info.ivIsLocalRef) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "configured for local home");
                }
                retObj = home.getWrapper().getLocalWrapper();
            } else {
                if (!info.ivIsRemoteRef) throw new InjectionException("Invalid configuration - home interface from annotation?");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "configured for remote home");
                }
                EJSWrapper wrapper = home.getWrapper().getRemoteWrapper();
                classLoader = home.getBeanMetaData().classLoader;
                retObj = EJBLinkObjectFactory.toStub(wrapper, classLoader);
            }
        } else {
            BeanMetaData bmd = home.getBeanMetaData();
            classLoader = bmd.classLoader;
            String businessInterfaceName = info.ivBeanInterface;
            Class businessClass = classLoader.loadClass(businessInterfaceName);
            if (info.ivIsLocalRef) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "configured for local business interface");
                }
                if (info.ivBeanName != null) {
                    businessClass = bmd.getSupportingLocalBusinessInterface(businessClass);
                }
                if ((retObj = this.createBusinessObject(home, businessClass)) instanceof Remote) {
                    throw new InjectionException("Use of ejb-local-ref for remote");
                }
            } else if (info.ivIsRemoteRef) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "configured for remote business interface");
                }
                if (info.ivBeanName != null) {
                    businessClass = bmd.getSupportingRemoteBusinessInterface(businessClass);
                }
                if (!((retObj = this.createBusinessObject(home, businessClass)) instanceof Remote)) throw new InjectionException("Use of ejb-ref for local");
                retObj = EJBLinkObjectFactory.toStub((Remote)retObj, classLoader);
            } else if (info.ivBeanInterface.equals(bmd.localHomeInterfaceClassName)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "match on local home");
                }
                retObj = home.getWrapper().getLocalWrapper();
            } else if (info.ivBeanInterface.equals(bmd.homeInterfaceClassName)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "match on remote home");
                }
                EJSWrapper wrapper = home.getWrapper().getRemoteWrapper();
                retObj = EJBLinkObjectFactory.toStub(wrapper, classLoader);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "looking for match on business interface");
                }
                if (info.ivBeanName != null) {
                    businessClass = bmd.getSupportingBusinessInterface(businessClass);
                }
                if ((retObj = this.createBusinessObject(home, businessClass)) instanceof Remote) {
                    retObj = EJBLinkObjectFactory.toStub((Remote)retObj, classLoader);
                }
            }
        }
        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) return retObj;
        Tr.exit(tc, "getObjectInstance : " + retObj.getClass().getName());
        return retObj;
    }

    private Object createBusinessObject(EJSHome home, Class businessInterface) throws InjectionException {
        try {
            if (home.isStatelessSessionHome()) {
                return home.createBusinessObject(businessInterface);
            }
            if (home.isStatefulSessionHome()) {
                EJSWrapperForBasicSFSBHome homeWrapper = home.getStatefulBusinessHomeWrapper();
                return homeWrapper.create(businessInterface);
            }
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".createBusinessObject"), (String)"281", (Object)this);
            String msg = "Failure creating instance of " + home.getJ2EEName() + " of type " + businessInterface.getName();
            InjectionException inex = InjectionUtil.checkForRecursiveException((Throwable)ex, (String)msg);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "createBusinessObject: " + (Object)((Object)inex));
            }
            throw inex;
        }
        InjectionException inex = new InjectionException("Unable to create instance of " + home.getJ2EEName() + " of type " + businessInterface.getName());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "createBusinessObject: " + (Object)((Object)inex));
        }
        throw inex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Remote toStub(Remote wrapper, ClassLoader classLoader) throws NoSuchObjectException {
        Remote remote;
        block5: {
            ClassLoader originalLoader = null;
            boolean resetClassLoader = false;
            SetContextClassLoaderPrivileged setCLPrivObj = ((EJBContainerImpl_threadLocal)EJBContainerImpl.svEJBContainerImpl_threadLocal.get()).ivClassLoaderChanger;
            try {
                setCLPrivObj.newClassLoader = classLoader;
                AccessController.doPrivileged((PrivilegedAction)setCLPrivObj);
                originalLoader = setCLPrivObj.oldClassLoader;
                resetClassLoader = setCLPrivObj.wasChanged;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    if (resetClassLoader) {
                        Tr.debug(tc, "toStub : old ClassLoader = " + originalLoader);
                        Tr.debug(tc, "toStub : new ClassLoader = " + classLoader);
                    } else {
                        Tr.debug(tc, "toStub : current ClassLoader = " + classLoader);
                    }
                }
                remote = PortableRemoteObject.toStub((Remote)wrapper);
                Object var7_6 = null;
                if (!resetClassLoader) break block5;
                setCLPrivObj.newClassLoader = originalLoader;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var7_7 = null;
                    if (!resetClassLoader) break block6;
                    setCLPrivObj.newClassLoader = originalLoader;
                    AccessController.doPrivileged((PrivilegedAction)setCLPrivObj);
                }
                throw throwable;
            }
            AccessController.doPrivileged((PrivilegedAction)setCLPrivObj);
        }
        return remote;
    }
}

