/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bundle;

import com.ibm.ws.bundle.CacheEntry;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class SimpleLRUCache {
    public static final int DEFAULT_MAX_CACHE_ENTRIES = 25;
    public static final int INFINITE_CACHE = -1;
    private HashMap cache = null;
    private int maxSize = 25;

    public SimpleLRUCache() {
        this.cache = new HashMap(25);
    }

    public SimpleLRUCache(int cacheSize) {
        this.cache = cacheSize == -1 ? new HashMap() : new HashMap(cacheSize);
        this.maxSize = cacheSize;
    }

    public void putEntry(String key, Object obj) {
        long time = System.currentTimeMillis();
        if (this.maxSize != -1 && this.cache.size() == this.maxSize) {
            this.removeLeastRecentlyUsed();
        }
        this.cache.put(key, new CacheEntry(obj, 1L, time));
    }

    public Object getEntry(String key) {
        CacheEntry entry = null;
        Object retVal = null;
        entry = (CacheEntry)this.cache.get(key);
        if (entry != null) {
            retVal = entry.getObject();
            entry.incrementAccess();
            entry.setLastAccessTime(System.currentTimeMillis());
        }
        return retVal;
    }

    public Object removeEntry(String key) {
        CacheEntry entry = null;
        Object retVal = null;
        entry = (CacheEntry)this.cache.remove(key);
        if (entry != null) {
            retVal = entry.getObject();
        }
        return retVal;
    }

    public int size() {
        return this.maxSize;
    }

    public int freeEntriesRemaining() {
        int remaining = this.maxSize - this.cache.size();
        if (remaining < 0) {
            remaining = 0;
        }
        return remaining;
    }

    public void resize(int size) {
        if (size > 0) {
            this.maxSize = size;
        } else if (size == -1) {
            this.maxSize = -1;
        }
    }

    public boolean containsEntry(String key) {
        return this.cache.containsKey(key);
    }

    public void printAccessInformation(PrintStream out) {
        Iterator keys;
        Set set;
        if (this.cache != null && out != null && (set = this.cache.keySet()) != null && (keys = set.iterator()) != null) {
            while (keys.hasNext()) {
                String key = (String)keys.next();
                out.println("Key [" + key + "] has been accessed: [" + ((CacheEntry)this.cache.get(key)).getAccessTimes() + "] times.");
            }
        }
    }

    private CacheEntry removeLeastAccessed() {
        Set set = null;
        String LeastAccessed = null;
        long LeastAccessedVal = 0L;
        Object retVal = null;
        set = this.cache.keySet();
        if (set != null) {
            Iterator it = set.iterator();
            while (it.hasNext()) {
                CacheEntry entry = null;
                String temp = (String)it.next();
                if (LeastAccessed != null) {
                    entry = (CacheEntry)this.cache.get(temp);
                    if (entry.getAccessTimes() >= LeastAccessedVal) continue;
                    LeastAccessed = temp;
                    LeastAccessedVal = entry.getAccessTimes();
                    continue;
                }
                LeastAccessed = temp;
                entry = (CacheEntry)this.cache.get(temp);
                LeastAccessedVal = entry.getAccessTimes();
            }
        }
        return (CacheEntry)this.cache.remove(LeastAccessed);
    }

    private CacheEntry removeLeastRecentlyUsed() {
        Set set = null;
        String OldestAccessed = null;
        long OldestAccessedVal = 0L;
        Object retVal = null;
        set = this.cache.keySet();
        if (set != null) {
            Iterator it = set.iterator();
            while (it.hasNext()) {
                CacheEntry entry = null;
                String temp = (String)it.next();
                if (OldestAccessed != null) {
                    entry = (CacheEntry)this.cache.get(temp);
                    if (entry.getLastAccessTime() >= OldestAccessedVal) continue;
                    OldestAccessed = temp;
                    OldestAccessedVal = entry.getLastAccessTime();
                    continue;
                }
                OldestAccessed = temp;
                entry = (CacheEntry)this.cache.get(temp);
                OldestAccessedVal = entry.getLastAccessTime();
            }
        }
        return (CacheEntry)this.cache.remove(OldestAccessed);
    }

    public Enumeration getKeys() {
        Iterator itr;
        Vector vect = new Vector();
        Set set = this.cache.keySet();
        if (set != null && (itr = set.iterator()) != null) {
            while (itr.hasNext()) {
                vect.add(itr.next());
            }
        }
        return vect.elements();
    }
}

