/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.wsaddressing.jaxws;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReference;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.websphere.wsaddressing.jaxws.SubmissionEndpointReference;
import com.ibm.websphere.wsaddressing.jaxws.W3CEndpointReference;
import com.ibm.ws.ffdc.FFDCFilter;

public abstract class EndpointReferenceConverter {
    private static EndpointReferenceConverter _delegatedHelper = null;
    private static final String CONCRETE_HELPER_CLASSNAME = "com.ibm.websphere.wsaddressing.jaxws.EndpointReferenceConverterImpl";
    private static final String CLASSNAME = "com.ibm.webshere.wsaddressing.jaxws.EndpointReferenceConverter";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(EndpointReferenceConverter.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");

    public static EndpointReference createIBMEndpointReference(W3CEndpointReference w3CEndpointReference) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createIBMEndpointReference", w3CEndpointReference);
        }
        EndpointReference endpointReference = _delegatedHelper.createIBMEndpointReferenceImpl(w3CEndpointReference);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createIBMEndpointReference", endpointReference);
        }
        return endpointReference;
    }

    public static EndpointReference createIBMEndpointReference(SubmissionEndpointReference submissionEndpointReference) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createIBMEndpointReference", submissionEndpointReference);
        }
        EndpointReference endpointReference = _delegatedHelper.createIBMEndpointReferenceImpl(submissionEndpointReference);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createIBMEndpointReference", endpointReference);
        }
        return endpointReference;
    }

    public static W3CEndpointReference createW3CEndpointReference(EndpointReference endpointReference) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createW3CEndpointReference", endpointReference);
        }
        W3CEndpointReference w3CEndpointReference = _delegatedHelper.createW3CEndpointReferenceImpl(endpointReference);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createW3CEndpointReference", w3CEndpointReference);
        }
        return w3CEndpointReference;
    }

    public static SubmissionEndpointReference createSubmissionEndpointReference(EndpointReference endpointReference) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createSubmissionEndpointReference", endpointReference);
        }
        SubmissionEndpointReference submissionEndpointReference = _delegatedHelper.createSubmissionEndpointReferenceImpl(endpointReference);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createSubmissionEndpointReference", submissionEndpointReference);
        }
        return submissionEndpointReference;
    }

    protected abstract EndpointReference createIBMEndpointReferenceImpl(W3CEndpointReference var1) throws EndpointReferenceCreationException;

    protected abstract EndpointReference createIBMEndpointReferenceImpl(SubmissionEndpointReference var1) throws EndpointReferenceCreationException;

    protected abstract W3CEndpointReference createW3CEndpointReferenceImpl(EndpointReference var1) throws EndpointReferenceCreationException;

    protected abstract SubmissionEndpointReference createSubmissionEndpointReferenceImpl(EndpointReference var1) throws EndpointReferenceCreationException;

    private static void traceAndFFDCException(Exception exception) {
        String string = exception.getClass().getName();
        String string2 = exception.getMessage();
        String string3 = "Caught a " + string + ": " + string2 + " when trying to create a new " + CONCRETE_HELPER_CLASSNAME + " instance within a static initializer";
        Tr.warning(TRACE_COMPONENT, string3);
        FFDCFilter.processException((Throwable)exception, (String)CLASSNAME, (String)"1:1.3:182");
    }

    static {
        try {
            _delegatedHelper = (EndpointReferenceConverter)Class.forName(CONCRETE_HELPER_CLASSNAME).newInstance();
        }
        catch (InstantiationException instantiationException) {
            EndpointReferenceConverter.traceAndFFDCException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            EndpointReferenceConverter.traceAndFFDCException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            EndpointReferenceConverter.traceAndFFDCException(classNotFoundException);
        }
    }
}

