/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ssl.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Properties;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;

public class SSLServerSocketFactory
extends javax.net.ssl.SSLServerSocketFactory {
    private static final TraceComponent tc = Tr.register(SSLServerSocketFactory.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private Properties props;
    private javax.net.ssl.SSLServerSocketFactory default_factory = null;
    private javax.net.ssl.SSLServerSocketFactory factory = null;
    private static SSLServerSocketFactory thisClass = null;

    public SSLServerSocketFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLServerSocketFactory");
        }
        try {
            this.props = SSLConfigManager.getInstance().getDefaultSystemProperties(true);
            if (this.props == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting default SSL properties from WebSphere configuration.");
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("com.ibm.ssl.direction", "inbound");
                this.props = JSSEHelper.getInstance().getProperties(null, hashMap, null);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting javax.net.ssl.* SSL System properties.");
            }
            this.factory = this.default_factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLServerSocketFactory");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLServerSocketFactory exception getting default SSL properties.", new Object[]{exception});
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.constructor", "90", new Object[]{this});
            this.factory = this.default_factory;
        }
    }

    public SSLServerSocketFactory(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLServerSocketFactory", new Object[]{string});
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.ssl.direction", "inbound");
            Properties properties = JSSEHelper.getInstance().getProperties(null, hashMap, null);
            this.default_factory = JSSEHelper.getInstance().getSSLServerSocketFactory(properties);
            this.props = JSSEHelper.getInstance().getProperties(string, hashMap, null);
            this.factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLServerSocketFactory");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLServerSocketFactory exception getting SSL properties from alias.", new Object[]{exception});
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.constructor(alias)", "126", new Object[]{this});
            this.factory = this.default_factory;
        }
    }

    public SSLServerSocketFactory(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLServerSocketFactory");
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.ssl.direction", "inbound");
            Properties properties2 = JSSEHelper.getInstance().getProperties(null, hashMap, null);
            this.default_factory = JSSEHelper.getInstance().getSSLServerSocketFactory(properties2);
            this.props = properties;
            this.factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLServerSocketFactory");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLServerSocketFactory exception getting SSL properties from properties.", new Object[]{exception});
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.constructor(sslprops)", "162", new Object[]{this});
            this.factory = this.default_factory;
        }
    }

    public SSLServerSocketFactory(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SSLServerSocketFactory", new Object[]{string, string2});
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.ssl.direction", "inbound");
            hashMap.put("com.ibm.ssl.endPointName", string2);
            Properties properties = JSSEHelper.getInstance().getProperties(null, hashMap, null);
            this.default_factory = JSSEHelper.getInstance().getSSLServerSocketFactory(properties);
            this.props = JSSEHelper.getInstance().getProperties(string, hashMap, null);
            this.factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SSLServerSocketFactory");
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSLServerSocketFactory exception getting SSL properties from selections.", new Object[]{exception});
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.constructor(alias, dynamicSelectionInfo, endPointName)", "204", new Object[]{this});
            this.factory = this.default_factory;
        }
    }

    public static ServerSocketFactory getDefault() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefault");
        }
        if (thisClass == null) {
            try {
                thisClass = new SSLServerSocketFactory();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SSLServerSocketFactory exception getting default socket factory.", new Object[]{exception});
                }
                Manager.Ffdc.log((Throwable)exception, SSLServerSocketFactory.class, "com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.getDefault", "229");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefault");
        }
        return thisClass;
    }

    public String[] getDefaultCipherSuites() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultCipherSuites");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultCipherSuites");
        }
        return this.default_factory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSupportedCipherSuites");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSupportedCipherSuites");
        }
        return this.default_factory.getSupportedCipherSuites();
    }

    public ServerSocket createServerSocket() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerSocket(0)");
        }
        SSLServerSocket sSLServerSocket = null;
        sSLServerSocket = (SSLServerSocket)this.default_factory.createServerSocket();
        sSLServerSocket = SSLConfigManager.getInstance().setCipherListOnServerSocket(this.props, sSLServerSocket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerSocket(0)");
        }
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerSocket(1)", new Object[]{new Integer(n)});
        }
        SSLServerSocket sSLServerSocket = null;
        try {
            if (this.factory == null) {
                this.factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLServerSocketFactory.", new Object[]{exception});
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.createServerSocket(2)", "306", new Object[]{this});
            this.factory = this.default_factory;
        }
        sSLServerSocket = (SSLServerSocket)this.factory.createServerSocket(n);
        sSLServerSocket = SSLConfigManager.getInstance().setCipherListOnServerSocket(this.props, sSLServerSocket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerSocket(1)");
        }
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerSocket(2)", new Object[]{new Integer(n), new Integer(n2)});
        }
        SSLServerSocket sSLServerSocket = null;
        try {
            if (this.factory == null) {
                this.factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLServerSocketFactory.", new Object[]{exception});
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.createServerSocket(3)", "341", new Object[]{this});
            this.factory = this.default_factory;
        }
        sSLServerSocket = (SSLServerSocket)this.factory.createServerSocket(n, n2);
        sSLServerSocket = SSLConfigManager.getInstance().setCipherListOnServerSocket(this.props, sSLServerSocket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerSocket(2)");
        }
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerSocket(3)", new Object[]{new Integer(n), new Integer(n2), inetAddress});
        }
        SSLServerSocket sSLServerSocket = null;
        try {
            if (this.factory == null) {
                this.factory = JSSEHelper.getInstance().getSSLServerSocketFactory(this.props);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSLServerSocketFactory.", new Object[]{exception});
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.ssl.protocol.SSLServerSocketFactory.createServerSocket(4)", "378", new Object[]{this});
            this.factory = this.default_factory;
        }
        sSLServerSocket = (SSLServerSocket)this.factory.createServerSocket(n, n2, inetAddress);
        sSLServerSocket = SSLConfigManager.getInstance().setCipherListOnServerSocket(this.props, sSLServerSocket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerSocket(3), not null");
        }
        return sSLServerSocket;
    }
}

